/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.commands;

import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.shell.Command;
import org.eclipse.virgo.kernel.shell.internal.formatting.ServiceCommandFormatter;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveService;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.eclipse.virgo.medic.log.EntryExitTrace;

@Command(value="service")
public final class ServiceCommands {
    private final StateService stateService;
    private final ServiceCommandFormatter formatter;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ServiceCommands(StateService stateService) {
        this.stateService = stateService;
        this.formatter = new ServiceCommandFormatter();
    }

    @Command(value="list")
    public List<String> list() {
        try {
            ServiceCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            List<String> list = this.formatter.formatList(this.stateService.getAllServices(null));
            ServiceCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            ServiceCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Command(value="examine")
    public List<String> examine(long serviceId) {
        try {
            ServiceCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            QuasiLiveService service = this.stateService.getService(null, serviceId);
            List<String> list = service == null ? Arrays.asList(String.format("No service with id '%s' was found", serviceId)) : this.formatter.formatExamine(service);
            ServiceCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return list;
        }
        catch (Throwable throwable) {
            ServiceCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ServiceCommands.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.commands.ServiceCommands"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.eclipse.virgo.kernel.shell.internal.commands.ServiceCommands", "", "", "", "java.util.List"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.kernel.shell.internal.commands.ServiceCommands", "long:", "serviceId:", "", "java.util.List"), 42);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.commands.ServiceCommands");
    }
}

