/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.authentication;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.virgo.kernel.authentication.Role;

public final class User
implements Principal {
    private final String name;
    private final String credential;
    private final Set<Role> roles = new HashSet<Role>();
    private final Object roleMonitor = new Object();

    public User(String name, String password) {
        this.name = name;
        this.credential = password;
    }

    public String getName() {
        return this.name;
    }

    public boolean authenticate(String candidateCredential) {
        return this.credential.equals(candidateCredential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrincipals(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Object object = this.roleMonitor;
        synchronized (object) {
            principals.add(this);
            principals.addAll(this.roles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrincipals(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Object object = this.roleMonitor;
        synchronized (object) {
            principals.remove(this);
            principals.removeAll(this.roles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRole(Role role) {
        Object object = this.roleMonitor;
        synchronized (object) {
            return this.roles.add(role);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.credential == null ? 0 : this.credential.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.credential == null ? other.credential != null : !this.credential.equals(other.credential)) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }

    public String toString() {
        return this.name;
    }
}

