/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.services.internal.KernelServicesLogEvents;
import org.eclipse.virgo.kernel.services.repository.internal.EmptyRepository;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryCreationException;
import org.eclipse.virgo.repository.RepositoryFactory;
import org.eclipse.virgo.repository.configuration.PropertiesRepositoryConfigurationReader;
import org.eclipse.virgo.repository.configuration.RepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RepositoryConfigurationException;
import org.eclipse.virgo.util.math.OrderedPair;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryFactoryBean
implements FactoryBean<Repository> {
    private final Properties repositoryProperties;
    private final EventLogger eventLogger;
    private final RepositoryFactory repositoryFactory;
    private volatile Repository repository;
    private final File workDirectory;
    private final Set<ArtifactBridge> artifactBridges;
    private final String mBeanDomain;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public RepositoryFactoryBean(Properties repositoryProperties, EventLogger eventLogger, RepositoryFactory repositoryFactory, File workDirectory, Set<ArtifactBridge> artifactBridges, String mBeanDomain) {
        this.repositoryProperties = repositoryProperties;
        this.eventLogger = eventLogger;
        this.repositoryFactory = repositoryFactory;
        this.workDirectory = workDirectory;
        this.artifactBridges = artifactBridges;
        this.mBeanDomain = mBeanDomain;
    }

    public Repository getObject() throws Exception {
        if (this.repository == null) {
            this.repository = this.createRepository();
        }
        return this.repository;
    }

    public Class<? extends Repository> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        try {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            boolean bl = true;
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public void destroy() {
        try {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            Repository localRepository = this.repository;
            if (localRepository != null) {
                this.repository = null;
                localRepository.stop();
            }
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private Repository createRepository() throws RepositoryConfigurationException, RepositoryCreationException {
        try {
            EmptyRepository emptyRepository;
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            PropertiesRepositoryConfigurationReader configurationReader = new PropertiesRepositoryConfigurationReader(this.workDirectory, this.artifactBridges, this.eventLogger, this.mBeanDomain);
            OrderedPair configurations = configurationReader.readConfiguration(this.repositoryProperties);
            Map configurationMap = (Map)configurations.getFirst();
            List chainList = (List)configurations.getSecond();
            if (chainList.isEmpty()) {
                this.eventLogger.log((LogEvent)KernelServicesLogEvents.KERNEL_REPOSITORY_CHAIN_EMPTY, new Object[0]);
                emptyRepository = new EmptyRepository();
            } else {
                ArrayList<RepositoryConfiguration> repositoryConfigurationChain = new ArrayList<RepositoryConfiguration>(chainList.size());
                for (String repositoryName : chainList) {
                    RepositoryConfiguration repositoryConfiguration = (RepositoryConfiguration)configurationMap.get(repositoryName);
                    if (repositoryConfiguration == null) {
                        this.eventLogger.log((LogEvent)KernelServicesLogEvents.KERNEL_REPOSITORY_CHAIN_ENTRY_NOT_VALID, new Object[]{repositoryName});
                        throw new RepositoryConfigurationException("Cannot resolve repository '" + repositoryName + "' in chain.");
                    }
                    repositoryConfigurationChain.add(repositoryConfiguration);
                }
                emptyRepository = this.repositoryFactory.createRepository(repositoryConfigurationChain);
            }
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return emptyRepository;
        }
        catch (Throwable throwable) {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("RepositoryFactoryBean.java", Class.forName("org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSingleton", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "", "boolean"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "", "void"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createRepository", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "org.eclipse.virgo.repository.configuration.RepositoryConfigurationException:org.eclipse.virgo.repository.RepositoryCreationException:", "org.eclipse.virgo.repository.Repository"), 83);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean");
    }
}

