/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactSet;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactType;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefactTyped;
import org.eclipse.virgo.ide.runtime.core.artefacts.LocalArtefactSet;
import org.eclipse.virgo.ide.runtime.core.artefacts.LocalBundleArtefact;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.IServerProjectArtefact;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.IServerProjectContainer;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ProjectFileReference;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.LibrariesNode;

public class RuntimeLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        ArtefactType artefactType;
        if (element instanceof IServerProjectArtefact) {
            return this.getImage(((IServerProjectArtefact)element).getArtefact());
        }
        if (element instanceof IServerProjectContainer) {
            return this.getImage(((IServerProjectContainer)element).getArtefactSet());
        }
        if (element instanceof ProjectFileReference) {
            return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.virgo_obj.png");
        }
        if (element instanceof ArtefactSet) {
            artefactType = ((IArtefactTyped)element).getArtefactType();
            if (artefactType == ArtefactType.BUNDLE) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_JAR_LIB_OBJ);
            }
            if (artefactType == ArtefactType.LIBRARY) {
                return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.virgo_obj_lib.png");
            }
        }
        if (element instanceof IFile) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        if (element instanceof IArtefactTyped) {
            artefactType = ((IArtefactTyped)element).getArtefactType();
            if (artefactType == ArtefactType.BUNDLE) {
                if (element instanceof LocalBundleArtefact && ((LocalBundleArtefact)element).isSourceDownloaded()) {
                    return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_EXTJAR_WSRC);
                }
                return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_EXTJAR);
            }
            if (artefactType == ArtefactType.LIBRARY) {
                return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.virgo_obj_file.png");
            }
        }
        if (element instanceof LibrariesNode) {
            return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.lib_obj.gif");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IServerProjectArtefact) {
            return this.getText(((IServerProjectArtefact)element).getArtefact());
        }
        if (element instanceof IServerProjectContainer) {
            return this.getText(((IServerProjectContainer)element).getArtefactSet());
        }
        if (element instanceof LibrariesNode) {
            return Messages.RepositoryBrowserEditorPage_BundlesAndLibraries;
        }
        if (element instanceof IFile) {
            return ((IFile)element).getName();
        }
        if (element instanceof ArtefactSet) {
            ArtefactSet set = (ArtefactSet)element;
            String label = set.getArtefactType().getPluralLabel();
            if (element instanceof LocalArtefactSet) {
                label = String.valueOf(((LocalArtefactSet)element).getRelativePath()) + " [" + label + "]";
            }
            return label;
        }
        if (element instanceof IArtefact) {
            IArtefact version = (IArtefact)element;
            StringBuilder l = new StringBuilder();
            if (version.getName() != null) {
                l.append(version.getName());
                l.append(" - ");
            }
            l.append(version.getSymbolicName());
            l.append(" (");
            l.append(version.getVersion());
            l.append(")");
            return l.toString();
        }
        return super.getText(element);
    }
}

