/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.internal.core.maven;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.virgo.bundlor.support.properties.PropertiesSource;
import org.eclipse.virgo.ide.bundlor.internal.core.maven.MavenPropertiesSource;
import org.eclipse.virgo.ide.facet.core.FacetUtils;

public class MavenPropertiesSourceFactory {
    private static final String M2E_CLASS_NAME = "org.eclipse.m2e.core.project.IMavenProjectRegistry";
    private static final String M2E_PROJECT_NATURE = "org.eclipse.m2e.core.maven2Nature";
    private static final boolean IS_M2E_PRESENT = MavenPropertiesSourceFactory.isM2ePresent();
    private static final PropertiesSource EMPTY_PROPERTIES_SOURCE = new NoOpPropertiesSource();

    public static boolean shouldCreate(IProject project) {
        return IS_M2E_PRESENT && FacetUtils.hasNature((IResource)project, (String)M2E_PROJECT_NATURE);
    }

    public static PropertiesSource createPropertiesSource(IProject project) {
        if (MavenPropertiesSourceFactory.shouldCreate(project)) {
            return new MavenPropertiesSource(project);
        }
        return EMPTY_PROPERTIES_SOURCE;
    }

    private static boolean isM2ePresent() {
        try {
            MavenPropertiesSourceFactory.class.getClassLoader().loadClass(M2E_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class NoOpPropertiesSource
    implements PropertiesSource {
        private NoOpPropertiesSource() {
        }

        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public Properties getProperties() {
            return new Properties();
        }
    }
}

