/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.internal.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.ide.bundlor.internal.core.IncrementalReadablePartialManifest;

public class IncrementalPartialManifestManager {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock r = this.rwl.readLock();
    private final Map<IJavaProject, ReadablePartialManifest> manifests = new ConcurrentHashMap<IJavaProject, ReadablePartialManifest>();
    private final Map<IJavaProject, ReadablePartialManifest> testManifests = new ConcurrentHashMap<IJavaProject, ReadablePartialManifest>();

    public ReadablePartialManifest getPartialManifest(IJavaProject javaProject, boolean isTestManifest, boolean createNew) {
        if (!createNew) {
            try {
                this.r.lock();
                if (!isTestManifest) {
                    if (this.manifests.containsKey(javaProject)) {
                        ReadablePartialManifest readablePartialManifest = this.manifests.get(javaProject);
                        return readablePartialManifest;
                    }
                } else if (this.testManifests.containsKey(javaProject)) {
                    ReadablePartialManifest readablePartialManifest = this.testManifests.get(javaProject);
                    return readablePartialManifest;
                }
            }
            finally {
                this.r.unlock();
            }
        }
        try {
            this.w.lock();
            IncrementalReadablePartialManifest manifest = new IncrementalReadablePartialManifest();
            if (!isTestManifest) {
                this.manifests.put(javaProject, (ReadablePartialManifest)manifest);
            } else {
                this.testManifests.put(javaProject, (ReadablePartialManifest)manifest);
            }
            IncrementalReadablePartialManifest incrementalReadablePartialManifest = manifest;
            return incrementalReadablePartialManifest;
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean hasPartialManifest(IJavaProject javaProject) {
        try {
            this.r.lock();
            boolean bl = this.manifests.containsKey(javaProject);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public void clearPartialManifest(IJavaProject javaProject) {
        try {
            this.w.lock();
            this.manifests.remove(javaProject);
            this.testManifests.remove(javaProject);
        }
        finally {
            this.w.unlock();
        }
    }
}

