/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.virgo.ide.runtime.internal.ui.actions.OpenServerProjectFileAction;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.VirgoEditorAdapterFactory;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProject;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProjectManager;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.RuntimeContainersContentProvider;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.RuntimeFullLabelProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.cnf.ServersView2;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonView
extends CommonNavigator
implements ISelectionListener {
    public static final String SHOW_VIEW_LIST = "showViewList";
    private static final String TREE_ACTION_GROUP = "tree";
    protected IWorkbenchPart currentPart;
    protected final ILabelProvider titleLabelProvider = new RuntimeFullLabelProvider();
    RuntimeContainersContentProvider containerProvider = new RuntimeContainersContentProvider();
    private List<IServer> servers = Collections.EMPTY_LIST;
    private static final String REFRESH_ACTION_GROUP = "refresh";
    private RefreshArtefactsAction refreshAction;
    private boolean showList;
    private IWorkbenchPart lastPartHint;

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewId(), aParent, 770);
    }

    protected void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ISelection selection = CommonView.this.getCommonViewer().getSelection();
                CommonView.this.getCommonViewer().setInput(CommonView.this.getCommonViewer().getInput());
                CommonView.this.getCommonViewer().setSelection(selection, true);
            }
        });
    }

    public void createPartControl(Composite aParent) {
        IEditorPart editor;
        IViewReference[] iViewReferenceArray = this.getViewSite().getPage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            IWorkbenchPart part = viewReference.getPart(false);
            if (part instanceof ServersView2 && part != this) {
                this.lastPartHint = part;
                break;
            }
            ++n2;
        }
        if (this.lastPartHint == null && (editor = this.getViewSite().getPage().getActiveEditor()) instanceof ServerEditor) {
            this.lastPartHint = editor;
        }
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager manager = actionBars.getToolBarManager();
        if (this.isSupportsListTree()) {
            Boolean value;
            this.showList = false;
            if (this.getMemento() != null && (value = this.getMemento().getBoolean(SHOW_VIEW_LIST)) != null) {
                this.showList = value;
            }
            ShowTreeAction showTreeAction = new ShowTreeAction();
            showTreeAction.setChecked(!this.showList);
            ShowListAction showListAction = new ShowListAction();
            showListAction.setChecked(this.showList);
            manager.add((IContributionItem)new Separator(TREE_ACTION_GROUP));
            manager.add((IContributionItem)new Separator("presentation"));
            manager.appendToGroup("presentation", (IAction)showTreeAction);
            manager.appendToGroup("presentation", (IAction)showListAction);
        }
        super.createPartControl(aParent);
        manager.add((IContributionItem)new Separator(REFRESH_ACTION_GROUP));
        this.refreshAction = new RefreshArtefactsAction();
        this.refreshAction.setEnabled(false);
        manager.appendToGroup(REFRESH_ACTION_GROUP, (IAction)this.refreshAction);
        this.getCommonViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    final StructuredSelection sel = (StructuredSelection)event.getSelection();
                    OpenServerProjectFileAction fileAction = new OpenServerProjectFileAction(CommonView.this.getSite().getPage()){

                        public IStructuredSelection getStructuredSelection() {
                            return sel;
                        }
                    };
                    if (fileAction.updateSelection((IStructuredSelection)sel)) {
                        fileAction.run();
                    }
                }
            }
        });
        this.updateActivations();
        this.getViewSite().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == CommonView.this) {
                    CommonView.this.activated();
                }
            }
        });
        this.activated();
    }

    protected void updateContentDescription() {
        String title = "(No Selection)";
        Object input = this.getCommonViewer().getInput();
        if (input != null && !this.servers.isEmpty()) {
            title = this.titleLabelProvider.getText(input);
        }
        this.setContentDescription(title);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        IServer virgoServer;
        List<IServer> lastServers = this.servers;
        if (part instanceof ServersView2 && part != this) {
            if (sel instanceof StructuredSelection) {
                this.lastPartHint = part;
                Iterator items = ((StructuredSelection)sel).iterator();
                this.servers = new ArrayList<IServer>();
                while (items.hasNext()) {
                    IServer server;
                    Object next = items.next();
                    if (!(next instanceof IServer) || !ServerProject.isVirgo((IServer)(server = (IServer)next))) continue;
                    this.servers.add(server);
                }
                if (!this.servers.equals(lastServers)) {
                    this.update();
                }
            }
        } else if (part instanceof IEditorPart && (virgoServer = VirgoEditorAdapterFactory.getVirgoServer((IEditorPart)part)) != null) {
            this.servers = Collections.singletonList(virgoServer);
            this.lastPartHint = part;
            if (!this.servers.equals(lastServers)) {
                this.update();
            }
        }
        this.updateContentDescription();
        this.refreshAction.setEnabled(!this.servers.isEmpty());
    }

    protected void update() {
        this.getCommonViewer().setInput(this.servers);
        this.refreshAction.setEnabled(!this.getServers().isEmpty());
        this.getCommonViewer().refresh();
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        if (this.isSupportsListTree()) {
            aMemento.putBoolean(SHOW_VIEW_LIST, this.showList);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        site.getPage().addPostSelectionListener((ISelectionListener)this);
        super.init(site, memento);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.currentPart = null;
        this.lastPartHint = null;
    }

    public List<IServer> getServers() {
        return this.servers;
    }

    protected void refreshAll() {
        for (IServer server : this.getServers()) {
            ServerProject project = ServerProjectManager.getInstance().getProject(server);
            if (project == null) continue;
            project.refreshDirectories();
        }
        this.refreshView();
    }

    public boolean isShowList() {
        return this.isSupportsListTree() && this.showList;
    }

    protected abstract String getTreeContentId();

    protected String getListContentId() {
        return null;
    }

    protected abstract String getViewId();

    protected final boolean isSupportsListTree() {
        return this.getListContentId() != null;
    }

    protected void updateActivations() {
        INavigatorActivationService activationService = this.getCommonViewer().getNavigatorContentService().getActivationService();
        if (!this.isSupportsListTree()) {
            activationService.activateExtensions(new String[]{this.getTreeContentId()}, false);
        } else if (this.isShowList()) {
            activationService.deactivateExtensions(new String[]{this.getTreeContentId()}, false);
            activationService.activateExtensions(new String[]{this.getListContentId()}, false);
        } else {
            activationService.deactivateExtensions(new String[]{this.getListContentId()}, false);
            activationService.activateExtensions(new String[]{this.getTreeContentId()}, false);
        }
    }

    protected void activated() {
        IServer virgoServer;
        if (this.lastPartHint instanceof ServersView2) {
            this.selectionChanged(this.lastPartHint, ((ServersView2)this.lastPartHint).getCommonViewer().getSelection());
        } else if (this.lastPartHint instanceof IEditorPart && (virgoServer = VirgoEditorAdapterFactory.getVirgoServer((IEditorPart)this.lastPartHint)) != null) {
            this.selectionChanged(this.lastPartHint, (ISelection)StructuredSelection.EMPTY);
        }
    }

    class RefreshArtefactsAction
    extends Action {
        public RefreshArtefactsAction() {
            super("", 1);
            this.setText(Messages.RepositoryBrowserEditorPage_Refresh);
            this.setDescription(Messages.RepositoryBrowserEditorPage_RefreshMessage);
            this.setToolTipText(Messages.RepositoryBrowserEditorPage_RefreshMessage);
            this.setImageDescriptor(PDEPluginImages.DESC_REFRESH);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_REFRESH_DISABLED);
        }

        public void run() {
            CommonView.this.refreshAll();
        }
    }

    class ShowListAction
    extends Action {
        public ShowListAction() {
            super("", 8);
            this.setText(PDEUIMessages.DependenciesView_ShowListAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowListAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowListAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_FLAT_LAYOUT);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_FLAT_LAYOUT_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                if (CommonView.this.memento != null) {
                    CommonView.this.memento.putBoolean(CommonView.SHOW_VIEW_LIST, true);
                }
                CommonView.this.showList = true;
                CommonView.this.updateActivations();
            }
        }
    }

    class ShowTreeAction
    extends Action {
        public ShowTreeAction() {
            super("", 8);
            this.setText(PDEUIMessages.DependenciesView_ShowTreeAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowTreeAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowTreeAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_HIERARCHICAL_LAYOUT);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_HIERARCHICAL_LAYOUT_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                if (CommonView.this.memento != null) {
                    CommonView.this.memento.putBoolean(CommonView.SHOW_VIEW_LIST, false);
                }
                CommonView.this.showList = false;
                CommonView.this.updateActivations();
            }
        }
    }
}

