/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyCommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;

public class TimelyCommunicationGroup
extends CommunicationGroup {
    private final boolean isSingleton;
    private final TreeMap<Timestamp, Set<Mailbox>> mailboxQueue;
    private Comparator<Node> nodeComparator;
    private boolean currentlyDelivering;
    private Timestamp currentlyDeliveredTimestamp;

    public TimelyCommunicationGroup(TimelyCommunicationTracker tracker, Node representative, int identifier, boolean isSingleton) {
        super(tracker, representative, identifier);
        this.isSingleton = isSingleton;
        this.mailboxQueue = CollectionsFactory.createTreeMap();
        this.currentlyDelivering = false;
    }

    public void setComparatorAndReorderMailboxes(Comparator<Node> nodeComparator) {
        this.nodeComparator = nodeComparator;
        if (!this.mailboxQueue.isEmpty()) {
            HashMap<Timestamp, Set<Mailbox>> queueCopy = new HashMap<Timestamp, Set<Mailbox>>(this.mailboxQueue);
            this.mailboxQueue.clear();
            for (Map.Entry<Timestamp, Set<Mailbox>> entry : queueCopy.entrySet()) {
                for (Mailbox mailbox : entry.getValue()) {
                    this.notifyHasMessage(mailbox, entry.getKey());
                }
            }
        }
    }

    @Override
    public void deliverMessages() {
        this.currentlyDelivering = true;
        while (!this.mailboxQueue.isEmpty()) {
            Map.Entry<Timestamp, Set<Mailbox>> entry = this.mailboxQueue.firstEntry();
            Timestamp timestamp = entry.getKey();
            Set<Mailbox> mailboxes = entry.getValue();
            Mailbox mailbox = mailboxes.iterator().next();
            mailboxes.remove(mailbox);
            if (mailboxes.isEmpty()) {
                this.mailboxQueue.pollFirstEntry();
            }
            assert (mailbox instanceof TimelyMailbox);
            this.currentlyDeliveredTimestamp = timestamp;
            mailbox.deliverAll(timestamp);
            this.currentlyDeliveredTimestamp = null;
        }
        this.currentlyDelivering = false;
    }

    @Override
    public boolean isEmpty() {
        return this.mailboxQueue.isEmpty();
    }

    @Override
    public void notifyHasMessage(Mailbox mailbox, MessageSelector kind) {
        if (kind instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)kind;
            Set mailboxes = this.mailboxQueue.computeIfAbsent(timestamp, k -> {
                if (this.nodeComparator == null) {
                    return CollectionsFactory.createSet();
                }
                return new TreeSet<Mailbox>(new Comparator<Mailbox>(){

                    @Override
                    public int compare(Mailbox left, Mailbox right) {
                        return TimelyCommunicationGroup.this.nodeComparator.compare(left.getReceiver(), right.getReceiver());
                    }
                });
            });
            mailboxes.add(mailbox);
            if (!this.isEnqueued && !this.currentlyDelivering) {
                this.tracker.activateUnenqueued(this);
            }
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + String.valueOf(kind));
        }
    }

    @Override
    public void notifyLostAllMessages(Mailbox mailbox, MessageSelector kind) {
        if (kind instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)kind;
            this.mailboxQueue.compute(timestamp, (k, v) -> {
                if (v == null) {
                    throw new IllegalStateException("No mailboxes registered at timestamp " + String.valueOf(timestamp) + "!");
                }
                if (!v.remove(mailbox)) {
                    throw new IllegalStateException("The mailbox " + String.valueOf(mailbox) + " was not registered at timestamp " + String.valueOf(timestamp) + "!");
                }
                if (v.isEmpty()) {
                    return null;
                }
                return v;
            });
            if (this.mailboxQueue.isEmpty()) {
                this.tracker.deactivate(this);
            }
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + String.valueOf(kind));
        }
    }

    @Override
    public Map<MessageSelector, Collection<Mailbox>> getMailboxes() {
        return Collections.unmodifiableMap(this.mailboxQueue);
    }

    @Override
    public boolean isRecursive() {
        return !this.isSingleton;
    }
}

