/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timechart;

import java.util.Collections;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.tracecompass.tmf.ui.views.colors.IColorSettingsListener;
import org.eclipse.tracecompass.tmf.ui.views.timechart.TimeChartEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;

public class TimeChartAnalysisProvider
extends TimeGraphPresentationProvider
implements IColorSettingsListener {
    private static final Color BOOKMARK_INNER_COLOR = new Color((Device)Display.getDefault(), 115, 165, 224);
    private static final Color BOOKMARK_OUTER_COLOR = new Color((Device)Display.getDefault(), 2, 70, 140);
    private static final Color SEARCH_MATCH_COLOR = new Color((Device)Display.getDefault(), 177, 118, 14);
    private static final StateItem DEFAULT_STATE = new StateItem(new RGB(0, 0, 0), "Undefined");
    private StateItem[] fStateTable;
    private int lastBookmarkX = Integer.MIN_VALUE;

    public TimeChartAnalysisProvider() {
        this.colorSettingsChanged(ColorSettingsManager.getColorSettings());
    }

    @Override
    public StateItem[] getStateTable() {
        return this.fStateTable;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        if (!((TimeChartEvent)event).isVisible()) {
            return -1;
        }
        return ((TimeChartEvent)event).getColorSettingPriority();
    }

    @Override
    public Map<String, Object> getEventStyle(ITimeEvent event) {
        StateItem stateItem = null;
        int index = this.getStateTableIndex(event);
        if (index == Integer.MAX_VALUE) {
            return DEFAULT_STATE.getStyleMap();
        }
        StateItem[] stateTable = this.getStateTable();
        if (index >= 0 && index < stateTable.length) {
            stateItem = stateTable[index];
        }
        return stateItem == null ? Collections.emptyMap() : stateItem.getStyleMap();
    }

    @Override
    public void postDrawEvent(ITimeEvent event, Rectangle rect, GC gc) {
        if (!((TimeChartEvent)event).isVisible()) {
            return;
        }
        if (this.lastBookmarkX == rect.x || ((TimeChartEvent)event).isBookmarked()) {
            TimeChartAnalysisProvider.drawBookmark(rect, gc);
            this.lastBookmarkX = rect.x;
        } else if (this.lastBookmarkX == rect.x - 1) {
            Rectangle r = new Rectangle(this.lastBookmarkX, rect.y, rect.width, rect.height);
            TimeChartAnalysisProvider.drawBookmark(r, gc);
        } else {
            this.lastBookmarkX = Integer.MIN_VALUE;
        }
        if (((TimeChartEvent)event).isSearchMatch()) {
            TimeChartAnalysisProvider.drawSearchMatch(rect, gc);
        }
    }

    private static void drawBookmark(Rectangle r, GC gc) {
        gc.setForeground(BOOKMARK_OUTER_COLOR);
        gc.drawLine(r.x - 1, r.y - 2, r.x - 1, r.y + 2);
        gc.drawLine(r.x + 1, r.y - 2, r.x + 1, r.y + 2);
        gc.drawPoint(r.x, r.y - 2);
        gc.setForeground(BOOKMARK_INNER_COLOR);
        gc.drawLine(r.x, r.y - 1, r.x, r.y + 1);
        gc.setForeground(Display.getDefault().getSystemColor(1));
        gc.drawPoint(r.x - 1, r.y + 3);
        gc.drawPoint(r.x, r.y + 2);
        gc.drawPoint(r.x + 1, r.y + 3);
    }

    private static void drawSearchMatch(Rectangle r, GC gc) {
        gc.setForeground(SEARCH_MATCH_COLOR);
        gc.drawPoint(r.x, r.y + r.height);
        gc.drawLine(r.x - 1, r.y + r.height + 1, r.x + 1, r.y + r.height + 1);
        gc.drawLine(r.x - 2, r.y + r.height + 2, r.x + 2, r.y + r.height + 2);
    }

    @Override
    public void colorSettingsChanged(ColorSetting[] settings) {
        StateItem[] stateItems = new StateItem[settings.length];
        int i = 0;
        while (i < settings.length) {
            stateItems[i] = new StateItem(settings[i].getTickColorRGB(), "Undefined");
            ++i;
        }
        this.fStateTable = stateItems;
    }
}

