/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TracePythonLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IBaseEnableUstEvents;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseLoggerComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlContentProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlLabelProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class EnableLoggersComposite
extends Composite
implements IBaseEnableUstEvents {
    private final TraceProviderGroup fProviderGroup;
    private Button fLoggersActivateButton;
    private CheckboxTreeViewer fLoggersViewer;
    private Text fSpecificLoggerText;
    private boolean fIsLoggers;
    private List<String> fLoggers;
    private Button fLogLevelActivateButton;
    private CCombo fLogLevelCombo;
    private Button fLogLevelButton;
    private Button fLogLevelOnlyButton;
    private boolean fIsLogLevel;
    private boolean fIsAllLoggers;
    private LogLevelType fLogLevelType;
    private ITraceLogLevel fLogLevel;
    private final TraceDomainType fDomain;

    public EnableLoggersComposite(Composite parent, int style, TraceProviderGroup providerGroup, TraceDomainType domain) {
        super(parent, style);
        this.fProviderGroup = providerGroup;
        this.fDomain = domain;
    }

    @Override
    public ITraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public LogLevelType getLogLevelType() {
        return this.fLogLevelType;
    }

    @Override
    public boolean isAllTracePoints() {
        return this.fIsAllLoggers;
    }

    @Override
    public List<String> getEventNames() {
        return new ArrayList<String>(this.fLoggers);
    }

    @Override
    public boolean isLogLevel() {
        return this.fIsLogLevel;
    }

    public void createContent() {
        this.createLoggersGroup();
        this.createLogLevelGroup();
        this.setEnablements(GroupEnum.LOGGERS);
    }

    public boolean isValid() {
        this.fIsLoggers = this.fLoggersActivateButton.getSelection();
        this.fIsLogLevel = this.fLogLevelActivateButton.getSelection();
        this.fLoggers = new ArrayList<String>();
        if (this.fIsLoggers) {
            HashSet<String> set = new HashSet<String>();
            Object[] checkedElements = this.fLoggersViewer.getCheckedElements();
            int checkedNbLoggers = 0;
            int i = 0;
            while (i < checkedElements.length) {
                ITraceControlComponent component = (ITraceControlComponent)checkedElements[i];
                if (component instanceof BaseLoggerComponent) {
                    ++checkedNbLoggers;
                    if (!set.contains(component.getName())) {
                        set.add(component.getName());
                        this.fLoggers.add(component.getName());
                    }
                }
                ++i;
            }
            int nbAvailableLoggers = 0;
            List<ITraceControlComponent> comps = this.fProviderGroup.getChildren(UstProviderComponent.class);
            for (ITraceControlComponent comp : comps) {
                ITraceControlComponent[] events;
                ITraceControlComponent[] iTraceControlComponentArray = events = comp.getChildren();
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    ITraceControlComponent event = iTraceControlComponentArray[n2];
                    if (event instanceof BaseLoggerComponent && this.fDomain.equals((Object)((BaseLoggerComponent)event).getDomain())) {
                        ++nbAvailableLoggers;
                    }
                    ++n2;
                }
            }
            this.fIsAllLoggers = checkedNbLoggers > 0 && nbAvailableLoggers == checkedNbLoggers || nbAvailableLoggers == 0 && this.fLoggersViewer.getCheckedElements().length == 1;
            String tmpSpecificLogger = this.fSpecificLoggerText.getText();
            if (!this.fIsAllLoggers && !tmpSpecificLogger.trim().isEmpty()) {
                tmpSpecificLogger = tmpSpecificLogger.replaceAll("\\s", "");
                List<String> specificLoggerList = Arrays.asList(tmpSpecificLogger.split(","));
                this.fLoggers.addAll(specificLoggerList);
                this.fLoggers = this.fLoggers.stream().distinct().collect(Collectors.toList());
            }
        }
        this.fLogLevelType = LogLevelType.LOGLEVEL_NONE;
        if (this.fIsLogLevel) {
            if (this.fLogLevelButton.getSelection()) {
                this.fLogLevelType = LogLevelType.LOGLEVEL;
            } else if (this.fLogLevelOnlyButton.getSelection()) {
                this.fLogLevelType = LogLevelType.LOGLEVEL_ONLY;
            }
            ITraceLogLevel[] levels = this.getLogLevelNames();
            int id = this.fLogLevelCombo.getSelectionIndex();
            if (id < 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableLoggersDialogTitle, (String)Messages.TraceControl_InvalidLogLevel);
                return false;
            }
            if (this.fLoggers.isEmpty() && !this.fIsAllLoggers) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableLoggersDialogTitle, (String)Messages.TraceControl_InvalidLogger);
                return false;
            }
            if (levels != null) {
                this.fLogLevel = levels[id];
            }
        }
        return true;
    }

    private ITraceLogLevel[] getLogLevelNames() {
        switch (this.fDomain) {
            case JUL: {
                return TraceJulLogLevel.values();
            }
            case LOG4J: {
                return TraceLog4jLogLevel.values();
            }
            case PYTHON: {
                return TracePythonLogLevel.values();
            }
        }
        return null;
    }

    private void createLoggersGroup() {
        Group loggersMainGroup = new Group((Composite)this, 32);
        loggersMainGroup.setText(Messages.TraceControl_EnableEventsLoggerGroupName);
        GridLayout layout = new GridLayout(2, false);
        loggersMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        loggersMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)loggersMainGroup, 0);
        layout = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fLoggersActivateButton = new Button(buttonComposite, 16);
        this.fLoggersActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        data = new GridData(768);
        this.fLoggersActivateButton.setLayoutData((Object)data);
        this.fLoggersActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableLoggersComposite.this.setEnablements(GroupEnum.LOGGERS);
            }
        });
        Group loggersGroup = new Group((Composite)loggersMainGroup, 32);
        layout = new GridLayout(1, true);
        loggersGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        loggersGroup.setLayoutData((Object)data);
        new FilteredTree((Composite)loggersGroup, 2818, new PatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite aparent, int style) {
                EnableLoggersComposite.this.fLoggersViewer = new CheckboxTreeViewer(aparent, 770);
                EnableLoggersComposite.this.fLoggersViewer.getTree().setToolTipText(Messages.TraceControl_EnableEventsLoggerTreeTooltip);
                EnableLoggersComposite.this.fLoggersViewer.setContentProvider((IContentProvider)new LoggersContentProvider());
                EnableLoggersComposite.this.fLoggersViewer.setLabelProvider((IBaseLabelProvider)new LoggersLabelProvider());
                EnableLoggersComposite.this.fLoggersViewer.addCheckStateListener((ICheckStateListener)new LoggersCheckStateListener());
                EnableLoggersComposite.this.fLoggersViewer.setInput((Object)EnableLoggersComposite.this.fProviderGroup.getParent());
                EnableLoggersComposite.this.fLoggersViewer.getTree().setLayoutData((Object)new GridData(1808));
                return EnableLoggersComposite.this.fLoggersViewer;
            }
        };
        Group specificLoggerGroup = new Group((Composite)loggersGroup, 32);
        specificLoggerGroup.setText(Messages.TraceControl_EnableEventsSpecificLoggerGroupName);
        layout = new GridLayout(4, true);
        specificLoggerGroup.setLayout((Layout)layout);
        specificLoggerGroup.setLayoutData((Object)new GridData(768));
        Label specificLoggerLabel = new Label((Composite)specificLoggerGroup, 16384);
        specificLoggerLabel.setText(Messages.TraceControl_EnableEventsNameLabel);
        data = new GridData(768);
        data.horizontalSpan = 1;
        specificLoggerLabel.setLayoutData((Object)data);
        this.fSpecificLoggerText = new Text((Composite)specificLoggerGroup, 16384);
        this.fSpecificLoggerText.setToolTipText(Messages.TraceControl_EnableEventsSpecificLoggerTooltip);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSpecificLoggerText.setLayoutData((Object)data);
    }

    private void createLogLevelGroup() {
        Group logLevelMainGroup = new Group((Composite)this, 32);
        logLevelMainGroup.setText(Messages.TraceControl_EnableEventsLogLevelGroupName);
        GridLayout layout = new GridLayout(2, false);
        logLevelMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        logLevelMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)logLevelMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fLogLevelActivateButton = new Button(buttonComposite, 32);
        this.fLogLevelActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fLogLevelActivateButton.setSelection(false);
        data = new GridData(768);
        this.fLogLevelActivateButton.setLayoutData((Object)data);
        this.fLogLevelActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableLoggersComposite.this.fLogLevelCombo.setEnabled(EnableLoggersComposite.this.fLogLevelActivateButton.getSelection());
                EnableLoggersComposite.this.fLogLevelButton.setEnabled(EnableLoggersComposite.this.fLogLevelActivateButton.getSelection());
                EnableLoggersComposite.this.fLogLevelOnlyButton.setEnabled(EnableLoggersComposite.this.fLogLevelActivateButton.getSelection());
            }
        });
        Group logLevelGroup = new Group((Composite)logLevelMainGroup, 32);
        layout = new GridLayout(2, true);
        logLevelGroup.setLayout((Layout)layout);
        logLevelGroup.setLayoutData((Object)new GridData(768));
        this.fLogLevelButton = new Button((Composite)logLevelGroup, 16);
        this.fLogLevelButton.setText(Messages.TraceControl_EnableEventsLogLevelTypeName);
        this.fLogLevelButton.setToolTipText(Messages.TraceControl_EnableEventsLogLevelTypeTooltip);
        data = new GridData(1808);
        this.fLogLevelButton.setLayoutData((Object)data);
        this.fLogLevelButton.setSelection(true);
        this.fLogLevelOnlyButton = new Button((Composite)logLevelGroup, 16);
        this.fLogLevelOnlyButton.setText(Messages.TraceControl_EnableEventsLogLevelOnlyTypeName);
        this.fLogLevelOnlyButton.setToolTipText(Messages.TraceControl_EnableEventsLogLevelOnlyTypeTooltip);
        data = new GridData(1808);
        this.fLogLevelButton.setLayoutData((Object)data);
        this.fLogLevelCombo = new CCombo((Composite)logLevelGroup, 8);
        ITraceLogLevel[] levels = this.getLogLevelNames();
        if (levels != null) {
            String[] levelNames = new String[levels.length - 1];
            int k = 0;
            int i = 0;
            while (i < levels.length) {
                if (levels[i] != TraceJulLogLevel.LEVEL_UNKNOWN && levels[i] != TraceLog4jLogLevel.LEVEL_UNKNOWN && levels[i] != TracePythonLogLevel.LEVEL_UNKNOWN) {
                    levelNames[k++] = levels[i].getInName();
                }
                ++i;
            }
            this.fLogLevelCombo.setItems(levelNames);
        }
        this.fLogLevelCombo.setToolTipText(Messages.TraceControl_EnableEventsLogLevelTooltip);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.fLogLevelCombo.setLayoutData((Object)data);
        this.fLogLevelCombo.setEnabled(false);
        this.fLogLevelButton.setEnabled(false);
        this.fLogLevelOnlyButton.setEnabled(false);
    }

    private void setEnablements(GroupEnum group) {
        this.fLoggersActivateButton.setSelection(group == GroupEnum.LOGGERS);
        this.fLoggersViewer.getTree().setEnabled(group == GroupEnum.LOGGERS);
    }

    private static enum GroupEnum {
        LOGGERS;

    }

    public final class LoggersCheckStateListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                if (event.getElement() instanceof TraceProviderGroup) {
                    EnableLoggersComposite.this.fLoggersViewer.setSubtreeChecked(event.getElement(), true);
                }
                if (event.getElement() instanceof UstProviderComponent) {
                    EnableLoggersComposite.this.fLoggersViewer.setSubtreeChecked(event.getElement(), true);
                }
            } else {
                if (event.getElement() instanceof TraceProviderGroup) {
                    EnableLoggersComposite.this.fLoggersViewer.setSubtreeChecked(event.getElement(), true);
                }
                if (event.getElement() instanceof UstProviderComponent) {
                    ITraceControlComponent component = (ITraceControlComponent)event.getElement();
                    EnableLoggersComposite.this.fLoggersViewer.setSubtreeChecked(event.getElement(), false);
                    EnableLoggersComposite.this.fLoggersViewer.setChecked((Object)component.getParent(), false);
                } else {
                    ITraceControlComponent component = (ITraceControlComponent)event.getElement();
                    EnableLoggersComposite.this.fLoggersViewer.setChecked((Object)component.getParent(), false);
                    EnableLoggersComposite.this.fLoggersViewer.setChecked((Object)component.getParent().getParent(), false);
                }
            }
        }
    }

    public final class LoggersContentProvider
    extends TraceControlContentProvider {
        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TargetNodeComponent) {
                List<ITraceControlComponent> children = ((ITraceControlComponent)parentElement).getChildren(TraceProviderGroup.class);
                return children.toArray(new ITraceControlComponent[children.size()]);
            }
            if (parentElement instanceof TraceProviderGroup) {
                List<ITraceControlComponent> ustProviderChildren = ((ITraceControlComponent)parentElement).getChildren(UstProviderComponent.class).stream().filter(comp -> !((UstProviderComponent)comp).getLoggerComponents(EnableLoggersComposite.this.fDomain).isEmpty()).collect(Collectors.toList());
                return ustProviderChildren.toArray(new ITraceControlComponent[ustProviderChildren.size()]);
            }
            if (parentElement instanceof UstProviderComponent) {
                List<ITraceControlComponent> loggers = ((UstProviderComponent)parentElement).getLoggerComponents(EnableLoggersComposite.this.fDomain);
                return loggers.toArray(new ITraceControlComponent[loggers.size()]);
            }
            return new Object[0];
        }
    }

    public static final class LoggersLabelProvider
    extends TraceControlLabelProvider {
        @Override
        public Image getImage(Object element) {
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element != null && element instanceof TraceProviderGroup) {
                return Messages.TraceControl_EnableEventsTreeAllLabel;
            }
            if (element != null && element instanceof UstProviderComponent) {
                return Messages.TraceControl_EnableEventsTreeAllLabel + " - " + ((UstProviderComponent)element).getName();
            }
            return super.getText(element);
        }
    }
}

