/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.stubs;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.junit.Assert;

public class GraphOps {
    public static void checkEquality(ITmfGraph g1, ITmfGraph g2) {
        Collection obj1 = g1.getWorkers();
        Collection obj2 = g2.getWorkers();
        Assert.assertEquals((String)"Graph objects", (Object)obj1, (Object)obj2);
        for (IGraphWorker graphObject : obj1) {
            Assert.assertNotNull((Object)graphObject);
            ImmutableList nodesOf1 = ImmutableList.copyOf((Iterator)g1.getNodesOf(graphObject));
            ImmutableList nodesOf2 = ImmutableList.copyOf((Iterator)g2.getNodesOf(graphObject));
            int i = 0;
            while (i < nodesOf1.size()) {
                ITmfVertex v1 = (ITmfVertex)nodesOf1.get(i);
                ITmfVertex v2 = (ITmfVertex)nodesOf2.get(i);
                Assert.assertEquals((String)("Node timestamps for " + graphObject + ", node " + i), (long)v1.getTimestamp(), (long)v2.getTimestamp());
                ITmfGraph.EdgeDirection[] edgeDirectionArray = ITmfGraph.EdgeDirection.values();
                int n = edgeDirectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITmfGraph.EdgeDirection dir = edgeDirectionArray[n2];
                    ITmfEdge edge1 = g1.getEdgeFrom(v1, dir);
                    ITmfEdge edge2 = g2.getEdgeFrom(v2, dir);
                    if (edge1 == null) {
                        Assert.assertNull((String)("Expected null edge for " + graphObject + ", node " + v1 + " and dir " + dir), (Object)edge2);
                    } else {
                        Assert.assertNotNull((String)("Expected non null edge for " + graphObject + ", node " + v1 + " and dir " + dir), (Object)edge2);
                        Assert.assertEquals((String)("Edge type for " + graphObject + ", node " + v1 + " and dir " + dir), (Object)edge1.getEdgeContextState().getContextEnum(), (Object)edge2.getEdgeContextState().getContextEnum());
                        Assert.assertEquals((String)("Edge duration for " + graphObject + ", node " + v1 + " edge direction " + dir), (long)edge1.getDuration(), (long)edge2.getDuration());
                        Assert.assertEquals((String)("From objects for " + graphObject + ", node " + v1 + " and dir " + dir), (Object)g1.getParentOf(edge1.getVertexFrom()), (Object)g2.getParentOf(edge2.getVertexFrom()));
                        Assert.assertEquals((String)("To objects for " + graphObject + ", node " + v1 + " and dir " + dir), (Object)g1.getParentOf(edge1.getVertexTo()), (Object)g2.getParentOf(edge2.getVertexTo()));
                        Assert.assertEquals((String)("Edge qualifier for " + graphObject + ", node " + v1 + " and dir " + dir), (Object)edge1.getLinkQualifier(), (Object)edge2.getLinkQualifier());
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }
}

