/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class ZipLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private ZipFile zipFile;
    private ZipArchiveEntry root = new ZipArchiveEntry("/");
    private Map<ZipArchiveEntry, List<ZipArchiveEntry>> children;
    private Map<IPath, ZipArchiveEntry> directoryEntryCache = new HashMap<IPath, ZipArchiveEntry>();
    private int stripLevel;

    public ZipLeveledStructureProvider(ZipFile sourceFile) {
        this.zipFile = sourceFile;
        this.stripLevel = 0;
    }

    protected ZipArchiveEntry createContainer(IPath pathname) {
        ZipArchiveEntry existingEntry = this.directoryEntryCache.get(pathname);
        if (existingEntry != null) {
            return existingEntry;
        }
        if (pathname.segmentCount() == 0) {
            return null;
        }
        ZipArchiveEntry parent = pathname.segmentCount() == 1 ? this.root : this.createContainer(pathname.removeLastSegments(1));
        ZipArchiveEntry newEntry = new ZipArchiveEntry(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List<ZipArchiveEntry> parentChildList = this.children.get(parent);
        ((List)NonNullUtils.checkNotNull(parentChildList)).add(newEntry);
        return newEntry;
    }

    protected void createFile(ZipArchiveEntry entry) {
        Path pathname = new Path(entry.getName());
        ZipArchiveEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        @Nullable List<ZipArchiveEntry> childList = this.children.get(parent);
        ((List)NonNullUtils.checkNotNull(childList)).add(entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.zipFile.getInputStream((ZipEntry)((ZipArchiveEntry)element));
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String stripPath(String path) {
        String strippedPath;
        String pathOrig = strippedPath = path;
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = strippedPath.indexOf(47);
            if (firstSep == 0) {
                strippedPath = strippedPath.substring(1);
                firstSep = strippedPath.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            strippedPath = strippedPath.substring(firstSep);
            ++i;
        }
        return strippedPath;
    }

    public String getFullPath(Object element) {
        String name = ((ZipArchiveEntry)element).getName();
        return ArchiveUtil.toValidNamesPath(name).toOSString();
    }

    public String getLabel(Object element) {
        if (element.equals(this.getRoot())) {
            return ((ZipArchiveEntry)element).getName();
        }
        String name = ((ZipArchiveEntry)element).getName();
        return this.stripPath(ArchiveUtil.toValidNamesPath(name).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public boolean closeArchive() {
        try {
            this.getZipFile().close();
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getZipFile()), (Throwable)e);
            return false;
        }
        return true;
    }

    public void close() {
        this.closeArchive();
    }

    protected void initialize() {
        this.children = new HashMap<ZipArchiveEntry, List<ZipArchiveEntry>>(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        long archiveEntries = 0L;
        long archiveSize = 0L;
        long entrySize = 0L;
        while (entries.hasMoreElements()) {
            ZipEntry entry = Objects.requireNonNull(entries.nextElement());
            entrySize = ArchiveUtil.getZipEntrySize(this.zipFile, entry);
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            archiveSize += entrySize;
            ++archiveEntries;
            if (entry.isDirectory()) {
                this.createContainer(path);
                continue;
            }
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount > 1) {
                this.createContainer(path.uptoSegment(pathSegmentCount - 1));
            }
            if (ArchiveUtil.verifyZipFileIsSafe(archiveSize, archiveEntries) && entrySize != -1L) {
                this.createFile(new ZipArchiveEntry(entry.getName()));
                continue;
            }
            Activator activator = new Activator();
            activator.logError("Unable to create file, Zip file is unsafe");
        }
    }

    public boolean isFolder(Object element) {
        return ((ZipArchiveEntry)element).isDirectory();
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

