/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;

public class MarkersViewPropertyTester
extends PropertyTester {
    private static final String ATTRIBUTE_CONTENT_GENERATOR = "contentGenerator";
    private static final String ATTRIBUTE_HAS_FILTERS = "hasFilters";
    private static final String ATTRIBUTE_HAS_GROUPS = "hasGroups";
    private static final String ANY_CONTENT_GENERATOR = "any";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof ExtendedMarkersView)) {
            return false;
        }
        ExtendedMarkersView view = (ExtendedMarkersView)((Object)receiver);
        if (property.equals(ATTRIBUTE_CONTENT_GENERATOR)) {
            return this.testContentGenerator(view, args);
        }
        if (property.equals(ATTRIBUTE_HAS_FILTERS)) {
            return view.getAllFilters().size() > 0;
        }
        if (property.equals(ATTRIBUTE_HAS_GROUPS)) {
            return view.getBuilder().getGenerator().getMarkerGroups().size() > 0;
        }
        return false;
    }

    private boolean testContentGenerator(ExtendedMarkersView view, Object[] args) {
        String currentGenerator = view.getBuilder().getGenerator().getId();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg.equals(currentGenerator)) {
                return true;
            }
            if (arg.equals(ANY_CONTENT_GENERATOR)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

