/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.RegistryReader;

public class SynchronizeWizardDescription {
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_ICON = "icon";
    public static final String ATT_CLASS = "class";
    public static final String ATT_DESCRIPTION = "description";
    private String label;
    private String className;
    private String description;
    private String id;
    private ImageDescriptor imageDescriptor;
    private final IConfigurationElement configElement;

    public SynchronizeWizardDescription(IConfigurationElement e, String descText) throws CoreException {
        this.configElement = e;
        this.loadFromExtension();
    }

    public IWizard createWizard() throws CoreException {
        Object obj = RegistryReader.createExtension(this.configElement, ATT_CLASS);
        return (IWizard)obj;
    }

    private void loadFromExtension() throws CoreException {
        String identifier = this.configElement.getAttribute(ATT_ID);
        this.label = this.configElement.getAttribute(ATT_NAME);
        this.className = this.configElement.getAttribute(ATT_CLASS);
        this.description = this.configElement.getAttribute(ATT_DESCRIPTION);
        if (this.label == null || this.className == null || identifier == null || this.description == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, "Invalid extension (missing label or class name): " + identifier, null));
        }
        this.id = identifier;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String iconName = this.configElement.getAttribute(ATT_ICON);
        if (iconName == null) {
            return null;
        }
        this.imageDescriptor = TeamUIPlugin.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), iconName);
        return this.imageDescriptor;
    }

    public String getName() {
        return this.label;
    }

    public String toString() {
        return "Synchronize Participant Creation Wizard(" + this.getId() + ")";
    }
}

