/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.ipv6;

import com.google.common.collect.ImmutableMap;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv6.IPv6Endpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.tcp.TCPPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.udp.UDPPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;

public class IPv6Packet
extends Packet {
    private final @Nullable Packet fChildPacket;
    private final @Nullable ByteBuffer fPayload;
    private final int fVersion;
    private final int fTrafficClass;
    private final int fFlowLabel;
    private final int fPayloadLength;
    private final int fNextHeader;
    private final int fHopLimit;
    private final Inet6Address fSourceIpAddress;
    private final Inet6Address fDestinationIpAddress;
    private @Nullable IPv6Endpoint fSourceEndpoint = null;
    private @Nullable IPv6Endpoint fDestinationEndpoint = null;
    private @Nullable Map<String, String> fFields = null;

    public IPv6Packet(PcapFile file, @Nullable Packet parent, ByteBuffer packet) throws BadPacketException {
        super(file, parent, PcapProtocol.IPV6);
        packet.order(ByteOrder.BIG_ENDIAN);
        packet.position(0);
        short storage0 = packet.getShort();
        this.fVersion = (storage0 & 0xF000) >> 12 & 0xF;
        this.fTrafficClass = (storage0 & 0xFF0) >> 4 & 0xFF;
        this.fFlowLabel = ((storage0 & 0xF) << 16 & 0xF0000) + ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fPayloadLength = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fNextHeader = ConversionHelper.unsignedByteToInt(packet.get());
        this.fHopLimit = ConversionHelper.unsignedByteToInt(packet.get());
        byte[] source = new byte[16];
        byte[] destination = new byte[16];
        packet.get(source);
        packet.get(destination);
        try {
            this.fSourceIpAddress = (Inet6Address)NonNullUtils.checkNotNull((Object)InetAddress.getByAddress(source));
            this.fDestinationIpAddress = (Inet6Address)NonNullUtils.checkNotNull((Object)InetAddress.getByAddress(destination));
        }
        catch (UnknownHostException e) {
            throw new BadPacketException("The IP Address size is not valid!");
        }
        if (packet.remaining() > 0) {
            ByteBuffer payload = packet.slice();
            payload.order(ByteOrder.BIG_ENDIAN);
            this.fPayload = payload;
        } else {
            this.fPayload = null;
        }
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        switch (this.fNextHeader) {
            case 6: {
                return new TCPPacket(this.getPcapFile(), (Packet)this, payload);
            }
            case 17: {
                return new UDPPacket(this.getPcapFile(), (Packet)this, payload);
            }
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    public String toString() {
        String string = this.getProtocol().getName() + ", Source: " + this.fSourceIpAddress.getHostAddress() + ", Destination: " + this.fDestinationIpAddress.getHostAddress() + "\nVersion: " + this.fVersion + ", Header Length: " + this.getHeaderLength() + " bytes, Traffic Class: " + String.format("%s%02x", "0x", this.fTrafficClass) + ", Flow Label: " + String.format("%s%02x", "0x", this.fFlowLabel) + ", Payload Length: " + this.getPayloadLength() + " bytes\nNext Header: " + String.format("%s%02x", "0x", this.fNextHeader) + ", Hop Limit: " + this.fHopLimit + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return string + child.toString();
        }
        return string;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public int getHeaderLength() {
        return 40;
    }

    public int getTrafficClass() {
        return this.fTrafficClass;
    }

    public int getFlowLabel() {
        return this.fFlowLabel;
    }

    public int getPayloadLength() {
        return this.fPayloadLength;
    }

    public int getNextHeader() {
        return this.fNextHeader;
    }

    public int getHopLimit() {
        return this.fHopLimit;
    }

    public Inet6Address getSourceIpAddress() {
        return this.fSourceIpAddress;
    }

    public Inet6Address getDestinationIpAddress() {
        return this.fDestinationIpAddress;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public IPv6Endpoint getSourceEndpoint() {
        @Nullable IPv6Endpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new IPv6Endpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public IPv6Endpoint getDestinationEndpoint() {
        @Nullable IPv6Endpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new IPv6Endpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull @NonNull ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"Version", (Object)String.valueOf(this.fVersion)).put((Object)"Traffic Class", (Object)String.format("%s%02x", "0x", this.fTrafficClass)).put((Object)"Flow Label", (Object)String.format("%s%05x", "0x", this.fFlowLabel)).put((Object)"Payload Length", (Object)(String.valueOf(this.getPayloadLength()) + " bytes")).put((Object)"Next Header", (Object)String.format("%s%02x", "0x", this.fNextHeader)).put((Object)"Hop Limit", (Object)String.valueOf(this.fHopLimit)).put((Object)"Source IP Address", (Object)NonNullUtils.nullToEmptyString((Object)this.fSourceIpAddress.getHostAddress())).put((Object)"Destination IP Address", (Object)NonNullUtils.nullToEmptyString((Object)this.fDestinationIpAddress.getHostAddress()));
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Src: " + this.fSourceIpAddress.getHostAddress() + " , Dst: " + this.fDestinationIpAddress.getHostAddress();
    }

    @Override
    protected String getSignificationString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fSourceIpAddress.getHostAddress()).append(" > ").append(this.fDestinationIpAddress.getHostAddress());
        ByteBuffer payload = this.fPayload;
        if (payload != null) {
            sb.append(" Len=").append(payload.limit());
        } else {
            sb.append(" Len=0");
        }
        return NonNullUtils.nullToEmptyString((Object)sb);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        Packet child = this.fChildPacket;
        result = child != null ? 31 * result + child.hashCode() : (result *= 31);
        result = 31 * result + this.fVersion;
        result = 31 * result + this.fTrafficClass;
        result = 31 * result + this.fFlowLabel;
        result = 31 * result + this.fPayloadLength;
        result = 31 * result + this.fNextHeader;
        result = 31 * result + this.fHopLimit;
        result = 31 * result + this.fSourceIpAddress.hashCode();
        result = 31 * result + this.fDestinationIpAddress.hashCode();
        if (child == null) {
            result = 31 * result + IPv6Packet.payloadHashCode(this.fPayload);
        }
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv6Packet other = (IPv6Packet)obj;
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        if (this.fVersion != other.fVersion) {
            return false;
        }
        if (this.fTrafficClass != other.fTrafficClass) {
            return false;
        }
        if (this.fFlowLabel != other.fFlowLabel) {
            return false;
        }
        if (this.fPayloadLength != other.fPayloadLength) {
            return false;
        }
        if (this.fNextHeader != other.fNextHeader) {
            return false;
        }
        if (this.fHopLimit != other.fHopLimit) {
            return false;
        }
        if (!this.fSourceIpAddress.equals(other.fSourceIpAddress)) {
            return false;
        }
        if (!this.fDestinationIpAddress.equals(other.fDestinationIpAddress)) {
            return false;
        }
        return this.fChildPacket != null || IPv6Packet.payloadEquals(this.fPayload, other.fPayload);
    }
}

