/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class PDOMInclude
implements IIndexFragmentInclude {
    private static final int INCLUDED_FILE = 0;
    private static final int INCLUDED_BY = 4;
    private static final int INCLUDES_NEXT = 8;
    private static final int INCLUDED_BY_NEXT = 12;
    private static final int INCLUDED_BY_PREV = 16;
    private static final int INCLUDE_NAME_OR_LENGTH = 20;
    private static final int NODE_OFFSET = 24;
    private static final int NODE_LENGTH = 27;
    private static final int FLAGS = 29;
    private static final int RECORD_SIZE = 30;
    private static final int FLAG_SYSTEM_INCLUDE = 1;
    private static final int FLAG_INACTIVE_INCLUDE = 2;
    private static final int FLAG_RESOLVED_BY_HEURISTICS = 4;
    private static final int FLAG_DEDUCIBLE_NAME = 8;
    private static final int FLAG_EXPORTED_FILE = 16;
    private final PDOMLinkage linkage;
    private final long record;
    private String fName;

    public PDOMInclude(PDOMLinkage linkage, long record) {
        this.linkage = linkage;
        this.record = record;
    }

    public PDOMInclude(PDOMLinkage linkage, IASTPreprocessorIncludeStatement include, PDOMFile containerFile, PDOMFile targetFile) throws CoreException {
        boolean deducible_name;
        this.linkage = linkage;
        this.record = linkage.getDB().malloc(30);
        IASTName name = include.getName();
        char[] nameChars = name.getSimpleID();
        IASTFileLocation loc = name.getFileLocation();
        if (loc != null) {
            linkage.getDB().put3ByteUnsignedInt(this.record + 24L, loc.getNodeOffset());
            linkage.getDB().putShort(this.record + 27L, (short)loc.getNodeLength());
        }
        Database db = linkage.getDB();
        if (targetFile != null) {
            db.putRecPtr(this.record + 0L, targetFile.getRecord());
        }
        if (deducible_name = PDOMInclude.isDeducibleName(targetFile, nameChars)) {
            db.putInt(this.record + 20L, nameChars.length);
        } else {
            db.putRecPtr(this.record + 20L, db.newString(nameChars).getRecord());
        }
        this.setFlag(this.encodeFlags(include, deducible_name));
        this.setIncludedBy(containerFile);
    }

    private byte encodeFlags(IASTPreprocessorIncludeStatement include, boolean deducible_name) {
        byte flags = 0;
        if (include.isSystemInclude()) {
            flags = (byte)(flags | 1);
        }
        if (!include.isActive()) {
            flags = (byte)(flags | 2);
        } else if (include.isResolvedByHeuristics()) {
            flags = (byte)(flags | 4);
        }
        if (include.isIncludedFileExported()) {
            flags = (byte)(flags | 0x10);
        }
        if (deducible_name) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    public long getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        if (this.isResolved()) {
            this.removeThisFromIncludedByChain();
        }
        Database db = this.linkage.getDB();
        if ((this.getFlag() & 8) == 0) {
            long rec = db.getRecPtr(this.record + 20L);
            db.getString(rec).delete();
        }
        db.free(this.record);
    }

    private void removeThisFromIncludedByChain() throws CoreException {
        PDOMInclude prevInclude = this.getPrevInIncludedBy();
        PDOMInclude nextInclude = this.getNextInIncludedBy();
        if (prevInclude != null) {
            prevInclude.setNextInIncludedBy(nextInclude);
        } else {
            ((PDOMFile)this.getIncludes()).setFirstIncludedBy(nextInclude);
        }
        if (nextInclude != null) {
            nextInclude.setPrevInIncludedBy(prevInclude);
        }
    }

    @Override
    public IIndexFragmentFile getIncludes() throws CoreException {
        long rec = this.linkage.getDB().getRecPtr(this.record + 0L);
        return rec != 0L ? new PDOMFile(this.linkage, rec) : null;
    }

    void setIncludes(PDOMFile includedFile) throws CoreException {
        long rec = includedFile != null ? includedFile.getRecord() : 0L;
        this.linkage.getDB().putRecPtr(this.record + 0L, rec);
    }

    private static boolean isDeducibleName(PDOMFile includedFile, char[] name) throws CoreException {
        if (includedFile == null) {
            return false;
        }
        String s = includedFile.getLocation().getURI().getPath();
        int pos = s.length() - name.length;
        if (pos < 0) {
            return false;
        }
        int i = 0;
        while (i < name.length) {
            if (s.charAt(pos) != name[i]) {
                return false;
            }
            ++i;
            ++pos;
        }
        return true;
    }

    @Override
    public IIndexFile getIncludedBy() throws CoreException {
        long rec = this.linkage.getDB().getRecPtr(this.record + 4L);
        return rec != 0L ? new PDOMFile(this.linkage, rec) : null;
    }

    void setIncludedBy(PDOMFile includedBy) throws CoreException {
        long rec = includedBy != null ? includedBy.getRecord() : 0L;
        this.linkage.getDB().putRecPtr(this.record + 4L, rec);
    }

    public PDOMInclude getNextInIncludes() throws CoreException {
        long rec = this.linkage.getDB().getRecPtr(this.record + 8L);
        return rec != 0L ? new PDOMInclude(this.linkage, rec) : null;
    }

    public void setNextInIncludes(PDOMInclude include) throws CoreException {
        long rec = include != null ? include.getRecord() : 0L;
        this.linkage.getDB().putRecPtr(this.record + 8L, rec);
    }

    public PDOMInclude getNextInIncludedBy() throws CoreException {
        long rec = this.linkage.getDB().getRecPtr(this.record + 12L);
        return rec != 0L ? new PDOMInclude(this.linkage, rec) : null;
    }

    public void setNextInIncludedBy(PDOMInclude include) throws CoreException {
        long rec = include != null ? include.getRecord() : 0L;
        this.linkage.getDB().putRecPtr(this.record + 12L, rec);
    }

    public PDOMInclude getPrevInIncludedBy() throws CoreException {
        long rec = this.getPrevInIncludedByRecord();
        return rec != 0L ? new PDOMInclude(this.linkage, rec) : null;
    }

    long getPrevInIncludedByRecord() throws CoreException {
        return this.linkage.getDB().getRecPtr(this.record + 16L);
    }

    public void setPrevInIncludedBy(PDOMInclude include) throws CoreException {
        long rec = include != null ? include.getRecord() : 0L;
        this.linkage.getDB().putRecPtr(this.record + 16L, rec);
    }

    @Override
    public IIndexFileLocation getIncludedByLocation() throws CoreException {
        return this.getIncludedBy().getLocation();
    }

    @Override
    public IIndexFileLocation getIncludesLocation() throws CoreException {
        IIndexFragmentFile includes = this.getIncludes();
        return includes != null ? includes.getLocation() : null;
    }

    @Override
    public IIndexFragment getFragment() {
        return this.linkage.getPDOM();
    }

    private void setFlag(byte flag) throws CoreException {
        this.linkage.getDB().putByte(this.record + 29L, flag);
    }

    private int getFlag() throws CoreException {
        return this.linkage.getDB().getByte(this.record + 29L);
    }

    @Override
    public boolean isSystemInclude() throws CoreException {
        return (this.getFlag() & 1) != 0;
    }

    @Override
    public boolean isActive() throws CoreException {
        return (this.getFlag() & 2) == 0;
    }

    @Override
    public boolean isResolved() throws CoreException {
        return this.linkage.getDB().getRecPtr(this.record + 0L) != 0L;
    }

    @Override
    public boolean isResolvedByHeuristics() throws CoreException {
        return (this.getFlag() & 4) != 0;
    }

    @Override
    public boolean isIncludedFileExported() throws CoreException {
        return (this.getFlag() & 0x10) != 0;
    }

    @Override
    public int getNameOffset() throws CoreException {
        return this.linkage.getDB().get3ByteUnsignedInt(this.record + 24L);
    }

    @Override
    public int getNameLength() throws CoreException {
        return this.linkage.getDB().getShort(this.record + 27L) & 0xFFFF;
    }

    @Override
    public String getFullName() throws CoreException {
        if (this.fName == null) {
            Database db = this.linkage.getDB();
            if ((this.getFlag() & 8) == 0) {
                long rec = db.getRecPtr(this.record + 20L);
                this.fName = db.getString(rec).getString();
            } else {
                String path = this.getIncludes().getLocation().getURI().getPath();
                int nameLength = db.getInt(this.record + 20L);
                this.fName = path.substring(Math.max(path.length() - nameLength, 0));
            }
        }
        return this.fName;
    }

    @Override
    public String getName() throws CoreException {
        String fullName = this.getFullName();
        int idx = Math.max(fullName.lastIndexOf(47), fullName.lastIndexOf(92));
        return fullName.substring(idx + 1);
    }

    public void convertToUnresolved() throws CoreException {
        if (this.isResolved()) {
            Database db = this.linkage.getDB();
            int flag = this.getFlag();
            if ((flag & 8) != 0) {
                long rec = db.newString(this.getFullName()).getRecord();
                db.putRecPtr(this.record + 20L, rec);
                this.setFlag((byte)(flag & 0xFFFFFFF7));
            }
            db.putRecPtr(this.record + 0L, 0L);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            IIndexFragmentFile includes;
            boolean isSystem = this.isSystemInclude();
            buf.append(isSystem ? (char)'<' : '\"');
            buf.append(this.getFullName());
            buf.append(isSystem ? (char)'>' : '\"');
            IIndexFile includedBy = this.getIncludedBy();
            if (includedBy != null) {
                buf.append(" in ").append(includedBy);
            }
            if ((includes = this.getIncludes()) != null) {
                buf.append(" resolved to ").append(includes);
            } else {
                buf.append(" unresolved");
            }
        }
        catch (CoreException e) {
            buf.append(" (incomplete due to ").append(((Object)((Object)e)).getClass().getName()).append(')');
            e.printStackTrace();
        }
        return buf.toString();
    }
}

