/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.SeparatorAction;

public class DropDownAggregateAction
extends Action
implements IMenuCreator {
    private final String imgPath;
    private final TraceView view;
    private final int enabledTraceCnt;
    private Menu menu;
    private final Action[] actions;

    public DropDownAggregateAction(TraceView view, int enabledTraceCount, String toolTip, String imgPath, Action ... actions) {
        super(null, 4);
        this.imgPath = imgPath;
        this.actions = actions;
        this.view = view;
        this.enabledTraceCnt = enabledTraceCount;
        this.setToolTipText(toolTip);
    }

    public boolean isEnabled() {
        if (this.enabledTraceCnt <= 0) {
            return true;
        }
        if (this.enabledTraceCnt == 1) {
            return this.view.getNumTraces() == 1;
        }
        return this.view.getNumTraces() > 1;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource(this.imgPath));
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action act = actionArray[n2];
            if (act instanceof SeparatorAction) {
                new MenuItem(this.menu, 2);
            } else {
                ActionContributionItem item = new ActionContributionItem((IAction)act);
                item.fill(this.menu, -1);
            }
            ++n2;
        }
        return this.menu;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }
}

