/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.verify.FileNode;
import org.eclipse.ui.IWorkbenchPart;

public final class ResultTree {
    List<FileNode> traces = new ArrayList<FileNode>();

    public List<FileNode> getTraces() {
        return this.traces;
    }

    public void add(String tracePath, String specPath, VerificationResult res, TraceView view) {
        File traceFile = new File(tracePath);
        FileNode n = null;
        for (FileNode fn : this.traces) {
            if (!fn.getTraceFile().equals(traceFile)) continue;
            n = fn;
            break;
        }
        if (n == null) {
            n = new FileNode(traceFile, view);
            this.traces.add(n);
        }
        n.add(specPath, res);
    }

    public void refresh() {
        ArrayList<FileNode> toRemoveFn = new ArrayList<FileNode>();
        for (FileNode fn : this.traces) {
            if (!fn.refresh()) continue;
            toRemoveFn.add(fn);
        }
        this.traces.removeAll(toRemoveFn);
    }

    public void partClosed(IWorkbenchPart part) {
        ArrayList<FileNode> toRemoveFn = new ArrayList<FileNode>();
        for (FileNode fn : this.traces) {
            if (fn.getView() != part) continue;
            toRemoveFn.add(fn);
        }
        this.traces.removeAll(toRemoveFn);
    }
}

