/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.ungroup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public class ChangeCreator {
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        DefinitionVisitor vis = new DefinitionVisitor();
        module.accept((ASTVisitor)vis);
        NavigableSet nodes = vis.getLocations();
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<Definition> locations = new ArrayList<Definition>();
        try {
            WorkspaceJob job1 = this.calculateEditLocations(nodes, toVisit, locations);
            job1.join();
        }
        catch (InterruptedException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)"UngroupModuleparRefactoring/CreateChange.createFileChange(): CoreException while calculating edit locations. ");
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (locations.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        int precedeOffset = -1;
        String fileContents = ChangeCreator.loadFileContent(toVisit);
        for (Definition node : locations) {
            Location valueLocation;
            Def_ModulePar modulePar;
            Location l = node.getCumulativeDefinitionLocation();
            Location typeLocation = node.getType(CompilationTimeStamp.getBaseTimestamp()).getLocation();
            Location identifierLocation = node.getIdentifier().getLocation();
            if (precedeOffset != l.getOffset()) {
                precedeOffset = l.getOffset();
                int len = l.getEndOffset() - l.getOffset();
                rootEdit.addChild((TextEdit)new DeleteEdit(l.getOffset(), len + 1));
            }
            String typeText = fileContents.substring(typeLocation.getOffset(), typeLocation.getEndOffset()).trim();
            String name = fileContents.substring(identifierLocation.getOffset(), identifierLocation.getEndOffset()).trim();
            String newModulePar = "";
            if (node instanceof Def_ModulePar) {
                modulePar = (Def_ModulePar)node;
                Value defaultValue = modulePar.getDefaultValue();
                if (defaultValue != null) {
                    valueLocation = defaultValue.getLocation();
                    String valueText = fileContents.substring(valueLocation.getOffset(), valueLocation.getEndOffset()).trim();
                    newModulePar = "modulepar " + typeText + " " + name + " := " + valueText + ";\n";
                } else {
                    newModulePar = "modulepar " + typeText + " " + name + ";\n";
                }
            } else if (node instanceof Def_ModulePar_Template) {
                modulePar = (Def_ModulePar_Template)node;
                ITTCN3Template defaultTemplate = modulePar.getDefaultTemplate(CompilationTimeStamp.getBaseTimestamp());
                if (defaultTemplate != null) {
                    valueLocation = defaultTemplate.getLocation();
                    String temlateText = fileContents.substring(valueLocation.getOffset(), valueLocation.getEndOffset()).trim();
                    newModulePar = "modulepar template " + typeText + " " + name + " := " + temlateText + ";\n";
                } else {
                    newModulePar = "modulepar template " + typeText + " " + name + ";\n";
                }
            }
            rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset(), newModulePar));
        }
        return tfc;
    }

    private WorkspaceJob calculateEditLocations(final NavigableSet<Definition> nodes, IFile file, final List<Definition> locations_out) throws CoreException {
        WorkspaceJob job = new WorkspaceJob("UngroupModuleparRefactoring: calculate edit locations"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int precedeOffset = -1;
                Definition precedeNode = null;
                for (Definition node : nodes) {
                    if (node.getCumulativeDefinitionLocation().getOffset() == precedeOffset) {
                        locations_out.add(precedeNode);
                    } else if (!locations_out.isEmpty()) {
                        Definition lastInserted = (Definition)locations_out.get(locations_out.size() - 1);
                        if (precedeNode.getCumulativeDefinitionLocation().getOffset() == lastInserted.getCumulativeDefinitionLocation().getOffset()) {
                            locations_out.add(precedeNode);
                        }
                    }
                    precedeOffset = node.getCumulativeDefinitionLocation().getOffset();
                    precedeNode = node;
                }
                if (!locations_out.isEmpty()) {
                    Definition lastnode = (Definition)nodes.last();
                    Definition lastInserted = (Definition)locations_out.get(locations_out.size() - 1);
                    if (lastnode.getCumulativeDefinitionLocation().getOffset() == lastInserted.getCumulativeDefinitionLocation().getOffset()) {
                        locations_out.add((Definition)nodes.last());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private static String loadFileContent(IFile toLoad) {
        StringBuilder fileContents;
        try {
            InputStream is = toLoad.getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, toLoad.getCharset()));
            fileContents = new StringBuilder();
            char[] buff = new char[1024];
            while (br.ready()) {
                int len = br.read(buff);
                fileContents.append(buff, 0, len);
            }
            br.close();
        }
        catch (IOException e) {
            ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (IOException) for file: " + toLoad.getName()));
            return null;
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (CoreException) for file: " + toLoad.getName()));
            return null;
        }
        return fileContents.toString();
    }

    private static class LocationComparator
    implements Comparator<Definition> {
        private LocationComparator() {
        }

        @Override
        public int compare(Definition arg0, Definition arg1) {
            int o1;
            IResource f1;
            IResource f0 = arg0.getLocation().getFile();
            if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
            }
            int o0 = arg0.getLocation().getOffset();
            if (o0 == (o1 = arg1.getLocation().getOffset())) {
                if (arg0 instanceof Def_ModulePar && arg1 instanceof Def_ModulePar) {
                    String s0 = ((Def_ModulePar)arg0).getIdentifier().getDisplayName();
                    String s1 = ((Def_ModulePar)arg1).getIdentifier().getDisplayName();
                    return s0.compareTo(s1);
                }
                if (arg0 instanceof Def_ModulePar_Template && arg1 instanceof Def_ModulePar_Template) {
                    String s0 = ((Def_ModulePar_Template)arg0).getIdentifier().getDisplayName();
                    String s1 = ((Def_ModulePar_Template)arg1).getIdentifier().getDisplayName();
                    return s0.compareTo(s1);
                }
                return 0;
            }
            return o0 < o1 ? -1 : 1;
        }
    }

    private static class DefinitionVisitor
    extends ASTVisitor {
        private final NavigableSet<Definition> locations = new TreeSet<Definition>(new LocationComparator());

        DefinitionVisitor() {
        }

        private NavigableSet<Definition> getLocations() {
            return this.locations;
        }

        public int visit(IVisitableNode node) {
            Def_ModulePar_Template d;
            if (node instanceof Def_ModulePar) {
                Def_ModulePar d2 = (Def_ModulePar)node;
                if (d2.getCumulativeDefinitionLocation() != null && this.hasValidLocation((Definition)d2)) {
                    this.locations.add((Definition)d2);
                }
            } else if (node instanceof Def_ModulePar_Template && (d = (Def_ModulePar_Template)node).getCumulativeDefinitionLocation() != null && this.hasValidLocation((Definition)d)) {
                this.locations.add((Definition)d);
            }
            return 3;
        }

        private boolean hasValidLocation(Definition def) {
            Location location = def.getLocation();
            return location != null && location.getOffset() >= 0 && location.getEndOffset() >= 0;
        }
    }
}

