/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;

public abstract class Context {
    protected final ContextLoggingRefactoring.Settings settings;
    private final IVisitableNode node;
    private Context parent;
    private Context child;

    public Context(IVisitableNode node, ContextLoggingRefactoring.Settings settings) {
        this.node = node;
        this.settings = settings;
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public void setChild(Context child) {
        this.child = child;
    }

    public Context getParent() {
        return this.parent;
    }

    public Context getChild() {
        return this.child;
    }

    public Context getBottom() {
        if (this.getChild() == null) {
            return this;
        }
        return this.getChild().getBottom();
    }

    public IVisitableNode getNode() {
        return this.node;
    }

    public int getVarCountLimitOption() {
        return 8;
    }

    public final void process() {
        if (this.child != null) {
            this.child.process();
        }
        this.process_internal();
    }

    protected abstract void process_internal();

    public final List<String> createLogParts() {
        return this.createLogParts(new HashSet<String>());
    }

    public final List<String> createLogParts(Set<String> idsAlreadyHandled) {
        if (this.child == null) {
            return new ArrayList<String>();
        }
        List<String> parts = this.child.createLogParts(idsAlreadyHandled);
        parts.addAll(this.createLogParts_internal(idsAlreadyHandled));
        return parts;
    }

    protected abstract List<String> createLogParts_internal(Set<String> var1);

    protected String formatLogPart(String varName) {
        return ", \", " + varName + ": \", " + varName;
    }
}

