/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.risk;

import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.risk.BaseRisk;

public class TriangleRisk
extends BaseRisk {
    public TriangleRisk(IMetricEnum metric) {
        super(metric);
    }

    @Override
    public double getRiskValue(Number value) {
        double risk = 0.0;
        double dist = 0.5 - Math.abs(value.doubleValue() - 0.5);
        switch (this.method) {
            case NEVER: {
                risk = dist * 1.999;
                break;
            }
            case NO_HIGH: {
                double l1 = this.limits[0].doubleValue();
                if (dist >= l1) {
                    risk = 2.0 + (dist - l1) / (0.5 - l1);
                    break;
                }
                risk = dist / l1;
                break;
            }
            case NO_LOW: {
                double l1 = this.limits[0].doubleValue();
                if (dist >= l1) {
                    risk = 1.0 + (dist - l1) / (0.501 - l1);
                    break;
                }
                risk = dist / l1;
                break;
            }
            case NO_LOW_HIGH: {
                double l1 = this.limits[0].doubleValue();
                double l2 = this.limits[1].doubleValue();
                risk = dist < l1 ? dist / l1 : (dist >= l2 ? 2.0 + (dist - l2) / (0.5 - l2) : 1.0 + (dist - l1) / (l2 - l1));
            }
        }
        return risk;
    }
}

