/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanAsn_Null;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanAsn_Null_template
extends Base_Template {
    private ArrayList<TitanAsn_Null_template> value_list;

    public TitanAsn_Null_template() {
    }

    public TitanAsn_Null_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanAsn_Null_template.check_single_selection(otherValue);
    }

    public TitanAsn_Null_template(TitanAsn_Null.Asn_Null_Type otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
    }

    public TitanAsn_Null_template(TitanAsn_Null otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound ASN.1 NULL value.");
    }

    public TitanAsn_Null_template(TitanAsn_Null_template otherValue) {
        this.copy_template(otherValue);
    }

    private void copy_template(TitanAsn_Null_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: 
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanAsn_Null_template temp = new TitanAsn_Null_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported template of ASN.1 NULL type.");
            }
        }
        this.set_selection(otherValue);
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanAsn_Null_template operator_assign(Base_Template.template_sel otherValue) {
        TitanAsn_Null_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanAsn_Null_template operator_assign(TitanAsn_Null otherValue) {
        otherValue.must_bound("Assignment of an unbound ASN.1 NULL value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        return this;
    }

    @Override
    public TitanAsn_Null_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanAsn_Null) {
            return this.operator_assign((TitanAsn_Null)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to ASN.1 NULL type", otherValue));
    }

    public TitanAsn_Null_template operator_assign(TitanAsn_Null.Asn_Null_Type otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        return this;
    }

    public TitanAsn_Null_template operator_assign(Optional<TitanAsn_Null> otherValue) {
        this.clean_up();
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Assignment of an unbound optional field to a template of ASN.1 NULL type.");
            }
        }
        return this;
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanAsn_Null) {
            this.log_match((TitanAsn_Null)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to ASN.1 NULL type", match_value));
    }

    public TitanAsn_Null_template operator_assign(TitanAsn_Null_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    @Override
    public TitanAsn_Null_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanAsn_Null_template) {
            return this.operator_assign((TitanAsn_Null_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to ASN.1 NULL type", otherValue));
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanAsn_Null) {
            return this.match((TitanAsn_Null)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to ASN.1 NULL type", otherValue));
    }

    public boolean match(TitanAsn_Null.Asn_Null_Type otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanAsn_Null otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanAsn_Null.Asn_Null_Type otherValue, boolean legacy) {
        switch (this.template_selection) {
            case OMIT_VALUE: {
                return false;
            }
            case SPECIFIC_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported template of ASN.1 NULL type.");
    }

    public boolean match(TitanAsn_Null otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        return this.match(TitanAsn_Null.Asn_Null_Type.ASN_NULL_VALUE, legacy);
    }

    @Override
    public TitanAsn_Null valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific template of ASN.1 NULL type.");
        }
        return new TitanAsn_Null(TitanAsn_Null.Asn_Null_Type.ASN_NULL_VALUE);
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        if (templateType != Base_Template.template_sel.VALUE_LIST && templateType != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Setting an invalid list type for a template of ASN.1 NULL type.");
        }
        this.clean_up();
        this.set_selection(templateType);
        this.value_list = new ArrayList(listLength);
        for (int i = 0; i < listLength; ++i) {
            this.value_list.add(new TitanAsn_Null_template());
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list template for ASN.1 NULL type.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanAsn_Null_template list_item(int listIndex) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list template for ASN.1 NULL type.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an ASN.1 NULL value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex >= this.value_list.size()) {
            throw new TtcnError("Index overflow in a list template of ASN.1 NULL type.");
        }
        return this.value_list.get(listIndex);
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                TTCN_Logger.log_event_str("NULL");
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    public void log_match(TitanAsn_Null match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "NULL template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanAsn_Null_template temp = new TitanAsn_Null_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Asn_Null: {
                this.operator_assign(TitanAsn_Null.Asn_Null_Type.ASN_NULL_VALUE);
                break;
            }
            default: {
                param.type_error("NULL template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = new Param_Types.Module_Param_Asn_Null();
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported ASN.1 NULL template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        switch (this.template_selection) {
            case SPECIFIC_VALUE: 
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported template of ASN.1 NULL type.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_base(text_buf);
        switch (this.template_selection) {
            case SPECIFIC_VALUE: 
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanAsn_Null_template temp = new TitanAsn_Null_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received in a template for ASN.1 NULL type.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanAsn_Null_template.get_res_name(restriction), name == null ? "ASN.1 NULL" : name));
    }
}

