/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.ILoggerPlugin;
import org.eclipse.titan.runtime.core.LegacyLogger;
import org.eclipse.titan.runtime.core.LoggingParam;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanNull_Type;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;

public final class LoggerPluginManager {
    private final LinkedBlockingQueue<TitanLoggerApi.TitanLogEvent> ring_buffer = new LinkedBlockingQueue();
    private static ThreadLocal<log_event_struct> current_event = new ThreadLocal();
    private static ThreadLocal<Stack<log_event_struct>> events = new ThreadLocal<Stack<log_event_struct>>(){

        @Override
        protected Stack<log_event_struct> initialValue() {
            return new Stack<log_event_struct>();
        }
    };
    private static ThreadLocal<Boolean> is_first = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private ArrayList<LoggingParam.logging_setting_t> logparams = new ArrayList();
    private ArrayList<ILoggerPlugin> plugins_ = new ArrayList();
    private LinkedList<LogEntry> entry_list_ = new LinkedList();

    public LoggerPluginManager() {
        this.plugins_.add(new LegacyLogger());
    }

    public void destructor() {
        if (this.entry_list_ != null) {
            for (LogEntry entry : this.entry_list_) {
                for (int i = 0; i < this.plugins_.size(); ++i) {
                    if (!this.plugins_.get(i).is_configured()) continue;
                    this.plugins_.get(i).log(entry.event_, true, false, false);
                }
            }
            this.entry_list_.clear();
        }
    }

    public void ring_buffer_dump(boolean do_close_file) {
        if (TTCN_Logger.get_emergency_logging_behaviour() == TTCN_Logger.emergency_logging_behaviour_t.BUFFER_ALL) {
            while (!this.ring_buffer.isEmpty()) {
                TitanLoggerApi.TitanLogEvent ringEvent = this.ring_buffer.poll();
                if (ringEvent == null) continue;
                this.internal_log_to_all(ringEvent, true, false, false);
            }
        }
        if (do_close_file) {
            for (int i = 0; i < this.plugins_.size(); ++i) {
                this.plugins_.get(i).close_file();
            }
        }
        this.ring_buffer.clear();
    }

    public void internal_prebuff_logevent(TitanLoggerApi.TitanLogEvent event) {
        LogEntry new_entry = new LogEntry(event);
        if (this.entry_list_ == null) {
            this.entry_list_ = new LinkedList();
            this.entry_list_.add(new_entry);
        } else {
            this.entry_list_.add(new_entry);
        }
    }

    public void internal_log_prebuff_logevent() {
        if (this.entry_list_ == null) {
            return;
        }
        for (LogEntry entry : this.entry_list_) {
            if (entry.event_.get_field_severity().get_int() == TTCN_Logger.Severity.EXECUTOR_LOGOPTIONS.ordinal()) {
                String new_log_message = TTCN_Logger.get_logger_settings_str();
                entry.event_.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_logOptions().operator_assign(new_log_message);
                Object var3_3 = null;
            }
            this.internal_log_to_all(entry.event_, true, false, false);
        }
        this.entry_list_.clear();
    }

    public boolean add_parameter(LoggingParam.logging_setting_t logging_param) {
        boolean duplication_warning = false;
        for (LoggingParam.logging_setting_t par : this.logparams) {
            boolean parameter_overlaps;
            boolean for_all_components = logging_param.component.id_selector == TTCN_Logger.component_id_selector_enum.COMPONENT_ID_ALL || par.component.id_selector == TTCN_Logger.component_id_selector_enum.COMPONENT_ID_ALL;
            boolean for_all_plugins = logging_param.pluginId == null || par.pluginId == null || "*".equals(logging_param.pluginId) || "*".equals(par.pluginId);
            boolean component_overlaps = for_all_components || logging_param.component == par.component;
            boolean plugin_overlaps = for_all_plugins || logging_param.pluginId == null && par.pluginId == null || logging_param.pluginId != null && logging_param.pluginId.equals(par.pluginId);
            boolean bl = parameter_overlaps = logging_param.logparam.log_param_selection == par.logparam.log_param_selection;
            if (parameter_overlaps && logging_param.logparam.log_param_selection == LoggingParam.logging_param_type.LP_PLUGIN_SPECIFIC) {
                parameter_overlaps = logging_param.logparam.param_name == null && par.logparam.param_name == null || logging_param.logparam.param_name != null && logging_param.logparam.param_name.equals(par.logparam.param_name);
            }
            if (!(duplication_warning = component_overlaps && plugin_overlaps && parameter_overlaps)) continue;
            break;
        }
        LoggingParam.logging_setting_t newParam = new LoggingParam.logging_setting_t(logging_param);
        this.logparams.add(newParam);
        return duplication_warning;
    }

    public void set_parameters(TitanComponent component_reference, String component_name) {
        if (this.logparams.isEmpty()) {
            return;
        }
        for (LoggingParam.logging_setting_t par : this.logparams) {
            switch (par.component.id_selector) {
                case COMPONENT_ID_NAME: {
                    if (component_name == null || !component_name.equals(par.component.id_name)) break;
                    this.apply_parameter(par);
                    break;
                }
                case COMPONENT_ID_COMPREF: {
                    if (par.component.id_compref != component_reference.get_component()) break;
                    this.apply_parameter(par);
                    break;
                }
                case COMPONENT_ID_ALL: {
                    this.apply_parameter(par);
                    break;
                }
            }
        }
    }

    private void apply_parameter(LoggingParam.logging_setting_t logparam) {
        if (logparam.pluginId != null && (logparam.pluginId.length() != 1 || logparam.pluginId.charAt(0) == '*')) {
            ILoggerPlugin plugin = this.find_plugin(logparam.pluginId);
            if (plugin != null) {
                this.send_parameter_to_plugin(plugin, logparam);
            } else {
                TTCN_Logger.fatal_error(MessageFormat.format("Logger plug-in with name {0} was not found.", logparam.pluginId));
            }
        } else {
            for (int i = 0; i < this.plugins_.size(); ++i) {
                this.send_parameter_to_plugin(this.plugins_.get(i), logparam);
            }
        }
    }

    private void send_parameter_to_plugin(ILoggerPlugin plugin, LoggingParam.logging_setting_t logparam) {
        switch (logparam.logparam.log_param_selection) {
            case LP_FILEMASK: {
                TTCN_Logger.set_file_mask(logparam.component, logparam.logparam.logoptions_val);
                break;
            }
            case LP_CONSOLEMASK: {
                TTCN_Logger.set_console_mask(logparam.component, logparam.logparam.logoptions_val);
                break;
            }
            case LP_LOGFILESIZE: {
                plugin.set_file_size(logparam.logparam.int_val);
                break;
            }
            case LP_LOGFILENUMBER: {
                plugin.set_file_number(logparam.logparam.int_val);
                break;
            }
            case LP_DISKFULLACTION: {
                plugin.set_disk_full_action(logparam.logparam.disk_full_action_value);
                break;
            }
            case LP_LOGFILE: {
                plugin.set_file_name(logparam.logparam.str_val, true);
                break;
            }
            case LP_TIMESTAMPFORMAT: {
                TTCN_Logger.set_timestamp_format(logparam.logparam.timestamp_value);
                break;
            }
            case LP_SOURCEINFOFORMAT: {
                TTCN_Logger.set_source_info_format(logparam.logparam.source_info_value);
                break;
            }
            case LP_APPENDFILE: {
                plugin.set_append_file(logparam.logparam.bool_val);
                break;
            }
            case LP_LOGEVENTTYPES: {
                TTCN_Logger.set_log_event_types(logparam.logparam.log_event_types_values);
                break;
            }
            case LP_LOGENTITYNAME: {
                TTCN_Logger.set_log_entity_name(logparam.logparam.bool_val ? TTCN_Logger.log_event_types_t.LOGEVENTTYPES_YES : TTCN_Logger.log_event_types_t.LOGEVENTTYPES_NO);
                break;
            }
            case LP_MATCHINGHINTS: {
                TTCN_Logger.set_matching_verbosity(logparam.logparam.matching_verbosity_values);
                break;
            }
            case LP_PLUGIN_SPECIFIC: {
                plugin.set_parameter(logparam.logparam.param_name, logparam.logparam.str_val);
                break;
            }
            case LP_EMERGENCY: {
                TTCN_Logger.set_emergency_logging(logparam.logparam.emergency_logging);
                break;
            }
            case LP_EMERGENCYBEHAVIOR: {
                TTCN_Logger.set_emergency_logging_behaviour(logparam.logparam.emergency_logging_behaviour_value);
                break;
            }
            case LP_EMERGENCYMASK: {
                TTCN_Logger.set_emergency_logging_mask(logparam.component, logparam.logparam.logoptions_val);
                break;
            }
            case LP_EMERGENCYFORFAIL: {
                TTCN_Logger.set_emergency_logging_for_fail_verdict(logparam.logparam.bool_val);
                break;
            }
        }
    }

    public void clear_param_list() {
        this.logparams = null;
        this.logparams = new ArrayList();
    }

    public void clear_plugin_list() {
        this.plugins_ = null;
        this.plugins_ = new ArrayList();
    }

    public ILoggerPlugin find_plugin(String name) {
        if (name == null) {
            // empty if block
        }
        for (int i = 0; i < this.plugins_.size(); ++i) {
            ILoggerPlugin actualPlugin = this.plugins_.get(i);
            String plugin_name = actualPlugin.plugin_name();
            if (plugin_name == null || !plugin_name.equals(name)) continue;
            return actualPlugin;
        }
        return null;
    }

    public boolean plugins_ready() {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            if (!this.plugins_.get(i).is_configured()) continue;
            return true;
        }
        return false;
    }

    private void log(TitanLoggerApi.TitanLogEvent event) {
        TitanLoggerApi.TitanLogEvent ring_event;
        if (!this.plugins_ready()) {
            this.internal_prebuff_logevent(event);
            return;
        }
        this.internal_log_prebuff_logevent();
        if (TTCN_Logger.get_emergency_logging() == 0) {
            this.internal_log_to_all(event, false, false, false);
            return;
        }
        int severityIndex = event.get_field_severity().get_int();
        TTCN_Logger.Severity severity = TTCN_Logger.Severity.values()[severityIndex];
        if (TTCN_Logger.get_emergency_logging_behaviour() == TTCN_Logger.emergency_logging_behaviour_t.BUFFER_MASKED) {
            this.internal_log_to_all(event, true, false, false);
            if (!TTCN_Logger.should_log_to_file(severity) && TTCN_Logger.should_log_to_emergency(severity)) {
                if (this.ring_buffer.size() >= TTCN_Logger.get_emergency_logging()) {
                    this.ring_buffer.poll();
                }
                this.ring_buffer.offer(event);
            }
        } else if (TTCN_Logger.get_emergency_logging_behaviour() == TTCN_Logger.emergency_logging_behaviour_t.BUFFER_ALL) {
            if (this.ring_buffer.size() >= TTCN_Logger.get_emergency_logging() && (ring_event = this.ring_buffer.poll()) != null) {
                this.internal_log_to_all(ring_event, true, false, false);
            }
            this.ring_buffer.offer(event);
        }
        if (severity == TTCN_Logger.Severity.ERROR_UNQUALIFIED || TTCN_Logger.get_emergency_logging_for_fail_verdict() && severity == TTCN_Logger.Severity.VERDICTOP_SETVERDICT && event.get_field_logEvent().get_field_choice().get_field_verdictOp().get_field_choice().get_field_setVerdict().get_field_newVerdict().operator_equals(TitanLoggerApi.Verdict.enum_type.v3fail)) {
            while (!this.ring_buffer.isEmpty()) {
                ring_event = this.ring_buffer.poll();
                if (ring_event == null) continue;
                if (TTCN_Logger.get_emergency_logging_behaviour() == TTCN_Logger.emergency_logging_behaviour_t.BUFFER_MASKED) {
                    this.internal_log_to_all(ring_event, true, true, false);
                    continue;
                }
                if (TTCN_Logger.get_emergency_logging_behaviour() != TTCN_Logger.emergency_logging_behaviour_t.BUFFER_ALL) continue;
                this.internal_log_to_all(ring_event, true, false, true);
            }
            this.ring_buffer.clear();
        }
    }

    private void internal_log_to_all(TitanLoggerApi.TitanLogEvent event, boolean log_buffered, boolean separate_file, boolean use_emergency_mask) {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            this.plugins_.get(i).log(event, log_buffered, separate_file, use_emergency_mask);
        }
    }

    public void set_file_name(String new_filename_skeleton, boolean from_config) {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            this.plugins_.get(i).set_file_name(new_filename_skeleton, from_config);
        }
    }

    public void set_append_file(boolean new_append_file) {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            this.plugins_.get(i).set_append_file(new_append_file);
        }
    }

    public boolean set_file_size(int p_size) {
        boolean ret_val = false;
        for (int i = 0; i < this.plugins_.size(); ++i) {
            if (!this.plugins_.get(i).set_file_size(p_size)) continue;
            ret_val = true;
        }
        return ret_val;
    }

    public boolean set_file_number(int p_number) {
        boolean ret_val = false;
        for (int i = 0; i < this.plugins_.size(); ++i) {
            if (!this.plugins_.get(i).set_file_number(p_number)) continue;
            ret_val = true;
        }
        return ret_val;
    }

    public boolean set_disk_full_action(TTCN_Logger.disk_full_action_t p_disk_full_action) {
        boolean ret_val = false;
        for (int i = 0; i < this.plugins_.size(); ++i) {
            if (!this.plugins_.get(i).set_disk_full_action(p_disk_full_action)) continue;
            ret_val = true;
        }
        return ret_val;
    }

    public void open_file() {
        boolean free_entry_list = false;
        if (this.plugins_.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.plugins_.size(); ++i) {
            ILoggerPlugin actualPlugin = this.plugins_.get(i);
            actualPlugin.open_file(is_first.get());
            if (!actualPlugin.is_configured()) continue;
            free_entry_list = true;
            for (LogEntry entry : this.entry_list_) {
                if (entry.event_.get_field_severity().get_int() == TTCN_Logger.Severity.EXECUTOR_LOGOPTIONS.ordinal()) {
                    String new_log_message = TTCN_Logger.get_logger_settings_str();
                    entry.event_.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_logOptions().operator_assign(new_log_message);
                }
                actualPlugin.log(entry.event_, true, false, false);
            }
        }
        if (free_entry_list) {
            this.entry_list_.clear();
        }
        is_first.set(false);
    }

    public void close_file() {
        while (current_event.get() != null) {
            this.finish_event();
        }
        this.ring_buffer_dump(true);
    }

    public String get_current_event_str() {
        if (current_event == null) {
            return null;
        }
        return LoggerPluginManager.current_event.get().buffer.toString();
    }

    public void begin_event(TTCN_Logger.Severity msg_severity) {
        log_event_struct temp = new log_event_struct();
        current_event.set(temp);
        temp.severity = msg_severity;
        temp.buffer = new StringBuilder(100);
        temp.event_destination = TTCN_Logger.log_this_event(msg_severity) ? event_destination_t.ED_FILE : event_destination_t.ED_NONE;
        events.get().push(temp);
    }

    public void begin_event_log2str() {
        log_event_struct temp = new log_event_struct();
        current_event.set(temp);
        temp.severity = TTCN_Logger.Severity.USER_UNQUALIFIED;
        temp.buffer = new StringBuilder(100);
        temp.event_destination = event_destination_t.ED_STRING;
        events.get().push(temp);
    }

    public void end_event() {
        log_event_struct tempEventStruct = current_event.get();
        if (tempEventStruct == null) {
            this.log_unhandled_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED, "TTCN_Logger::end_event(): not in event.");
            return;
        }
        switch (tempEventStruct.event_destination) {
            case ED_NONE: {
                break;
            }
            case ED_FILE: {
                this.log_unhandled_event(tempEventStruct.severity, LoggerPluginManager.current_event.get().buffer.toString());
                break;
            }
            case ED_STRING: {
                TTCN_Logger.fatal_error("TTCN_Logger.end_event(): event with string destination was found, missing call of TTCN_Logger.end_event_log2str().");
            }
        }
        Stack<log_event_struct> localEvents = events.get();
        localEvents.pop();
        if (!localEvents.isEmpty()) {
            current_event.set(localEvents.peek());
        } else {
            current_event.set(null);
        }
    }

    public TitanCharString end_event_log2str() {
        log_event_struct tempEventStruct = current_event.get();
        if (tempEventStruct == null) {
            this.log_unhandled_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED, "TTCN_Logger::end_event_log2str(): not in event.");
            return new TitanCharString();
        }
        TitanCharString ret_val = new TitanCharString(tempEventStruct.buffer);
        Stack<log_event_struct> localEvents = events.get();
        localEvents.pop();
        if (!localEvents.isEmpty()) {
            current_event.set(localEvents.peek());
        } else {
            current_event.set(null);
        }
        return ret_val;
    }

    public void finish_event() {
        while (current_event.get() != null && LoggerPluginManager.current_event.get().event_destination == event_destination_t.ED_STRING) {
            this.end_event_log2str();
        }
        if (current_event.get() != null) {
            this.log_event_str("<unfinished>");
            this.end_event();
        }
    }

    public void log_event_str(String string) {
        log_event_struct tempEventStruct = current_event.get();
        if (tempEventStruct != null) {
            if (tempEventStruct.event_destination == event_destination_t.ED_NONE) {
                return;
            }
            if (string == null) {
                tempEventStruct.buffer.append("<NULL pointer>");
            } else {
                tempEventStruct.buffer.append(string);
            }
        } else {
            this.log_unhandled_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED, "TTCN_Logger::log_event_str(): not in event.");
        }
    }

    public void log_char(char c) {
        log_event_struct tempEventStruct = current_event.get();
        if (tempEventStruct != null) {
            if (tempEventStruct.event_destination == event_destination_t.ED_NONE || c == '\u0000') {
                return;
            }
            tempEventStruct.buffer.append(c);
        } else {
            this.log_unhandled_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED, "TTCN_Logger::log_char(): not in event.");
        }
    }

    public void log_event_va_list(String formatString, Object ... args) {
        log_event_struct tempEventStruct = current_event.get();
        if (tempEventStruct != null) {
            if (tempEventStruct.event_destination == event_destination_t.ED_NONE) {
                return;
            }
            tempEventStruct.buffer.append(String.format(Locale.US, formatString, args));
        } else {
            this.log_unhandled_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED, "TTCN_Logger::log_event_va_list(): not in event.");
        }
    }

    public void log_unhandled_event(TTCN_Logger.Severity severity, String message) {
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        event.get_field_logEvent().get_field_choice().get_field_unhandledEvent().operator_assign(message);
        this.log(event);
    }

    public void log_log_options(String message) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_LOGOPTIONS) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_LOGOPTIONS);
        event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_logOptions().operator_assign(message);
        this.log(event);
    }

    public void log_timer_read(String timer_name, double timeout_val) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_READ) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_READ);
        TitanLoggerApi.TimerType timer = event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_readTimer();
        timer.get_field_name().operator_assign(timer_name);
        timer.get_field_value__().operator_assign(timeout_val);
        this.log(event);
    }

    public void log_timer_start(String timer_name, double start_val) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_START) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_START);
        TitanLoggerApi.TimerType timer = event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_startTimer();
        timer.get_field_name().operator_assign(timer_name);
        timer.get_field_value__().operator_assign(start_val);
        this.log(event);
    }

    public void log_timer_guard(double start_val) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_GUARD) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_GUARD);
        TitanLoggerApi.TimerGuardType timer = event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_guardTimer();
        timer.get_field_value__().operator_assign(start_val);
        this.log(event);
    }

    public void log_timer_stop(String timer_name, double stop_val) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_STOP) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_STOP);
        TitanLoggerApi.TimerType timer = event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_stopTimer();
        timer.get_field_name().operator_assign(timer_name);
        timer.get_field_value__().operator_assign(stop_val);
        this.log(event);
    }

    public void log_timer_timeout(String timer_name, double timeout_val) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_TIMEOUT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_TIMEOUT);
        TitanLoggerApi.TimerType timer = event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_timeoutTimer();
        timer.get_field_name().operator_assign(timer_name);
        timer.get_field_value__().operator_assign(timeout_val);
        this.log(event);
    }

    public void log_timer_any_timeout() {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_TIMEOUT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_TIMEOUT);
        event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_timeoutAnyTimer().operator_assign(TitanNull_Type.NULL_VALUE);
        this.log(event);
    }

    public void log_timer_unqualified(String message) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TIMEROP_UNQUALIFIED) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TIMEROP_UNQUALIFIED);
        event.get_field_logEvent().get_field_choice().get_field_timerEvent().get_field_choice().get_field_unqualifiedTimer().operator_assign(message);
        this.log(event);
    }

    public void log_matching_timeout(String timer_name) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PROBLEM) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.MATCHING_PROBLEM);
        TitanLoggerApi.MatchingTimeout mt = event.get_field_logEvent().get_field_choice().get_field_matchingEvent().get_field_choice().get_field_matchingTimeout();
        if (timer_name != null) {
            mt.get_field_timer__name().get().operator_assign(timer_name);
        } else {
            mt.get_field_timer__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        }
        this.log(event);
    }

    public void log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type operation, String port_name, int componentReference, int id, TitanCharString address, TitanCharString parameter) {
        TTCN_Logger.Severity sev;
        switch (operation) {
            case enqueue__msg: 
            case extract__msg: {
                sev = TTCN_Logger.Severity.PORTEVENT_MQUEUE;
                break;
            }
            case enqueue__call: 
            case enqueue__reply: 
            case enqueue__exception: 
            case extract__op: {
                sev = TTCN_Logger.Severity.PORTEVENT_PQUEUE;
                break;
            }
            default: {
                throw new TtcnError("Invalid operation");
            }
        }
        if (!TTCN_Logger.log_this_event(sev) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, sev);
        TitanLoggerApi.Port__Queue portQueue = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_portQueue();
        portQueue.get_field_operation().operator_assign(operation.ordinal());
        portQueue.get_field_port__name().operator_assign(port_name);
        portQueue.get_field_compref().operator_assign(LoggerPluginManager.adjust_compref(componentReference));
        portQueue.get_field_msgid().operator_assign(id);
        portQueue.get_field_address__().operator_assign(address);
        portQueue.get_field_param__().operator_assign(parameter);
        this.log(event);
    }

    private static int adjust_compref(int compref) {
        if (compref == 1) {
            switch (TTCN_Runtime.get_state()) {
                case MTC_CONTROLPART: 
                case SINGLE_CONTROLPART: {
                    return -4;
                }
            }
        }
        return compref;
    }

    public void log_port_state(TitanLoggerApi.Port__State_operation.enum_type operation, String portname) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_STATE)) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.PORTEVENT_STATE);
        TitanLoggerApi.Port__State ps = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_portState();
        ps.get_field_operation().operator_assign(operation);
        ps.get_field_port__name().operator_assign(portname);
        this.log(event);
    }

    public void log_procport_send(String portname, TitanLoggerApi.Port__oper.enum_type operation, int componentReference, TitanCharString system, TitanCharString parameter) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = componentReference == 2 ? TTCN_Logger.Severity.PORTEVENT_PMOUT : TTCN_Logger.Severity.PORTEVENT_PCOUT;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Proc__port__out pt = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_procPortSend();
        pt.get_field_operation().operator_assign(operation);
        pt.get_field_port__name().operator_assign(portname);
        pt.get_field_compref().operator_assign(componentReference);
        if (componentReference == 2) {
            pt.get_field_sys__name().operator_assign(system);
        }
        pt.get_field_parameter().operator_assign(parameter);
        this.log(event);
    }

    public void log_procport_recv(String portname, TitanLoggerApi.Port__oper.enum_type operation, int componentReference, boolean check, TitanCharString parameter, int id) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = componentReference == 2 ? TTCN_Logger.Severity.PORTEVENT_PMIN : TTCN_Logger.Severity.PORTEVENT_PCIN;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Proc__port__in pt = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_procPortRecv();
        pt.get_field_operation().operator_assign(operation);
        pt.get_field_port__name().operator_assign(portname);
        pt.get_field_compref().operator_assign(componentReference);
        pt.get_field_check__().operator_assign(check);
        pt.get_field_parameter().operator_assign(parameter);
        pt.get_field_msgid().operator_assign(id);
        this.log(event);
    }

    public void log_msgport_send(String portname, int componentReference, TitanCharString parameter) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = componentReference == 2 ? TTCN_Logger.Severity.PORTEVENT_MMSEND : TTCN_Logger.Severity.PORTEVENT_MCSEND;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Msg__port__send ms = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_msgPortSend();
        ms.get_field_port__name().operator_assign(portname);
        ms.get_field_compref().operator_assign(componentReference);
        ms.get_field_parameter().operator_assign(parameter);
        this.log(event);
    }

    public void log_msgport_recv(String portname, TitanLoggerApi.Msg__port__recv_operation.enum_type operation, int componentReference, TitanCharString system, TitanCharString parameter, int id) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = componentReference == 2 ? TTCN_Logger.Severity.PORTEVENT_MMRECV : TTCN_Logger.Severity.PORTEVENT_MCRECV;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Msg__port__recv ms = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_msgPortRecv();
        ms.get_field_port__name().operator_assign(portname);
        ms.get_field_compref().operator_assign(componentReference);
        if (componentReference == 2) {
            ms.get_field_sys__name().operator_assign(system);
        }
        ms.get_field_operation().operator_assign(operation);
        ms.get_field_msgid().operator_assign(id);
        ms.get_field_parameter().operator_assign(parameter);
        this.log(event);
    }

    public void log_dualport_map(boolean incoming, String target_type, TitanCharString value, int id) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = incoming ? TTCN_Logger.Severity.PORTEVENT_DUALRECV : TTCN_Logger.Severity.PORTEVENT_DUALSEND;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Dualface__mapped dual = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_dualMapped();
        dual.get_field_incoming().operator_assign(incoming);
        dual.get_field_target__type().operator_assign(target_type);
        dual.get_field_value__().operator_assign(value);
        dual.get_field_msgid().operator_assign(id);
        this.log(event);
    }

    public void log_dualport_discard(boolean incoming, String target_type, TitanCharString port_name, boolean unhandled) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = incoming ? TTCN_Logger.Severity.PORTEVENT_DUALRECV : TTCN_Logger.Severity.PORTEVENT_DUALSEND;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Dualface__discard dual = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_dualDiscard();
        dual.get_field_incoming().operator_assign(incoming);
        dual.get_field_target__type().operator_assign(target_type);
        dual.get_field_port__name().operator_assign(port_name);
        dual.get_field_unhandled().operator_assign(unhandled);
        this.log(event);
    }

    public void log_dualport_discard(boolean incoming, String target_type, String port_name, boolean unhandled) {
        TTCN_Logger.Severity severity;
        TTCN_Logger.Severity severity2 = severity = incoming ? TTCN_Logger.Severity.PORTEVENT_DUALRECV : TTCN_Logger.Severity.PORTEVENT_DUALSEND;
        if (!TTCN_Logger.log_this_event(severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, severity);
        TitanLoggerApi.Dualface__discard dual = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_dualDiscard();
        dual.get_field_incoming().operator_assign(incoming);
        dual.get_field_target__type().operator_assign(target_type);
        dual.get_field_port__name().operator_assign(port_name);
        dual.get_field_unhandled().operator_assign(unhandled);
        this.log(event);
    }

    public void log_setstate(String port_name, TitanPort.translation_port_state state, TitanCharString info) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_SETSTATE) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.PORTEVENT_SETSTATE);
        TitanLoggerApi.Setstate setstate = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_setState();
        setstate.get_field_port__name().operator_assign(port_name);
        setstate.get_field_info().operator_assign(info);
        switch (state) {
            case UNSET: {
                setstate.get_field_state().operator_assign("unset");
                break;
            }
            case TRANSLATED: {
                setstate.get_field_state().operator_assign("translated");
                break;
            }
            case NOT_TRANSLATED: {
                setstate.get_field_state().operator_assign("not translated");
                break;
            }
            case FRAGMENTED: {
                setstate.get_field_state().operator_assign("fragemnted");
                break;
            }
            case PARTIALLY_TRANSLATED: {
                setstate.get_field_state().operator_assign("partially translated");
                break;
            }
            case DISCARDED: {
                setstate.get_field_state().operator_assign("discarded");
                break;
            }
            default: {
                TTCN_Logger.fatal_error("LoggerPluginManager.log_setstate(): unexpected port state");
            }
        }
        this.log(event);
    }

    public void log_setverdict(TitanVerdictType.VerdictTypeEnum newVerdict, TitanVerdictType.VerdictTypeEnum oldVerdict, TitanVerdictType.VerdictTypeEnum localVerdict, String oldReason, String newReason) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.VERDICTOP_SETVERDICT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.VERDICTOP_SETVERDICT);
        TitanLoggerApi.SetVerdictType set = event.get_field_logEvent().get_field_choice().get_field_verdictOp().get_field_choice().get_field_setVerdict();
        set.get_field_newVerdict().operator_assign(newVerdict.ordinal());
        set.get_field_oldVerdict().operator_assign(oldVerdict.ordinal());
        set.get_field_localVerdict().operator_assign(localVerdict.ordinal());
        if (oldReason != null) {
            set.get_field_oldReason().get().operator_assign(oldReason);
        } else {
            set.get_field_oldReason().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        }
        if (newReason != null) {
            set.get_field_newReason().get().operator_assign(newReason);
        } else {
            set.get_field_newReason().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        }
        this.log(event);
    }

    public void log_getverdict(TitanVerdictType.VerdictTypeEnum verdict) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.VERDICTOP_GETVERDICT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.VERDICTOP_GETVERDICT);
        event.get_field_logEvent().get_field_choice().get_field_verdictOp().get_field_choice().get_field_getVerdict().operator_assign(verdict.ordinal());
        this.log(event);
    }

    private void fill_common_fields(TitanLoggerApi.TitanLogEvent event, TTCN_Logger.Severity severity) {
        long timestamp = System.currentTimeMillis();
        event.get_field_timestamp__().operator_assign(new TitanLoggerApi.TimestampType(new TitanInteger(BigInteger.valueOf(timestamp / 1000L)), new TitanInteger((int)(timestamp % 1000L) * 1000)));
        TitanLoggerApi.TitanLogEvent_sourceInfo__list srcinfo = event.get_field_sourceInfo__list();
        if (TTCN_Logger.TTCN_Location.actualSize.get() == 0) {
            srcinfo.operator_assign(TitanNull_Type.NULL_VALUE);
        } else {
            int localSize = TTCN_Logger.TTCN_Location.actualSize.get();
            ArrayList<TTCN_Logger.TTCN_Location> localLocations = TTCN_Logger.TTCN_Location.locations.get();
            for (int i = 0; i < localSize; ++i) {
                TitanLoggerApi.LocationInfo loc = srcinfo.get_at(i);
                TTCN_Logger.TTCN_Location temp = localLocations.get(i);
                loc.get_field_filename().operator_assign(temp.file_name);
                loc.get_field_line().operator_assign(temp.line_number);
                loc.get_field_ent__type().operator_assign(temp.entity_type.ordinal());
                loc.get_field_ent__name().operator_assign(temp.entity_name);
            }
        }
        event.get_field_severity().operator_assign(severity.ordinal());
    }

    public void log_testcase_started(String module_name, String definition_name) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TESTCASE_START) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TESTCASE_START);
        TitanLoggerApi.QualifiedName qname = event.get_field_logEvent().get_field_choice().get_field_testcaseOp().get_field_choice().get_field_testcaseStarted();
        qname.get_field_module__name().operator_assign(module_name);
        qname.get_field_testcase__name().operator_assign(definition_name);
        this.log(event);
    }

    public void log_testcase_finished(String module_name, String definition_name, TitanVerdictType.VerdictTypeEnum verdict, String reason) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.TESTCASE_FINISH) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.TESTCASE_FINISH);
        TitanLoggerApi.TestcaseType testcase = event.get_field_logEvent().get_field_choice().get_field_testcaseOp().get_field_choice().get_field_testcaseFinished();
        TitanLoggerApi.QualifiedName qname = testcase.get_field_name();
        qname.get_field_module__name().operator_assign(module_name);
        qname.get_field_testcase__name().operator_assign(definition_name);
        testcase.get_field_verdict().operator_assign(verdict.ordinal());
        testcase.get_field_reason().operator_assign(reason);
        this.log(event);
    }

    public void log_final_verdict(boolean is_ptc, TitanVerdictType.VerdictTypeEnum ptc_verdict, TitanVerdictType.VerdictTypeEnum local_verdict, TitanVerdictType.VerdictTypeEnum new_verdict, String verdict_reason, int notification, int ptc_compref, String ptc_name) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.VERDICTOP_FINAL) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.VERDICTOP_FINAL);
        TitanLoggerApi.FinalVerdictType finalVerdict = event.get_field_logEvent().get_field_choice().get_field_verdictOp().get_field_choice().get_field_finalVerdict();
        if (notification >= 0) {
            finalVerdict.get_field_choice().get_field_notification().operator_assign(notification);
        } else {
            TitanLoggerApi.FinalVerdictInfo info = finalVerdict.get_field_choice().get_field_info();
            info.get_field_is__ptc().operator_assign(is_ptc);
            info.get_field_ptc__verdict().operator_assign(ptc_verdict.ordinal());
            info.get_field_local__verdict().operator_assign(local_verdict.ordinal());
            info.get_field_new__verdict().operator_assign(new_verdict.ordinal());
            info.get_field_ptc__compref().get().operator_assign(ptc_compref);
            if (verdict_reason == null) {
                info.get_field_verdict__reason().operator_assign(Base_Template.template_sel.OMIT_VALUE);
            } else {
                info.get_field_verdict__reason().get().operator_assign(verdict_reason);
            }
            if (ptc_name == null) {
                info.get_field_ptc__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
            } else {
                info.get_field_ptc__name().get().operator_assign(ptc_name);
            }
        }
        this.log(event);
    }

    public void log_controlpart_start_stop(String moduleName, boolean finished) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.STATISTICS_UNQUALIFIED) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.STATISTICS_UNQUALIFIED);
        TitanLoggerApi.StatisticsType stats = event.get_field_logEvent().get_field_choice().get_field_statistics();
        if (finished) {
            stats.get_field_choice().get_field_controlpartFinish().operator_assign(moduleName);
        } else {
            stats.get_field_choice().get_field_controlpartStart().operator_assign(moduleName);
        }
        this.log(event);
    }

    public void log_controlpart_errors(int error_count) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.STATISTICS_UNQUALIFIED) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.STATISTICS_UNQUALIFIED);
        TitanLoggerApi.StatisticsType stats = event.get_field_logEvent().get_field_choice().get_field_statistics();
        stats.get_field_choice().get_field_controlpartErrors().operator_assign(error_count);
        this.log(event);
    }

    public void log_verdict_statistics(int none_count, double none_percent, int pass_count, double pass_percent, int inconc_count, double inconc_percent, int fail_count, double fail_percent, int error_count, double error_percent) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.STATISTICS_VERDICT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.STATISTICS_VERDICT);
        TitanLoggerApi.StatisticsType stats = event.get_field_logEvent().get_field_choice().get_field_statistics();
        TitanLoggerApi.StatisticsType_choice_verdictStatistics verdictStats = stats.get_field_choice().get_field_verdictStatistics();
        verdictStats.get_field_none__().operator_assign(none_count);
        verdictStats.get_field_nonePercent().operator_assign(none_percent);
        verdictStats.get_field_pass__().operator_assign(pass_count);
        verdictStats.get_field_passPercent().operator_assign(pass_percent);
        verdictStats.get_field_inconc__().operator_assign(inconc_count);
        verdictStats.get_field_inconcPercent().operator_assign(inconc_percent);
        verdictStats.get_field_fail__().operator_assign(fail_count);
        verdictStats.get_field_failPercent().operator_assign(fail_percent);
        verdictStats.get_field_error__().operator_assign(error_count);
        verdictStats.get_field_errorPercent().operator_assign(error_percent);
        this.log(event);
    }

    public void log_defaultop_activate(String name, int id) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEFAULTOP_ACTIVATE) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.DEFAULTOP_ACTIVATE);
        TitanLoggerApi.DefaultOp defaultop = event.get_field_logEvent().get_field_choice().get_field_defaultEvent().get_field_choice().get_field_defaultopActivate();
        defaultop.get_field_name().operator_assign(name);
        defaultop.get_field_id().operator_assign(id);
        defaultop.get_field_end().operator_assign(TitanLoggerApi.DefaultEnd.enum_type.UNKNOWN_VALUE);
        this.log(event);
    }

    public void log_defaultop_deactivate(String name, int id) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEFAULTOP_DEACTIVATE) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.DEFAULTOP_DEACTIVATE);
        TitanLoggerApi.DefaultOp defaultop = event.get_field_logEvent().get_field_choice().get_field_defaultEvent().get_field_choice().get_field_defaultopDeactivate();
        defaultop.get_field_name().operator_assign(name);
        defaultop.get_field_id().operator_assign(id);
        defaultop.get_field_end().operator_assign(TitanLoggerApi.DefaultEnd.enum_type.UNKNOWN_VALUE);
        this.log(event);
    }

    public void log_defaultop_exit(String name, int id, int x) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEFAULTOP_EXIT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.DEFAULTOP_EXIT);
        TitanLoggerApi.DefaultOp defaultop = event.get_field_logEvent().get_field_choice().get_field_defaultEvent().get_field_choice().get_field_defaultopExit();
        defaultop.get_field_name().operator_assign(name);
        defaultop.get_field_id().operator_assign(id);
        defaultop.get_field_end().operator_assign(x);
        this.log(event);
    }

    public void log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type reason) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_RUNTIME) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_RUNTIME);
        TitanLoggerApi.ExecutorRuntime exec = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorRuntime();
        exec.get_field_reason().operator_assign(reason);
        exec.get_field_module__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_testcase__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_pid().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_fd__setsize().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        this.log(event);
    }

    public void log_hc_start(String host) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_RUNTIME) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_RUNTIME);
        TitanLoggerApi.ExecutorRuntime exec = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorRuntime();
        exec.get_field_reason().operator_assign(TitanLoggerApi.ExecutorRuntime_reason.enum_type.host__controller__started);
        exec.get_field_module__name().get().operator_assign(host);
        exec.get_field_testcase__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_pid().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_fd__setsize().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        this.log(event);
    }

    public void log_testcase_exec(String testcase, String module) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_RUNTIME) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_RUNTIME);
        TitanLoggerApi.ExecutorRuntime exec = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorRuntime();
        exec.get_field_reason().operator_assign(TitanLoggerApi.ExecutorRuntime_reason.enum_type.executing__testcase__in__module);
        exec.get_field_module__name().get().operator_assign(module);
        exec.get_field_testcase__name().get().operator_assign(testcase);
        exec.get_field_pid().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_fd__setsize().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        this.log(event);
    }

    public void log_module_init(String module, boolean finish) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_RUNTIME) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_RUNTIME);
        TitanLoggerApi.ExecutorRuntime exec = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorRuntime();
        if (finish) {
            exec.get_field_reason().operator_assign(TitanLoggerApi.ExecutorRuntime_reason.enum_type.initialization__of__module__finished);
        } else {
            exec.get_field_reason().operator_assign(TitanLoggerApi.ExecutorRuntime_reason.enum_type.initializing__module);
        }
        exec.get_field_module__name().get().operator_assign(module);
        exec.get_field_testcase__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_pid().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_fd__setsize().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        this.log(event);
    }

    public void log_mtc_created(long pid) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_RUNTIME) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_RUNTIME);
        TitanLoggerApi.ExecutorRuntime exec = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorRuntime();
        exec.get_field_reason().operator_assign(TitanLoggerApi.ExecutorRuntime_reason.enum_type.mtc__created);
        exec.get_field_module__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_testcase__name().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        exec.get_field_pid().get().operator_assign((int)pid);
        exec.get_field_fd__setsize().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        this.log(event);
    }

    public void log_configdata(TitanLoggerApi.ExecutorConfigdata_reason.enum_type reason, String str) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_CONFIGDATA) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_CONFIGDATA);
        TitanLoggerApi.ExecutorConfigdata cfg = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorConfigdata();
        cfg.get_field_reason().operator_assign(reason);
        if (str != null) {
            cfg.get_field_param__().get().operator_assign(str);
        } else {
            cfg.get_field_param__().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        }
        this.log(event);
    }

    public void log_executor_component(TitanLoggerApi.ExecutorComponent_reason.enum_type reason) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_COMPONENT) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_COMPONENT);
        TitanLoggerApi.ExecutorComponent ec = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorComponent();
        ec.get_field_reason().operator_assign(reason);
        ec.get_field_compref().operator_assign(Base_Template.template_sel.OMIT_VALUE);
        this.log(event);
    }

    public void log_executor_misc(TitanLoggerApi.ExecutorUnqualified_reason.enum_type reason, String name, String address, int port) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_UNQUALIFIED) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_UNQUALIFIED);
        TitanLoggerApi.ExecutorUnqualified ex = event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_executorMisc();
        ex.get_field_reason().operator_assign(reason);
        ex.get_field_name().operator_assign(name);
        ex.get_field_addr().operator_assign(address);
        ex.get_field_port__().operator_assign(port);
        this.log(event);
    }

    public void log_extcommand(TTCN_Logger.extcommand_t action, String cmd) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.EXECUTOR_EXTCOMMAND) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.EXECUTOR_EXTCOMMAND);
        if (action == TTCN_Logger.extcommand_t.EXTCOMMAND_START) {
            event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_extcommandStart().operator_assign(cmd);
        } else {
            event.get_field_logEvent().get_field_choice().get_field_executorEvent().get_field_choice().get_field_extcommandSuccess().operator_assign(cmd);
        }
        this.log(event);
    }

    public void log_matching_done(TitanLoggerApi.MatchingDoneType_reason.enum_type reason, String type, int ptc, String return_type) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_DONE) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.MATCHING_DONE);
        TitanLoggerApi.MatchingDoneType mp = event.get_field_logEvent().get_field_choice().get_field_matchingEvent().get_field_choice().get_field_matchingDone();
        mp.get_field_reason().operator_assign(reason);
        mp.get_field_type__().operator_assign(type);
        mp.get_field_ptc().operator_assign(ptc);
        mp.get_field_return__type().operator_assign(return_type);
        this.log(event);
    }

    public void log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type reason, TitanLoggerApi.MatchingProblemType_operation.enum_type operation, boolean check, boolean anyport, String port_name) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_PROBLEM) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.MATCHING_PROBLEM);
        TitanLoggerApi.MatchingProblemType mp = event.get_field_logEvent().get_field_choice().get_field_matchingEvent().get_field_choice().get_field_matchingProblem();
        mp.get_field_reason().operator_assign(reason);
        mp.get_field_any__port().operator_assign(anyport);
        mp.get_field_check__().operator_assign(check);
        mp.get_field_operation().operator_assign(operation);
        mp.get_field_port__name().operator_assign(port_name);
        this.log(event);
    }

    public void log_random(TitanLoggerApi.RandomAction.enum_type rndAction, double value, long seed) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.FUNCTION_RND) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.FUNCTION_RND);
        TitanLoggerApi.FunctionEvent_choice_random r = event.get_field_logEvent().get_field_choice().get_field_functionEvent().get_field_choice().get_field_random();
        r.get_field_operation().operator_assign(rndAction);
        r.get_field_retval().operator_assign(value);
        r.get_field_intseed().operator_assign((int)seed);
        this.log(event);
    }

    public void log_matching_failure(TitanLoggerApi.PortType.enum_type port_type, String port_name, int compref, TitanLoggerApi.MatchingFailureType_reason.enum_type reason, TitanCharString info) {
        TTCN_Logger.Severity sev;
        if (compref == 2) {
            sev = port_type == TitanLoggerApi.PortType.enum_type.message__ ? TTCN_Logger.Severity.MATCHING_MMUNSUCC : TTCN_Logger.Severity.MATCHING_PMUNSUCC;
        } else {
            TTCN_Logger.Severity severity = sev = port_type == TitanLoggerApi.PortType.enum_type.message__ ? TTCN_Logger.Severity.MATCHING_MCUNSUCC : TTCN_Logger.Severity.MATCHING_PCUNSUCC;
        }
        if (!TTCN_Logger.log_this_event(sev) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, sev);
        TitanLoggerApi.MatchingFailureType mf = event.get_field_logEvent().get_field_choice().get_field_matchingEvent().get_field_choice().get_field_matchingFailure();
        mf.get_field_port__type().operator_assign(port_type);
        mf.get_field_port__name().operator_assign(port_name);
        mf.get_field_reason().operator_assign(reason);
        if (compref == 2) {
            mf.get_field_choice().get_field_system__();
        } else {
            mf.get_field_choice().get_field_compref().operator_assign(compref);
        }
        mf.get_field_info().operator_assign(info);
        this.log(event);
    }

    public void log_matching_success(TitanLoggerApi.PortType.enum_type port_type, String port_name, int compref, TitanCharString info) {
        TTCN_Logger.Severity sev;
        if (compref == 2) {
            sev = port_type == TitanLoggerApi.PortType.enum_type.message__ ? TTCN_Logger.Severity.MATCHING_MMSUCCESS : TTCN_Logger.Severity.MATCHING_PMSUCCESS;
        } else {
            TTCN_Logger.Severity severity = sev = port_type == TitanLoggerApi.PortType.enum_type.message__ ? TTCN_Logger.Severity.MATCHING_MCSUCCESS : TTCN_Logger.Severity.MATCHING_PCSUCCESS;
        }
        if (TTCN_Logger.log_this_event(sev) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, sev);
        TitanLoggerApi.MatchingSuccessType ms = event.get_field_logEvent().get_field_choice().get_field_matchingEvent().get_field_choice().get_field_matchingSuccess();
        ms.get_field_port__type().operator_assign(port_type);
        ms.get_field_port__name().operator_assign(port_name);
        this.log(event);
    }

    public void log_portconnmap(TitanLoggerApi.ParPort_operation.enum_type operation, int src_compref, String src_port, int dst_compref, String dst_port) {
        TTCN_Logger.Severity event_severity;
        switch (operation) {
            case connect__: 
            case disconnect__: {
                event_severity = TTCN_Logger.Severity.PARALLEL_PORTCONN;
                break;
            }
            case map__: 
            case unmap__: {
                event_severity = TTCN_Logger.Severity.PARALLEL_PORTMAP;
                break;
            }
            default: {
                throw new TtcnError("Invalid operation");
            }
        }
        if (!TTCN_Logger.log_this_event(event_severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, event_severity);
        TitanLoggerApi.ParPort pp = event.get_field_logEvent().get_field_choice().get_field_parallelEvent().get_field_choice().get_field_parallelPort();
        pp.get_field_operation().operator_assign(operation);
        pp.get_field_srcCompref().operator_assign(LoggerPluginManager.adjust_compref(src_compref));
        pp.get_field_srcPort().operator_assign(src_port);
        pp.get_field_dstCompref().operator_assign(LoggerPluginManager.adjust_compref(dst_compref));
        pp.get_field_dstPort().operator_assign(dst_port);
        this.log(event);
    }

    public void log_parptc(TitanLoggerApi.ParallelPTC_reason.enum_type reason, String module, String name, int compref, String compname, String tc_loc, int alive_pid, int status) {
        TTCN_Logger.Severity event_severity = alive_pid > 0 && reason == TitanLoggerApi.ParallelPTC_reason.enum_type.function__finished ? TTCN_Logger.Severity.PARALLEL_UNQUALIFIED : TTCN_Logger.Severity.PARALLEL_PTC;
        if (!TTCN_Logger.log_this_event(event_severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, event_severity);
        TitanLoggerApi.ParallelPTC ptc = event.get_field_logEvent().get_field_choice().get_field_parallelEvent().get_field_choice().get_field_parallelPTC();
        ptc.get_field_reason().operator_assign(reason);
        ptc.get_field_module__().operator_assign(module);
        ptc.get_field_name().operator_assign(name);
        ptc.get_field_compref().operator_assign(compref);
        ptc.get_field_tc__loc().operator_assign(tc_loc);
        ptc.get_field_compname().operator_assign(compname);
        ptc.get_field_alive__pid().operator_assign(alive_pid);
        ptc.get_field_status().operator_assign(status);
        this.log(event);
    }

    public void log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type reason, String port_name, int remote_component, String remote_port, String ip_address, int tcp_port, int new_size) {
        if (!TTCN_Logger.log_this_event(TTCN_Logger.Severity.PORTEVENT_UNQUALIFIED) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TitanLoggerApi.TitanLogEvent event = new TitanLoggerApi.TitanLogEvent();
        this.fill_common_fields(event, TTCN_Logger.Severity.PORTEVENT_UNQUALIFIED);
        TitanLoggerApi.Port__Misc portMisc = event.get_field_logEvent().get_field_choice().get_field_portEvent().get_field_choice().get_field_portMisc();
        portMisc.get_field_reason().operator_assign(reason.ordinal());
        portMisc.get_field_port__name().operator_assign(port_name);
        portMisc.get_field_remote__component().operator_assign(remote_component);
        portMisc.get_field_remote__port().operator_assign(remote_port);
        portMisc.get_field_ip__address().operator_assign(ip_address);
        portMisc.get_field_tcp__port().operator_assign(tcp_port);
        portMisc.get_field_new__size().operator_assign(new_size);
        this.log(event);
    }

    public void reset() {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            this.plugins_.get(i).reset();
        }
    }

    private static class LogEntry {
        TitanLoggerApi.TitanLogEvent event_;

        public LogEntry(TitanLoggerApi.TitanLogEvent event) {
            this.event_ = event;
        }
    }

    private static class log_event_struct {
        StringBuilder buffer;
        TTCN_Logger.Severity severity;
        event_destination_t event_destination;

        private log_event_struct() {
        }
    }

    private static enum event_destination_t {
        ED_NONE,
        ED_FILE,
        ED_STRING;

    }
}

