/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.execute;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.common.parsers.cfg.indices.ExecuteSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteSubPage;

public final class ExecuteSectionDragSourceListener
implements DragSourceListener {
    private final TableViewer viewer;
    private final ExecuteSubPage executeSubPage;

    public ExecuteSectionDragSourceListener(ExecuteSubPage executeSubPage, TableViewer viewer) {
        this.executeSubPage = executeSubPage;
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            this.viewer.getTable().setRedraw(false);
            if (event.detail == 2) {
                this.executeSubPage.removeSelectedExecuteItems();
            }
            this.viewer.getTable().setRedraw(true);
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (ExecuteItemTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ArrayList<ExecuteSectionHandler.ExecuteItem> items = new ArrayList<ExecuteSectionHandler.ExecuteItem>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof ExecuteSectionHandler.ExecuteItem)) continue;
                    items.add((ExecuteSectionHandler.ExecuteItem)element);
                }
                event.data = items.toArray(new ExecuteSectionHandler.ExecuteItem[items.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof ExecuteSectionHandler.ExecuteItem;
    }
}

