/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class FirstCharAction
extends AbstractHandler
implements IEditorActionDelegate {
    private IEditorPart targetEditor = null;

    public void run(IAction action) {
        if (this.targetEditor == null || !(this.targetEditor instanceof IEditorWithCarretOffset)) {
            return;
        }
        IEditorWithCarretOffset realEditor = (IEditorWithCarretOffset)this.targetEditor;
        realEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IDocument doc = realEditor.getDocumentProvider().getDocument((Object)realEditor.getEditorInput());
        int offset = realEditor.getCarretOffset();
        try {
            IRegion lineRegion = doc.getLineInformationOfOffset(offset);
            int firstVisibleCharLocation = FirstCharAction.firstVisibleCharLocation(doc, lineRegion);
            if (firstVisibleCharLocation != -1 && firstVisibleCharLocation != offset) {
                realEditor.selectAndReveal(firstVisibleCharLocation, 0);
            } else {
                realEditor.selectAndReveal(lineRegion.getOffset(), 0);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static int firstVisibleCharLocation(IDocument doc, IRegion lineRegion) throws BadLocationException {
        int startOffset;
        int endOffset = Math.min(startOffset + lineRegion.getLength(), doc.getLength() - 1);
        for (startOffset = lineRegion.getOffset(); startOffset <= endOffset; ++startOffset) {
            char ch = doc.getChar(startOffset);
            if (Character.isWhitespace(ch)) continue;
            return startOffset;
        }
        return -1;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.targetEditor == null || !(this.targetEditor instanceof IEditorWithCarretOffset)) {
            return null;
        }
        IEditorWithCarretOffset realEditor = (IEditorWithCarretOffset)this.targetEditor;
        realEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IDocument doc = realEditor.getDocumentProvider().getDocument((Object)realEditor.getEditorInput());
        int offset = realEditor.getCarretOffset();
        try {
            IRegion lineRegion = doc.getLineInformationOfOffset(offset);
            int firstVisibleCharLocation = FirstCharAction.firstVisibleCharLocation(doc, lineRegion);
            if (firstVisibleCharLocation != -1 && firstVisibleCharLocation != offset) {
                realEditor.selectAndReveal(firstVisibleCharLocation, 0);
            } else {
                realEditor.selectAndReveal(lineRegion.getOffset(), 0);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return null;
    }
}

