/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.declarationsearch;

import java.util.List;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.declarationsearch.CommentableDeclaration;
import org.eclipse.titan.designer.declarationsearch.DefinitionDeclaration;
import org.eclipse.titan.designer.declarationsearch.FieldDeclaration;
import org.eclipse.titan.designer.declarationsearch.ModuleDeclaration;

public abstract class Declaration {
    public static Declaration createInstance(Assignment assignment) {
        return new DefinitionDeclaration(assignment);
    }

    public static Declaration createInstance(Assignment ass, Identifier id) {
        if (ass == null || id == null) {
            return null;
        }
        return new FieldDeclaration(ass, id);
    }

    public static Declaration createInstance(Module module) {
        if (module == null) {
            return null;
        }
        return new ModuleDeclaration(module);
    }

    public static Declaration createInstance(ICommentable commentable) {
        if (commentable == null) {
            return null;
        }
        return new CommentableDeclaration(commentable);
    }

    public abstract List<ReferenceFinder.Hit> getReferences(Module var1);

    public abstract ReferenceFinder getReferenceFinder(Module var1);

    public abstract boolean shouldMarkOccurrences();

    public abstract Identifier getIdentifier();

    public abstract Assignment getAssignment();

    public abstract Location getLocation();

    public abstract ICommentable getCommentable();
}

