/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Str2FloatExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The operand of the `str2float' operation should be a charstring value";
    private static final String OPERANDERROR2 = "The operand of the `str2float' operation should be a string containing a valid float value";
    private final Value value;

    public Str2FloatExpression(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.STR2FLOAT_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("str2float(").append(this.value.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_REAL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_CHARSTRING: {
                IValue last = this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                if (!last.isUnfoldable(timestamp)) {
                    String string = ((Charstring_Value)last).getValue();
                    if ("infinity".equals(string = string.trim()) || "-infinity".equals(string) || "not_a_number".equals(string)) {
                        return;
                    }
                    str2floatState state = str2floatState.S_INITIAL;
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        switch (state) {
                            case S_INITIAL: {
                                if (c == '+' || c == '-') {
                                    state = str2floatState.S_FIRST_M;
                                    break;
                                }
                                if (c == '0') {
                                    state = str2floatState.S_ZERO_M;
                                    break;
                                }
                                if (c >= '1' && c <= '9') {
                                    state = str2floatState.S_MORE_M;
                                    break;
                                }
                                if (Character.isWhitespace(c)) {
                                    this.value.getLocation().reportSemanticWarning("Leading whitespace was detected and ignored in the operand of operation `str2float''");
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_FIRST_M: {
                                if (c == '0') {
                                    state = str2floatState.S_ZERO_M;
                                    break;
                                }
                                if (c >= '1' && c <= '9') {
                                    state = str2floatState.S_MORE_M;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_ZERO_M: {
                                if (c == '.') {
                                    state = str2floatState.S_FIRST_F;
                                    break;
                                }
                                if (c == 'E' || c == 'e') {
                                    state = str2floatState.S_INITIAL_E;
                                    break;
                                }
                                if (c >= '0' && c <= '9') {
                                    this.value.getLocation().reportSemanticWarning("Leading zero digit was detected and ignored in the operand of operation `str2float''");
                                    state = str2floatState.S_MORE_M;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_MORE_M: {
                                if (c == '.') {
                                    state = str2floatState.S_FIRST_F;
                                    break;
                                }
                                if (c == 'E' || c == 'e') {
                                    state = str2floatState.S_INITIAL_E;
                                    break;
                                }
                                if (c >= '0' && c <= '9') break;
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_FIRST_F: {
                                if (c >= '0' && c <= '9') {
                                    state = str2floatState.S_MORE_F;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_MORE_F: {
                                if (c == 'E' || c == 'e') {
                                    state = str2floatState.S_INITIAL_E;
                                    break;
                                }
                                if (c >= '0' && c <= '9') break;
                                if (Character.isWhitespace(c)) {
                                    state = str2floatState.S_END;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_INITIAL_E: {
                                if (c == '+' || c == '-') {
                                    state = str2floatState.S_FIRST_E;
                                    break;
                                }
                                if (c == '0') {
                                    state = str2floatState.S_ZERO_E;
                                    break;
                                }
                                if (c >= '1' && c <= '9') {
                                    state = str2floatState.S_MORE_E;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_FIRST_E: {
                                if (c == '0') {
                                    state = str2floatState.S_ZERO_E;
                                    break;
                                }
                                if (c >= '1' && c <= '9') {
                                    state = str2floatState.S_MORE_E;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_ZERO_E: {
                                if (c >= '0' && c <= '9') {
                                    this.value.getLocation().reportSemanticWarning("Leading zero digit was detected and ignored in the exponent of the operation `str2float''");
                                    state = str2floatState.S_MORE_E;
                                    break;
                                }
                                if (Character.isWhitespace(c)) {
                                    state = str2floatState.S_END;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_MORE_E: {
                                if (c >= '0' && c <= '9') break;
                                if (Character.isWhitespace(c)) {
                                    state = str2floatState.S_END;
                                    break;
                                }
                                state = str2floatState.S_ERR;
                                break;
                            }
                            case S_END: {
                                if (!Character.isWhitespace(c)) break;
                                state = str2floatState.S_ERR;
                                break;
                            }
                        }
                        if (state != str2floatState.S_ERR) continue;
                        this.value.getLocation().reportSemanticError(MessageFormat.format("The argument of function str2float(), which is {0}, does not represent a valid float value. Invalid character {1} was found at index {2}. ", string, Character.valueOf(c), i));
                        this.setIsErroneous(true);
                        break;
                    }
                    switch (state) {
                        case S_INITIAL: {
                            this.value.getLocation().reportSemanticError(MessageFormat.format("The argument of function str2float(), which is {0}, should be a string containing a valid float value instead of an empty string.", string));
                            this.setIsErroneous(true);
                            break;
                        }
                        case S_FIRST_M: {
                            this.value.getLocation().reportSemanticError(MessageFormat.format("The argument of function str2float(), which is {0}, should be a string containing a valid float value, but only a sign character was detected.", string));
                            this.setIsErroneous(true);
                            break;
                        }
                        case S_ZERO_M: 
                        case S_MORE_M: {
                            break;
                        }
                        case S_FIRST_F: {
                            break;
                        }
                        case S_INITIAL_E: 
                        case S_FIRST_E: {
                            this.value.getLocation().reportSemanticError(MessageFormat.format("The argument of function str2float(), which is {0}, should be a string containing a valid float value, but the exponent is missing after the `E' sign.", string));
                            this.setIsErroneous(true);
                            break;
                        }
                        case S_END: {
                            break;
                        }
                    }
                }
                return;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
        }
        if (!this.isErroneous) {
            this.location.reportSemanticError(OPERANDERROR1);
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last = this.value.getValueRefdLast(timestamp, referenceChain);
        if (last.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        switch (last.getValuetype()) {
            case CHARSTRING_VALUE: {
                double number;
                String string = ((Charstring_Value)last).getValue();
                string = string.trim();
                if ("-infinity".equals(string)) {
                    number = Double.NEGATIVE_INFINITY;
                } else if ("infinity".equals(string)) {
                    number = Double.POSITIVE_INFINITY;
                } else if ("not_a_number".equals(string)) {
                    number = Double.NaN;
                } else {
                    try {
                        number = Double.parseDouble(string);
                    }
                    catch (NumberFormatException e) {
                        number = 0.0;
                    }
                }
                this.lastValue = new Real_Value(number);
                break;
            }
            default: {
                return this;
            }
        }
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("AdditionalFunctions");
        expression.expression.append("AdditionalFunctions.str2float( ");
        this.value.generateCodeExpressionMandatory(aData, expression, false);
        expression.expression.append(')');
    }

    private static enum str2floatState {
        S_INITIAL,
        S_FIRST_M,
        S_ZERO_M,
        S_MORE_M,
        S_FIRST_F,
        S_MORE_F,
        S_INITIAL_E,
        S_FIRST_E,
        S_ZERO_E,
        S_MORE_E,
        S_END,
        S_ERR;

    }
}

