/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EncodeBase64Expression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The first operand of the `encode_base64' operation should be an octetstring value";
    private static final String OPERANDERROR2 = "The second operand of the `encode_base64' operation should be a boolean value";
    private final Value value;
    private final Value useLineBreaks;

    public EncodeBase64Expression(Value value, Value useLineBreaks) {
        this.value = value;
        this.useLineBreaks = useLineBreaks;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (useLineBreaks != null) {
            useLineBreaks.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ENCODE_BASE64_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("encode_base64(").append(this.value.createStringRepresentation());
        if (this.useLineBreaks != null) {
            builder.append(", ").append(this.useLineBreaks.createStringRepresentation());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.useLineBreaks != null) {
            this.useLineBreaks.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.useLineBreaks != null) {
            this.useLineBreaks.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand1>");
        }
        if (this.useLineBreaks == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value != null) {
            this.value.setLoweridToReference(timestamp);
            IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_OCTETSTRING: {
                    this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.location.reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.useLineBreaks != null) {
            this.useLineBreaks.setLoweridToReference(timestamp);
            IType.Type_type tempType2 = this.useLineBreaks.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_BOOL: {
                    this.useLineBreaks.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.location.reportSemanticError(OPERANDERROR2);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
        if (referenceChain.add(this) && this.useLineBreaks != null) {
            referenceChain.markState();
            this.useLineBreaks.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.useLineBreaks != null) {
            this.useLineBreaks.updateSyntax(reparser, false);
            reparser.updateLocation(this.useLineBreaks.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.useLineBreaks != null) {
            this.useLineBreaks.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.useLineBreaks == null || this.useLineBreaks.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.useLineBreaks != null) {
            this.useLineBreaks.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("AdditionalFunctions");
        expression.expression.append("AdditionalFunctions.encode_base64( ");
        this.value.generateCodeExpressionMandatory(aData, expression, true);
        if (this.useLineBreaks != null) {
            expression.expression.append(", ");
            this.useLineBreaks.generateCodeExpressionMandatory(aData, expression, true);
        }
        expression.expression.append(" )");
    }
}

