/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.statements.Label_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Goto_statement
extends Statement {
    private static final String UNDEFINEDLABELUSED = "Label `{0}'' is used, but not defined";
    private static final String LOCALDEFINITIONCROSSING = "Jump to label `{0}'' crosses a local definition";
    private static final String CROSSEDDEFINITION = "The Definition crossed by label `{0}'' is here";
    private static final String STATEMENT_NAME = "goto";
    private final Identifier identifier;
    private int statementIndex;
    private boolean jumpsForward;

    public Goto_statement(Identifier identifier) {
        this.identifier = identifier;
        this.statementIndex = 0;
        this.jumpsForward = false;
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_GOTO;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.statementIndex = index;
    }

    public int getMyStatementBlockIndex() {
        return this.statementIndex;
    }

    public boolean getJumpsForward() {
        return this.jumpsForward;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        int gotoIndex;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (!this.myStatementBlock.hasLabel(this.identifier)) {
            this.location.reportSemanticError(MessageFormat.format(UNDEFINEDLABELUSED, this.identifier.getDisplayName()));
            this.lastTimeChecked = timestamp;
            return;
        }
        Label_Statement labelStatement = this.myStatementBlock.getLabel(this.identifier);
        labelStatement.setUsed(true);
        StatementBlock labelStatementBlock = labelStatement.getMyStatementBlock();
        int labelIndex = labelStatement.getMyStatementBlockIndex();
        if (this.myStatementBlock == labelStatementBlock) {
            gotoIndex = this.statementIndex;
        } else {
            StatementBlock gotoStatementBlock = this.myStatementBlock;
            StatementBlock parentStatementBlock = this.myStatementBlock.getMyStatementBlock();
            while (parentStatementBlock != labelStatementBlock) {
                gotoStatementBlock = parentStatementBlock;
                parentStatementBlock = gotoStatementBlock.getMyStatementBlock();
            }
            gotoIndex = gotoStatementBlock.getMyStatementBlockIndex();
        }
        if (labelIndex > gotoIndex) {
            for (int i = gotoIndex + 1; i < labelIndex; ++i) {
                Statement statement = labelStatementBlock.getStatementByIndex(i);
                if (!Statement.Statement_type.S_DEF.equals((Object)statement.getType())) continue;
                this.location.reportSemanticError(MessageFormat.format(LOCALDEFINITIONCROSSING, this.identifier.getDisplayName()));
                statement.getLocation().reportSemanticError(MessageFormat.format(CROSSEDDEFINITION, this.identifier.getDisplayName()));
            }
            this.jumpsForward = true;
        } else {
            this.jumpsForward = false;
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        this.location.reportSemanticError("Goto statement is not allowed within an interleave statement");
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.identifier == null || this.identifier.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        source.append("/* 'goto' instruction is not supported */\n");
    }
}

