/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.RecordSetCodeGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Sequence_Type
extends ASN1_Set_Seq_Choice_BaseType {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for record type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for record type `{0}''";
    private static final String SEQUANCEEPECTED = "SEQUENCE value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDERRORASN1 = "Reference to a non-existent component `{0}'' of SEQUENCE type `{1}''";
    private static final String DUPLICATEDFIELDFIRSTASN1 = "Component `{0}'' is already given here";
    private static final String DUBLICATEDFIELDAGAINASN1 = "Duplicated SEQUENCE component `{0}''";
    private static final String WRONGFIELDORDERASN1 = "Component `{0}'' cannot appear after component `{1}'' in SEQUENCE value";
    private static final String UNEXPECTEDFIELDASN1 = "Unexpected component `{0}'' in SEQUENCE value, expecting `{1}''";
    private static final String MISSINGFIELDASN1 = "Mandatory component `{0}'' is missing from SEQUENCE value";
    private static final String NONEXISTENTFIELDERRORTTCN3 = "Reference to a non-existent field `{0}'' in record value for type `{1}''";
    private static final String DUPLICATEDFIELDFIRSTTTCN3 = "Field `{0}'' is already given here";
    private static final String DUBLICATEDFIELDAGAINTTCN3 = "Duplicated record field `{0}''";
    private static final String WRONGFIELDORDERTTCN3 = "Field `{0}'' cannot appear after field `{1}'' in record value";
    private static final String UNEXPECTEDFIELDTTCN3 = "Unexpected field `{0}'' in record value, expecting `{1}''";
    private static final String MISSINGFIELDTTCN3 = "Field `{0}'' is missing from record value";
    private static final String DUPLICATETEMPLATEFIELDFIRST = "Duplicate field `{0}'' in template";
    private static final String DUPLICATETEMPLATEFIELDAGAIN = "Field `{0}'' is already given here";
    private static final String INCORRECTTEMPLATEFIELDORDER = "Field `{0}'' cannot appear after field `{1}'' in a template for record type `{2}''";
    private static final String UNEXPECTEDTEMPLATEFIELD = "Unexpected field `{0}'' in record template, expecting `{1}''";
    private static final String NONEXISTENTTEMPLATEFIELDREFERENCE = "Reference to non-existing field `{0}'' in record template for type `{1}''";
    private static final String MISSINGTEMPLATEFIELD = "Field `{0}'' is missing from template for record type `{1}''";
    private static final String NOFFIELDSDONTMATCH = "The number of fields in record/SEQUENCE types must be the same";
    private static final String NOFFIELDSDIMENSIONDONTMATCH = "The number of fields in SEQUENCE types ({0}) and the size of the array ({1}) must be the same";
    private static final String BADOPTIONALITY = "The optionality of fields in record/SEQUENCE types must be the same";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private CompilationTimeStamp trCompsofTimestamp;
    private static boolean defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
    private static String strictConstantCheckingSeverity;

    public ASN1_Sequence_Type(Block aBlock) {
        this.mBlock = aBlock;
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Sequence_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_SEQUENCE;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_SEQUENCE;
    }

    @Override
    public int getNofComponents() {
        if (null == this.components) {
            this.parseBlockSequence();
        }
        return this.components.getNofComps();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Sequence_Type temporalType = (ASN1_Sequence_Type)temp;
                if (this == temporalType) {
                    return true;
                }
                if (this.getNofComponents() != temporalType.getNofComponents()) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    CompField temporalTypeCompField = temporalType.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeCompFieldType = temporalTypeCompField.getType().getTypeRefdLast(timestamp);
                    if (compField.isOptional() != temporalTypeCompField.isOptional()) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String temporalTypeCompFieldName = temporalTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + temporalTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(temporalTypeCompFieldType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeCompFieldType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeCompFieldType);
                    if (!(compFieldType.equals(temporalTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldame = compField.getIdentifier().getDisplayName();
                        String temporalTypeCompFieldName = temporalTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldame + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + temporalTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)temp;
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    CompField tempTypeComponentField = tempType.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeCompFieldType = tempTypeComponentField.getType().getTypeRefdLast(timestamp);
                    if (compField.isOptional() != tempTypeComponentField.isOptional()) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String temporalTypeCompFieldName = tempTypeComponentField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + temporalTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(temporalTypeCompFieldType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeCompFieldType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeCompFieldType);
                    if (!(compFieldType.equals(temporalTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeComponentField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                SequenceOf_Type temporalType = (SequenceOf_Type)temp;
                if (!temporalType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                int thisNofComps = this.getNofComponents();
                if (thisNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                for (int i = 0; i < thisNofComps; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeOfType = temporalType.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeOfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeOfType);
                    if (!(compFieldType.equals(temporalTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeOfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + compField.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        if (infoTemp.getOp2RefStr().length() > 0) {
                            info.appendOp2Ref("[]");
                        }
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ARRAY: {
                int nofComps = this.getNofComponents();
                if (nofComps == 0) {
                    return false;
                }
                Array_Type temporalType = (Array_Type)temp;
                long temporalTypeNofComps = temporalType.getDimension().getSize();
                if ((long)nofComps != temporalTypeNofComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDIMENSIONDONTMATCH, nofComps, temporalTypeNofComps));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType tempTypeElementType = temporalType.getElementType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, tempTypeElementType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(tempTypeElementType);
                    if (!(compFieldType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + compField.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "sequence.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("sequence");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.components == null) {
            return;
        }
        if (referenceChain.add(this)) {
            for (int i = 0; i < this.components.getNofComps(); ++i) {
                CompField field = this.components.getCompByIndex(i);
                Type type = field.getType();
                if (field.isOptional() || type == null) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.components != null && this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        if (this.components == null) {
            this.parseBlockSequence();
        }
        if (this.isErroneous || this.components == null) {
            return;
        }
        this.trCompsof(timestamp, null);
        this.components.check(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (last.isAsn()) {
                    selfReference = this.checkThisValueSeq_A(timestamp, (Sequence_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                selfReference = this.checkThisValueSeq_T(timestamp, (Sequence_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for SEQUENCE type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE)).isAsn()) {
                    selfReference = this.checkThisValueSeq_A(timestamp, (Sequence_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                selfReference = this.checkThisValueSeq_T(timestamp, (Sequence_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE);
                selfReference = this.checkThisValueSeq_A(timestamp, (Sequence_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(SEQUANCEEPECTED, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueSeq_T(CompilationTimeStamp timestamp, Sequence_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        boolean selfReference = false;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        CompilationTimeStamp valueTimeStamp = value.getLastTimeChecked();
        if (valueTimeStamp == null || valueTimeStamp.isLess(timestamp)) {
            value.removeGeneratedValues();
        }
        boolean inSnyc = true;
        int nofTypeComponents = this.getNofComponents();
        int nofValueComponents = value.getNofComponents();
        int nextIndex = 0;
        CompField lastCompField = null;
        int sequenceIndex = 0;
        int i = 0;
        while (i < nofValueComponents) {
            block21: {
                IValue temporalValue;
                Type type;
                CompField componentField;
                block22: {
                    Identifier valueId;
                    NamedValue namedValue;
                    block20: {
                        namedValue = value.getSeqValueByIndex(i);
                        valueId = namedValue.getName();
                        if (this.hasComponentWithName(valueId)) break block20;
                        namedValue.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELDERRORTTCN3, namedValue.getName().getDisplayName(), this.getTypename()));
                        inSnyc = false;
                        break block21;
                    }
                    if (componentMap.containsKey(valueId.getName())) {
                        namedValue.getLocation().reportSemanticError(MessageFormat.format(DUBLICATEDFIELDAGAINTTCN3, valueId.getDisplayName()));
                        Location tempLocation = ((NamedValue)componentMap.get(valueId.getName())).getLocation();
                        tempLocation.reportSingularSemanticError(MessageFormat.format("Field `{0}'' is already given here", valueId.getDisplayName()));
                        inSnyc = false;
                    } else {
                        componentMap.put(valueId.getName(), namedValue);
                    }
                    componentField = this.getComponentByName(valueId);
                    if (inSnyc) {
                        if (incompleteAllowed) {
                            boolean found = false;
                            for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                                CompField field2 = this.getComponentByIndex(j);
                                if (!valueId.getName().equals(field2.getIdentifier().getName())) continue;
                                lastCompField = field2;
                                nextIndex = j + 1;
                                found = true;
                            }
                            if (lastCompField != null && !found) {
                                namedValue.getLocation().reportSemanticError(MessageFormat.format(WRONGFIELDORDERTTCN3, valueId.getDisplayName(), lastCompField.getIdentifier().getDisplayName()));
                            }
                        } else {
                            CompField field2;
                            CompField field2Original = field2 = this.getComponentByIndex(sequenceIndex);
                            boolean isOptional = field2.isOptional();
                            if (!isOptional && field2.hasDefault() && defaultAsOptional) {
                                isOptional = true;
                            }
                            while (implicitOmit && sequenceIndex < this.getNofComponents() && componentField != field2 && isOptional) {
                                field2 = this.getComponentByIndex(++sequenceIndex);
                            }
                            if (sequenceIndex >= this.getNofComponents() || componentField != field2) {
                                namedValue.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDFIELDTTCN3, valueId.getDisplayName(), field2Original.getIdentifier().getDisplayName()));
                            }
                        }
                    }
                    type = componentField.getType();
                    IValue componentValue = namedValue.getValue();
                    if (componentValue == null) break block21;
                    componentValue.setMyGovernor(type);
                    temporalValue = componentValue;
                    if (componentValue.getValuetype() != IValue.Value_type.NOTUSED_VALUE) break block22;
                    if (!implicitOmit) break block21;
                    temporalValue = componentValue.setValuetype(valueTimeStamp, IValue.Value_type.OMIT_VALUE);
                }
                temporalValue = type.checkThisValueRef(timestamp, temporalValue);
                boolean isOptional = componentField.isOptional();
                if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                    isOptional = true;
                }
                selfReference |= type.checkThisValue(timestamp, temporalValue, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, isOptional, true, implicitOmit, strElem));
            }
            ++i;
            ++sequenceIndex;
        }
        if (!incompleteAllowed || implicitOmit || !"ignore".equals(strictConstantCheckingSeverity)) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier id = this.getComponentByIndex(i).getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    value.insertNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_ASN, id.getDisplayName()), new Omit_Value(), false), i);
                    continue;
                }
                if (incompleteAllowed && "ignore".equals(strictConstantCheckingSeverity)) continue;
                value.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format(MISSINGFIELDTTCN3, id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueSeq_A(CompilationTimeStamp timestamp, Sequence_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean implicitOmit, boolean strElem) {
        int i;
        boolean selfReference = false;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        CompilationTimeStamp valueTimeStamp = value.getLastTimeChecked();
        if (valueTimeStamp == null || valueTimeStamp.isLess(timestamp)) {
            value.removeGeneratedValues();
        }
        int nofTypeComponents = this.getNofComponents();
        int nofValueComponents = value.getNofComponents();
        boolean inSnyc = true;
        int sequenceIndex = 0;
        for (i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSeqValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!this.hasComponentWithName(valueId)) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELDERRORASN1, namedValue.getName().getDisplayName(), this.getTypename()));
                inSnyc = false;
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(DUBLICATEDFIELDAGAINASN1, valueId.getDisplayName()));
                Location tempLocation = ((NamedValue)componentMap.get(valueId.getName())).getLocation();
                tempLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATEDFIELDFIRSTASN1, valueId.getDisplayName()));
                inSnyc = false;
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = this.getComponentByName(valueId);
            if (inSnyc) {
                CompField field2 = null;
                while (sequenceIndex < nofTypeComponents && (field2 = this.getComponentByIndex(sequenceIndex)) != componentField && (field2.isOptional() || field2.hasDefault() || implicitOmit)) {
                    ++sequenceIndex;
                }
                if (field2 == componentField) {
                    ++sequenceIndex;
                } else {
                    if (sequenceIndex >= this.getNofComponents()) {
                        namedValue.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDFIELDASN1, valueId.getDisplayName(), field2.getIdentifier().getDisplayName()));
                    } else {
                        namedValue.getLocation().reportSemanticError(MessageFormat.format("Unexpected component `{0}'' in SEQUENCE value", valueId.getDisplayName()));
                    }
                    inSnyc = false;
                }
            }
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            IValue temporalValue = type.checkThisValueRef(timestamp, componentValue);
            selfReference |= type.checkThisValue(timestamp, temporalValue, lhs, new IType.ValueCheckingOptions(expectedValue, false, false, true, implicitOmit, strElem));
        }
        for (i = 0; i < nofTypeComponents; ++i) {
            CompField componentField = this.getComponentByIndex(i);
            Identifier id = componentField.getIdentifier();
            if (componentMap.containsKey(id.getName())) continue;
            if (!componentField.isOptional() && !componentField.hasDefault()) {
                value.getLocation().reportSemanticError(MessageFormat.format(MISSINGFIELDASN1, id.getDisplayName()));
                continue;
            }
            if (!componentField.isOptional() || !implicitOmit) continue;
            value.insertNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_ASN, id.getDisplayName()), new Omit_Value(), false), i);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        boolean selfReference = false;
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                selfReference = this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit, lhs);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                selfReference = this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit, lhs);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
        return selfReference;
    }

    private boolean checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit, Assignment lhs) {
        int i;
        templateList.removeGeneratedValues();
        boolean selfReference = false;
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents();
        int nofTemplateComponents = templateList.getNofTemplates();
        boolean inSync = true;
        CompField lastComponentField = null;
        int nextIndex = 0;
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (this.hasComponentWithName(identifier)) {
                Type type;
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(DUPLICATETEMPLATEFIELDFIRST, identifier.getDisplayName()));
                    Location tempLocation = ((NamedTemplate)componentMap.get(templateName)).getLocation();
                    tempLocation.reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                    inSync = false;
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier);
                if (inSync) {
                    if (isModified) {
                        boolean found = false;
                        for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                            CompField componentField2 = this.getComponentByIndex(j);
                            if (!templateName.equals(componentField2.getIdentifier().getName())) continue;
                            lastComponentField = componentField2;
                            nextIndex = j + 1;
                            found = true;
                        }
                        if (!found && lastComponentField != null) {
                            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(INCORRECTTEMPLATEFIELDORDER, identifier.getDisplayName(), lastComponentField.getIdentifier().getDisplayName(), this.getFullName()));
                            inSync = false;
                        }
                    } else {
                        CompField componentField2 = this.getComponentByIndex(i);
                        if (componentField2 != componentField && (!componentField2.isOptional() || componentField2.isOptional() && !implicitOmit)) {
                            namedTemplate.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format(UNEXPECTEDTEMPLATEFIELD, identifier.getDisplayName(), componentField2.getIdentifier().getDisplayName()));
                            inSync = false;
                        }
                    }
                }
                if ((type = componentField.getType()) == null || type.getIsErroneous(timestamp)) continue;
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                    isOptional = true;
                }
                selfReference |= componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit, lhs);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTTEMPLATEFIELDREFERENCE, identifier.getDisplayName(), this.getTypename()));
            inSync = false;
        }
        if (!(isModified || !implicitOmit && "ignore".equals(strictConstantCheckingSeverity))) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_ASN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                templateList.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format(MISSINGTEMPLATEFIELD, identifier.getDisplayName(), this.getTypename()));
            }
        }
        return selfReference;
    }

    private void parseBlockSequence() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.components = parser.pr_special_ComponentTypeLists().list;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.components = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.components == null) {
            this.isErroneous = true;
            return;
        }
        this.components.setFullNameParent(this);
        this.components.setMyScope(this.getMyScope());
        this.components.setMyType(this);
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.trCompsofTimestamp != null && !this.trCompsofTimestamp.isLess(timestamp)) {
            return;
        }
        if (referenceChain != null) {
            this.components.trCompsof(timestamp, referenceChain, false);
        } else {
            ReferenceChain temporalReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            this.components.trCompsof(timestamp, temporalReferenceChain, false);
            temporalReferenceChain.release();
        }
        this.trCompsofTimestamp = timestamp;
        this.components.trCompsof(timestamp, null, true);
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cf = this.getComponentByIndex(i);
            cf.getType().checkCodingAttributes(timestamp, refChain);
        }
        refChain.previousState();
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        for (int i = 0; i < this.getNofComponents(); ++i) {
            Type fieldType = this.getComponentByIndex(i).getType();
            fieldType.forceJson(timestamp);
        }
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: 
                    case TYPE_TTCN3_SET: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound && (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET)) {
            this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                if (this.components == null) {
                    return null;
                }
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                if (this.components == null) {
                    return false;
                }
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                int fieldIndex = this.components.indexOf(compField);
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "SEQUENCE_ber_";
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        CompField compField;
        int i;
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.components == null) {
            return;
        }
        String className = this.getGenNameOwn();
        String classReadableName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        HashMap<String, String> attributeRegistry = new HashMap<String, String>();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        ArrayList<RecordSetCodeGenerator.FieldInfo> namesList = new ArrayList<RecordSetCodeGenerator.FieldInfo>();
        boolean hasOptional = false;
        for (i = 0; i < this.components.getNofComps(); ++i) {
            boolean ofType;
            compField = this.components.getCompByIndex(i);
            Type cfType = compField.getType();
            IType lastType = cfType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            switch (lastType.getTypetype()) {
                case TYPE_SEQUENCE_OF: 
                case TYPE_SET_OF: {
                    ofType = true;
                    break;
                }
                default: {
                    ofType = false;
                }
            }
            switch (cfType.getTypetype()) {
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_SEQUENCE_OF: 
                case TYPE_ASN1_CHOICE: 
                case TYPE_ASN1_SET: 
                case TYPE_SET_OF: 
                case TYPE_ASN1_ENUMERATED: {
                    if (cfType.generatesOwnClass(aData, source)) break;
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    break;
                }
                default: {
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                }
            }
            JsonAST jsonAttribute = cfType.getJsonAttribute();
            RecordSetCodeGenerator.FieldInfo fi = new RecordSetCodeGenerator.FieldInfo(cfType.getGenNameValue(aData, source), cfType.getGenNameTemplate(aData, source), compField.getIdentifier().getName(), compField.getIdentifier().getDisplayName(), compField.isOptional(), ofType, cfType.getClass().getSimpleName(), cfType.getGenNameTypeDescriptor(aData, source), jsonAttribute != null ? jsonAttribute.metainfo_unbound : false, jsonAttribute != null ? jsonAttribute.parsed_default_value : null, null, jsonAttribute != null ? jsonAttribute.alias : null, jsonAttribute != null ? jsonAttribute.omit_as_null : false);
            hasOptional |= compField.isOptional();
            namesList.add(fi);
        }
        for (i = 0; i < this.components.getNofComps(); ++i) {
            String ownclassname;
            compField = this.components.getCompByIndex(i);
            StringBuilder tempSource = aData.getCodeForType(compField.getType().getGenNameOwn());
            compField.getType().generateCode(aData, tempSource);
            if (!compField.hasDefault()) continue;
            Value defaultValue = compField.getDefault();
            StringBuilder defaultValueSource = new StringBuilder();
            Type type = compField.getType();
            String typeGeneratedName = type.getGenNameValue(aData, defaultValueSource);
            if (type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
                Array_Type arrayType = (Array_Type)type;
                StringBuilder temp_sb = aData.getCodeForType(arrayType.getGenNameOwn());
                arrayType.generateCodeValue(aData, temp_sb);
            }
            if (!className.equals(ownclassname = defaultValue.get_lhs_name().split("_")[0])) {
                String name = className + defaultValue.get_lhs_name().substring(ownclassname.length());
                defaultValueSource.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}();\n", typeGeneratedName, name));
            } else {
                defaultValueSource.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}();\n", typeGeneratedName, defaultValue.get_lhs_name()));
            }
            defaultValue.generateCodeInit(aData, aData.getPreInit(), defaultValue.getGenNameOwn());
            aData.addGlobalVariable(typeGeneratedName, defaultValueSource.toString());
        }
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        boolean jsonAsValue = this.jsonAttribute != null ? this.jsonAttribute.as_value : false;
        boolean jsonAsMapPossible = this.jsonAttribute != null ? this.jsonAttribute.as_map : false;
        RecordSetCodeGenerator.generateValueClass(aData, source, className, classReadableName, namesList, hasOptional, true, hasRaw, null, hasJson, jsonAsValue, jsonAsMapPossible, localTypeDescriptor, localCodingHandler);
        RecordSetCodeGenerator.generateTemplateClass(aData, source, className, classReadableName, namesList, hasOptional, false);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        if (beginIndex >= subreferences.size()) {
            return true;
        }
        ISubReference subReference = subreferences.get(beginIndex);
        if (!(subReference instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return true;
        }
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        CompField compField = this.getComponentByName(fieldId);
        if (compField.isOptional()) {
            return false;
        }
        return compField.getType().isPresentAnyvalueEmbeddedField(expression, subreferences, beginIndex + 1);
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        switch (refdType.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Set_Seq_Choice_BaseType realFromType = (TTCN3_Set_Seq_Choice_BaseType)refdType;
                return this.generateConversionTTCNSetSeqToASNSetSeq(aData, realFromType, fromName, forValue, expression);
            }
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Set_Seq_Choice_BaseType realFromType = (ASN1_Set_Seq_Choice_BaseType)refdType;
                return this.generateConversionASNSetSeqToASNSetSeq(aData, realFromType, fromName, forValue, expression);
            }
        }
        expression.expression.append(MessageFormat.format("//FIXME conversion from {0} to {1} is not needed or nor supported yet\n", fromType.getTypename(), this.getTypename()));
        return fromName;
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.defaultAsOptional".equals(property)) {
                        defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
                    }
                }
            });
        }
        strictConstantCheckingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", "warning", null);
        activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                        strictConstantCheckingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", "warning", null);
                    }
                }
            });
        }
    }
}

