/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Enumeration;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumeratedGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.values.Enumerated_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Enumerated_Type
extends ASN1Type
implements ITypeWithComponents {
    private static final String DUPLICATEENUMERATEDREPEATED = "Duplicate ENUMERATE identifier: `{0}'' was declared here again";
    private static final String TTCN3ENUMERATEDVALUEEXPECTED = "Enumerated value was expected";
    private static final String ASN1ENUMERATEDVALUEEXPECTED = "ENUMERATED value was expected";
    public static final String DUPLICATEDENUMERATIONVALUEFIRST = "Value {0} is already assigned to `{1}''";
    public static final String DUPLICATEDENUMERATIONVALUEREPEATED = "Duplicate numeric value {0} for enumeration `{1}''";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for enumerated type";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for enumerated type";
    private final Block mBlock;
    private ASN1_Enumeration enumerations;
    private Map<String, EnumItem> nameMap;
    private Integer firstUnused;

    public ASN1_Enumerated_Type(Block aBlock) {
        this.mBlock = aBlock;
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Enumerated_Type(this.mBlock);
    }

    @Override
    public final IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_ENUMERATED;
    }

    @Override
    public final IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_ENUMERATED;
    }

    @Override
    public final StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("enumerated");
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.enumerations != null) {
            if (this.enumerations.enumItems1 != null) {
                this.enumerations.enumItems1.setMyScope(scope);
            }
            if (this.enumerations.enumItems2 != null) {
                this.enumerations.enumItems2.setMyScope(scope);
            }
        }
    }

    @Override
    public final boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public final boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        return this.isCompatible(timestamp, type, null, null, null);
    }

    @Override
    public final String getTypename() {
        return this.getFullName();
    }

    @Override
    public final String getOutlineIcon() {
        return "enumeration.gif";
    }

    @Override
    public Location getLikelyLocation() {
        return this.location;
    }

    public final boolean hasEnumItemWithName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.nameMap.containsKey(identifier.getName());
    }

    public final EnumItem getEnumItemWithName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.nameMap.get(identifier.getName());
    }

    @Override
    public final void check(CompilationTimeStamp timestamp) {
        List<EnumItem> enumItems;
        Module module;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.myScope && null != (module = this.myScope.getModuleScope()) && module.getSkippedFromSemanticChecking()) {
            return;
        }
        this.isErroneous = false;
        if (null == this.enumerations) {
            this.parseBlockEnumeration();
        }
        if (this.isErroneous || null == this.enumerations) {
            return;
        }
        this.firstUnused = 0;
        this.nameMap = new HashMap<String, EnumItem>();
        HashMap<Integer, EnumItem> valueMap = new HashMap<Integer, EnumItem>();
        if (null != this.enumerations.enumItems1) {
            enumItems = this.enumerations.enumItems1.getItems();
            for (EnumItem enumItem : enumItems) {
                this.checkEnumItem(timestamp, enumItem, false, valueMap);
            }
            while (valueMap.containsKey(this.firstUnused)) {
                Iterator<EnumItem> iterator = this.firstUnused;
                Integer n = this.firstUnused = Integer.valueOf(this.firstUnused + 1);
            }
            for (EnumItem enumItem : enumItems) {
                if (null != enumItem.getValue() && enumItem.isOriginal()) continue;
                Integer_Value tempValue = new Integer_Value(this.firstUnused.longValue());
                tempValue.setLocation(enumItem.getLocation());
                enumItem.setValue(tempValue);
                valueMap.put(this.firstUnused, enumItem);
                while (valueMap.containsKey(this.firstUnused)) {
                    Integer n = this.firstUnused;
                    Integer n2 = this.firstUnused = Integer.valueOf(this.firstUnused + 1);
                }
            }
        }
        if (null != this.enumerations.enumItems2) {
            enumItems = this.enumerations.enumItems2.getItems();
            for (EnumItem enumItem : enumItems) {
                this.checkEnumItem(timestamp, enumItem, true, valueMap);
            }
        }
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    private final void checkEnumItem(CompilationTimeStamp timestamp, EnumItem item, boolean afterEllipsis, Map<Integer, EnumItem> valueMap) {
        Identifier itemID = item.getId();
        String itemIDName = itemID.getName();
        if (this.nameMap.containsKey(itemIDName)) {
            String displayName = itemID.getDisplayName();
            this.nameMap.get(itemIDName).getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", displayName));
            itemID.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEENUMERATEDREPEATED, displayName));
        } else {
            this.nameMap.put(itemIDName, item);
        }
        if (!itemID.getHasValid(Identifier.Identifier_type.ID_TTCN)) {
            itemID.getLocation().reportSemanticWarning(MessageFormat.format("The identifier `{0}'' is not reachable from TTCN-3", itemID.getDisplayName()));
        }
        Value value = item.getValue();
        if (!item.isOriginal()) {
            if (afterEllipsis) {
                while (valueMap.containsKey(this.firstUnused)) {
                    Integer n = this.firstUnused;
                    Integer n2 = this.firstUnused = Integer.valueOf(this.firstUnused + 1);
                }
                valueMap.put(this.firstUnused, item);
                if (null == value || ((Integer_Value)value).getValue() != (long)this.firstUnused.intValue()) {
                    Integer_Value tempValue = new Integer_Value(this.firstUnused.longValue());
                    tempValue.setLocation(item.getLocation());
                    item.setValue(tempValue);
                }
            }
            return;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = value.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
            value.getLocation().reportSemanticError(MessageFormat.format("INTEGER value was expected for enumeration `{0}''", itemID.getDisplayName()));
            value.setIsErroneous(true);
            return;
        }
        Integer_Value temp = (Integer_Value)last;
        if (!temp.isNative()) {
            value.getLocation().reportSemanticError(MessageFormat.format("The numeric value of enumeration `{0}'' ({1}) is too large for being represented in memory", itemID.getDisplayName(), temp.getValueValue()));
            value.setIsErroneous(true);
            return;
        }
        Integer enumValue = temp.intValue();
        if (afterEllipsis) {
            if (enumValue >= this.firstUnused) {
                valueMap.put(enumValue, item);
                while (valueMap.containsKey(this.firstUnused)) {
                    Integer n = this.firstUnused;
                    Integer n3 = this.firstUnused = Integer.valueOf(this.firstUnused + 1);
                }
            } else {
                value.getLocation().reportSemanticError(MessageFormat.format("ENUMERATED values shall be monotonically growing after the ellipsis: the value of `{0}'' must be at least {1} instead of {2}", itemID.getDisplayName(), this.firstUnused, enumValue));
                value.setIsErroneous(true);
            }
        } else if (valueMap.containsKey(enumValue)) {
            Location tempLocation = valueMap.get(enumValue).getLocation();
            tempLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATEDENUMERATIONVALUEFIRST, enumValue, valueMap.get(enumValue).getId().getDisplayName()));
            value.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDENUMERATIONVALUEREPEATED, enumValue, itemID.getDisplayName()));
            this.setIsErroneous(true);
        } else {
            valueMap.put(enumValue, item);
        }
    }

    @Override
    public final IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        Reference reference;
        IValue temp = value;
        if (IValue.Value_type.REFERENCED_VALUE.equals((Object)value.getValuetype()) && (reference = ((Referenced_Value)value).getReference()).getModuleIdentifier() == null && reference.getSubreferences().size() == 1) {
            Identifier identifier = reference.getId();
            temp = new Enumerated_Value(identifier);
            temp.setMyGovernor(this);
            temp.setFullNameParent(this);
            temp.setMyScope(value.getMyScope());
            return temp;
        }
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)temp.getValuetype()) && this.nameMap != null && this.nameMap.containsKey(((Undefined_LowerIdentifier_Value)temp).getIdentifier().getName())) {
            temp = temp.setValuetype(timestamp, IValue.Value_type.ENUMERATED_VALUE);
            temp.setMyGovernor(this);
            temp.setFullNameParent(this);
            temp.setMyScope(value.getMyScope());
            return temp;
        }
        return super.checkThisValueRef(timestamp, value);
    }

    @Override
    public final boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case ENUMERATED_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(value.isAsn() ? ASN1ENUMERATEDVALUEEXPECTED : TTCN3ENUMERATEDVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public final boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        template.setIsErroneous(true);
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
            template.setIsErroneous(true);
        }
        return false;
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkJson(timestamp);
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound && (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET)) {
            this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
        }
        if (this.jsonAttribute.as_number && this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticWarning("Attribute 'text ... as ...' will be ignored, because the enumerated values are encoded as numbers");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            for (int i = 0; i < this.jsonAttribute.enum_texts.size(); ++i) {
                int index;
                Identifier identifier = new Identifier(Identifier.Identifier_type.ID_TTCN, this.jsonAttribute.enum_texts.get((int)i).from, NULL_Location.INSTANCE, true);
                if (!this.hasEnumItemWithName(identifier)) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Invalid JSON default value for enumerated type `{0}'", this.getTypename()));
                    continue;
                }
                EnumItem enumItem = this.getEnumItemWithName(identifier);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue lastValue = enumItem.getValue().getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                this.jsonAttribute.enum_texts.get((int)i).index = index = (int)((Integer_Value)lastValue).getValue();
                for (int j = 0; j < i; ++j) {
                    if (this.jsonAttribute.enum_texts.get((int)j).index != index) continue;
                    this.getLocation().reportSemanticError(MessageFormat.format("Duplicate attribute 'text ... as ...' for enumerated value '{0}'", this.jsonAttribute.enum_texts.get((int)i).from));
                }
            }
        }
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case JSON: 
            case XER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    private void parseBlockEnumeration() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.enumerations = parser.pr_special_Enumerations().enumeration;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.enumerations = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.enumerations != null) {
            if (this.enumerations.enumItems1 != null) {
                this.enumerations.enumItems1.setFullNameParent(this);
                this.enumerations.enumItems1.setMyScope(this.getMyScope());
            }
            if (this.enumerations.enumItems2 != null) {
                this.enumerations.enumItems2.setFullNameParent(this);
                this.enumerations.enumItems2.setMyScope(this.getMyScope());
            }
        }
    }

    @Override
    public final void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i || this.enumerations == null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() <= i + 1) {
            Identifier itemID;
            List<EnumItem> enumItems;
            String referenceName = subreference.getId().getName();
            if (this.enumerations.enumItems1 != null) {
                enumItems = this.enumerations.enumItems1.getItems();
                for (EnumItem item : enumItems) {
                    itemID = item.getId();
                    if (!itemID.getName().startsWith(referenceName)) continue;
                    propCollector.addProposal(itemID, " - named integer", ImageCache.getImage(this.getOutlineIcon()), "named integer");
                }
            }
            if (this.enumerations.enumItems2 != null) {
                enumItems = this.enumerations.enumItems2.getItems();
                for (EnumItem item : enumItems) {
                    itemID = item.getId();
                    if (!itemID.getName().startsWith(referenceName)) continue;
                    propCollector.addProposal(itemID, " - named integer", ImageCache.getImage(this.getOutlineIcon()), "named integer");
                }
            }
        }
    }

    @Override
    public final void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() <= i + 1) {
            Identifier itemID;
            List<EnumItem> enumItems;
            String referenceName = subreference.getId().getName();
            if (this.enumerations.enumItems1 != null) {
                enumItems = this.enumerations.enumItems1.getItems();
                for (EnumItem item : enumItems) {
                    itemID = item.getId();
                    if (!itemID.getName().startsWith(referenceName)) continue;
                    declarationCollector.addDeclaration(itemID.getDisplayName(), itemID.getLocation(), this);
                }
            }
            if (this.enumerations.enumItems2 != null) {
                enumItems = this.enumerations.enumItems2.getItems();
                for (EnumItem item : enumItems) {
                    itemID = item.getId();
                    if (!itemID.getName().startsWith(referenceName)) continue;
                    declarationCollector.addDeclaration(itemID.getDisplayName(), itemID.getLocation(), this);
                }
            }
        }
    }

    @Override
    public final void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.enumerations == null) {
            return;
        }
        if (this.enumerations.enumItems1 != null) {
            for (EnumItem enumItem : this.enumerations.enumItems1.getItems()) {
                if (!enumItem.getLocation().containsOffset(offset)) continue;
                rf.type = this;
                rf.fieldId = enumItem.getId();
                return;
            }
        }
        if (this.enumerations.enumItems2 != null) {
            for (EnumItem enumItem : this.enumerations.enumItems2.getItems()) {
                if (!enumItem.getLocation().containsOffset(offset)) continue;
                rf.type = this;
                rf.fieldId = enumItem.getId();
                return;
            }
        }
    }

    @Override
    public final void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.enumerations != null) {
            if (this.enumerations.enumItems1 != null) {
                this.enumerations.enumItems1.findReferences(referenceFinder, foundIdentifiers);
            }
            if (this.enumerations.enumItems2 != null) {
                this.enumerations.enumItems2.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected final boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.enumerations != null) {
            if (this.enumerations.enumItems1 != null && !this.enumerations.enumItems1.accept(v)) {
                return false;
            }
            if (this.enumerations.enumItems2 != null && !this.enumerations.enumItems2.accept(v)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final Identifier getComponentIdentifierByName(Identifier identifier) {
        EnumItem enumItem = this.getEnumItemWithName(identifier);
        return enumItem == null ? null : enumItem.getId();
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String ownName = this.getGenNameOwn();
        String displayName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, null);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        ArrayList<EnumItem> items = new ArrayList<EnumItem>();
        if (this.enumerations != null) {
            if (this.enumerations.enumItems1 != null) {
                items.addAll(this.enumerations.enumItems1.getItems());
            }
            if (this.enumerations.enumItems2 != null) {
                items.addAll(this.enumerations.enumItems2.getItems());
            }
        }
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        ArrayList<EnumeratedGenerator.Enum_field> fields = new ArrayList<EnumeratedGenerator.Enum_field>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            EnumItem tempItem = (EnumItem)items.get(i);
            Identifier tempId = tempItem.getId();
            Integer_Value tempValue = (Integer_Value)tempItem.getValue().getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
            fields.add(new EnumeratedGenerator.Enum_field(tempId.getName(), tempId.getDisplayName(), tempValue.getValue()));
        }
        EnumeratedGenerator.Enum_Defs e_defs = new EnumeratedGenerator.Enum_Defs(fields, ownName, displayName, this.getGenNameTemplate(aData, source), hasRaw, hasJson);
        EnumeratedGenerator.generateValueClass(aData, source, e_defs, localTypeDescriptor, localCodingHandler);
        EnumeratedGenerator.generateTemplateClass(aData, source, e_defs);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("JSON");
        return "JSON.ENUMERATED_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "ENUMERATED_ber_";
    }
}

