/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.IOException;

public class Appender
implements Appendable {
    private final String delimiter;
    private final Appendable appendable;
    private boolean first = true;

    public Appender(Appendable appendable) {
        this(appendable, "");
    }

    public Appender(Appendable appendable, String delimiter) {
        this.appendable = appendable;
        this.delimiter = delimiter;
    }

    public <T> Appender append(T item) throws IOException {
        return this.internalAppend(item);
    }

    private <T> Appender internalAppend(T item) throws IOException {
        if (this.first) {
            this.first = false;
        } else {
            this.appendable.append(this.delimiter);
        }
        this.appendable.append(String.valueOf(item));
        return this;
    }

    public <T> Appender append(Iterable<T> items) throws IOException {
        if (items == null) {
            return this.internalAppend("null");
        }
        for (T item : items) {
            this.internalAppend(item);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.internalAppend(csq);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            return this.internalAppend("null");
        }
        return this.internalAppend(csq.subSequence(start, end));
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.internalAppend(Character.valueOf(c));
    }

    protected Appendable getAppendable() {
        return this.appendable;
    }
}

