/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.log.merge;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.common.log.merge.LogRecord;
import org.eclipse.titan.common.log.merge.MergeAble;
import org.eclipse.titan.common.log.merge.TimestampFormat;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.StandardCharsets;

public class LogMerger {
    private boolean isErroneous;
    private long dataSize;

    public boolean merge(List<IFile> files, File outputFile, IProgressMonitor monitor) {
        long tickSize;
        PrintWriter writer;
        this.isErroneous = false;
        FileUtils.deleteQuietly(outputFile);
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF8)));
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace("Error while creating writer for " + outputFile.getName(), e);
            return false;
        }
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        List<MergeAble> mergeAbles = this.collectMergeAbles(files, outputFile);
        if (this.dataSize > 1000L) {
            tickSize = this.dataSize / 1000L;
            internalMonitor.beginTask("Merging log files", 1000);
        } else {
            tickSize = 1L;
            internalMonitor.beginTask("Merging log files", (int)this.dataSize);
        }
        boolean dataProcessed = true;
        long nofProcessedBytes = 0L;
        while (dataProcessed && !internalMonitor.isCanceled()) {
            MergeAble earliestMergeable = this.getEarliestMergeAble(mergeAbles);
            dataProcessed = false;
            if (earliestMergeable == null) continue;
            String text = this.appendRecord(writer, earliestMergeable);
            if ((nofProcessedBytes += (long)text.length()) > tickSize) {
                internalMonitor.worked((int)(nofProcessedBytes / tickSize));
                nofProcessedBytes %= tickSize;
            }
            earliestMergeable.next();
            dataProcessed = true;
        }
        IOUtils.closeQuietly(mergeAbles.toArray(new Closeable[0]));
        writer.close();
        internalMonitor.done();
        for (int i = 0; i < mergeAbles.size() && !this.isErroneous; ++i) {
            this.isErroneous = mergeAbles.get(i).isErroneous();
        }
        return !this.isErroneous;
    }

    private String appendRecord(PrintWriter writer, MergeAble earliestMergeable) {
        LogRecord record = earliestMergeable.getActualRecord();
        writer.print(record.getTimestamp());
        if (earliestMergeable.getComponentID() != null) {
            writer.print(' ');
            writer.print(earliestMergeable.getComponentID());
        }
        String text = record.getText();
        writer.print(text);
        if (text.charAt(text.length() - 1) != '\n') {
            writer.print('\n');
        }
        return text;
    }

    private List<MergeAble> collectMergeAbles(List<IFile> files, File outputFile) {
        ArrayList<MergeAble> mergeAbles = new ArrayList<MergeAble>(files.size());
        TimestampFormat commonFormat = null;
        Path outputPath = new Path(outputFile.getAbsolutePath());
        for (IFile file : files) {
            BufferedReader reader;
            if (outputPath.equals((Object)file.getLocation())) continue;
            try {
                file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                reader = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF8));
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace("Error while refreshing and opening " + file.getLocationURI() + ", skipping", e);
                this.isErroneous = true;
                continue;
            }
            MergeAble mergeAble = new MergeAble(file, reader, true);
            if (mergeAble.hasNext()) {
                if (commonFormat == null) {
                    commonFormat = mergeAble.getTimestampFormat();
                    mergeAbles.add(mergeAble);
                    this.dataSize += file.getLocation().toFile().length();
                    continue;
                }
                if (commonFormat == mergeAble.getTimestampFormat()) {
                    mergeAbles.add(mergeAble);
                    this.dataSize += file.getLocation().toFile().length();
                    continue;
                }
                ErrorReporter.logError("The format of the timestamp in the file '" + mergeAble.getFile().getLocation().toOSString() + "' is " + mergeAble.getTimestampFormat().getFormatName() + " which does not match the format of the common timestamp " + commonFormat.getFormatName());
                mergeAble.close();
                this.isErroneous = true;
                continue;
            }
            mergeAble.close();
        }
        return mergeAbles;
    }

    private MergeAble getEarliestMergeAble(List<MergeAble> mergeAbles) {
        String smallestTimestamp = null;
        MergeAble smallestMergeable = null;
        for (MergeAble mergeAble : mergeAbles) {
            if (!mergeAble.hasNext()) continue;
            if (smallestTimestamp == null) {
                smallestTimestamp = mergeAble.getActualRecord().getTimestamp();
                smallestMergeable = mergeAble;
                continue;
            }
            if (smallestTimestamp.compareTo(mergeAble.getActualRecord().getTimestamp()) <= 0) continue;
            smallestTimestamp = mergeAble.getActualRecord().getTimestamp();
            smallestMergeable = mergeAble;
        }
        return smallestMergeable;
    }
}

