/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SignatureHelpRequestor;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpContext;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;

public class SignatureHelpUtils {
    private SignatureHelpUtils() {
    }

    public static SignatureHelp getSignatureHelpFromASTNode(ICompilationUnit unit, int triggerOffset, IProgressMonitor monitor) {
        ASTNode targetNode;
        SignatureHelp help;
        SignatureHelpContext context;
        block15: {
            context = new SignatureHelpContext();
            context.resolve(triggerOffset, unit, monitor);
            help = new SignatureHelp();
            targetNode = context.targetNode();
            if (context.targetNode() != null) break block15;
            return null;
        }
        try {
            CompletionProposal proposal;
            SignatureInformation signatureInformation;
            int i;
            List infos;
            int[] lastRange;
            if (context.arguments() != null && context.arguments().isEmpty()) {
                int nodeEnd = targetNode.getStartPosition() + targetNode.getLength();
                if (unit.getBuffer().getChar(nodeEnd - 1) == ')' && nodeEnd <= triggerOffset) {
                    return help;
                }
            } else if (context.argumentRanges() != null && context.argumentRanges().size() > 0 && (lastRange = context.argumentRanges().get(context.argumentRanges().size() - 1))[1] < triggerOffset) {
                return help;
            }
            SignatureHelpRequestor collector = new SignatureHelpRequestor(unit, context.methodName());
            unit.codeComplete(context.completionOffset(), (CompletionRequestor)collector, monitor);
            help = collector.getSignatureHelp(monitor);
            if (context.secondaryCompletionOffset() > -1) {
                unit.codeComplete(context.secondaryCompletionOffset(), (CompletionRequestor)collector, monitor);
                help = collector.getSignatureHelp(monitor);
            }
            if (help.getSignatures().isEmpty() && context.targetNode() instanceof ClassInstanceCreation) {
                SignatureHelpUtils.fix2097(help, context.targetNode(), collector, context.completionOffset());
            }
            if ((infos = help.getSignatures()).isEmpty()) {
                return help;
            }
            if (CompletionHandler.selectedProposal != null) {
                i = 0;
                while (i < infos.size()) {
                    int activeParameter;
                    signatureInformation = (SignatureInformation)infos.get(i);
                    proposal = collector.getInfoProposals().get(signatureInformation);
                    if (Arrays.equals(proposal.getSignature(), CompletionHandler.selectedProposal.getSignature()) && (activeParameter = SignatureHelpUtils.getActiveParameter(triggerOffset, proposal, context)) >= 0) {
                        help.setActiveSignature(Integer.valueOf(i));
                        help.setActiveParameter(Integer.valueOf(activeParameter));
                        return help;
                    }
                    ++i;
                }
            }
            CompletionHandler.selectedProposal = null;
            i = 0;
            while (i < infos.size()) {
                signatureInformation = (SignatureInformation)infos.get(i);
                proposal = collector.getInfoProposals().get(signatureInformation);
                boolean isMatched = SignatureHelpUtils.isMatched(proposal, signatureInformation, context);
                if (isMatched) {
                    help.setActiveSignature(Integer.valueOf(i));
                    int activeParameter = SignatureHelpUtils.getActiveParameter(triggerOffset, proposal, context);
                    help.setActiveParameter(Integer.valueOf(activeParameter));
                    break;
                }
                ++i;
            }
            return help;
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e);
            return null;
        }
    }

    private static boolean isMatched(CompletionProposal proposal, SignatureInformation information, SignatureHelpContext context) {
        boolean isVarargs = Flags.isVarargs((int)proposal.getFlags());
        if (information.getParameters().size() < context.argumentRanges().size() && !isVarargs) {
            return false;
        }
        String[] parameterTypes = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
        if (context.arguments().isEmpty()) {
            return true;
        }
        int paramNum = 0;
        if (context.parameterTypes() != null) {
            paramNum = context.parameterTypes().length;
        } else if (context.parameterTypesFromBinding() != null) {
            paramNum = context.parameterTypesFromBinding().length;
        }
        int matchedNumber = 0;
        int startIndex = 0;
        int i = 0;
        while (i < context.arguments().size() && i < paramNum) {
            int j = startIndex;
            while (j < context.argumentRanges().size()) {
                int startPosition = context.arguments().get(i).getStartPosition();
                if (startPosition >= context.argumentRanges().get(j)[0] && startPosition <= context.argumentRanges().get(j)[1]) {
                    startIndex = j + 1;
                    break;
                }
                ++j;
            }
            if (j >= parameterTypes.length) break;
            String proposedTypeSimpleName = SignatureHelpUtils.getSimpleTypeName(parameterTypes[j]);
            if (context.parameterTypes() != null && Objects.equals(proposedTypeSimpleName, context.parameterTypes()[i])) {
                ++matchedNumber;
            } else if (context.parameterTypesFromBinding() != null && Objects.equals(proposedTypeSimpleName, context.parameterTypesFromBinding()[i])) {
                ++matchedNumber;
            }
            ++i;
        }
        return matchedNumber == Math.min(paramNum, context.arguments().size());
    }

    private static int getActiveParameter(int triggerOffset, CompletionProposal proposal, SignatureHelpContext context) {
        int parameterCount = Signature.getParameterCount((char[])proposal.getSignature());
        if (triggerOffset >= context.completionOffset()) {
            boolean isVarargs = Flags.isVarargs((int)proposal.getFlags());
            if (parameterCount > 0 && context.argumentRanges().isEmpty()) {
                return 0;
            }
            int i = 0;
            while (i < context.argumentRanges().size()) {
                int[] range = context.argumentRanges().get(i);
                if (range[0] <= triggerOffset && range[1] >= triggerOffset) {
                    if (i >= parameterCount && isVarargs) {
                        return parameterCount - 1;
                    }
                    return i;
                }
                ++i;
            }
        }
        return parameterCount;
    }

    public static String getSimpleTypeName(String signature) {
        String res = Signature.getSimpleName((String)Signature.toString((String)signature));
        return res.replaceAll("<.*>", "").replace(";", "");
    }

    public static void fix2097(SignatureHelp help, ASTNode node, SignatureHelpRequestor collector, int pos) throws JavaModelException {
        IMethodBinding binding = ((ClassInstanceCreation)node).resolveConstructorBinding();
        if (binding == null) {
            return;
        }
        ITypeBinding typeBinding = binding.getDeclaringClass();
        if (typeBinding.isAnonymous()) {
            return;
        }
        if (binding.isDefaultConstructor()) {
            ConstructorProposal proposal = new ConstructorProposal(6, pos);
            proposal.setName(binding.getName().toCharArray());
            String signature = "()V";
            proposal.setSignature(signature.toCharArray());
            proposal.setParameterNames(new char[0][]);
            char[] result = Signature.createTypeSignature((String)typeBinding.getQualifiedName(), (boolean)false).toCharArray();
            proposal.setDeclarationSignature(result);
            SignatureInformation info = collector.toSignatureInformation((CompletionProposal)proposal);
            collector.getInfoProposals().put(info, (CompletionProposal)proposal);
            help.getSignatures().add(info);
            return;
        }
        IType type = (IType)typeBinding.getJavaElement();
        if (type == null) {
            return;
        }
        IMethod[] methods = type.getMethods();
        ArrayList<SignatureInformation> infos = new ArrayList<SignatureInformation>();
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            try {
                if (method.isConstructor()) {
                    ConstructorProposal proposal = new ConstructorProposal(6, pos);
                    proposal.setName(method.getElementName().toCharArray());
                    String signature = method.getSignature().replace("/", ".");
                    proposal.setSignature(signature.toCharArray());
                    char[][] parameterNames = new char[method.getParameterNames().length][];
                    int i = 0;
                    while (i < method.getParameterNames().length) {
                        parameterNames[i] = method.getParameterNames()[i].toCharArray();
                        ++i;
                    }
                    proposal.setParameterNames(parameterNames);
                    char[] result = Signature.createTypeSignature((String)typeBinding.getQualifiedName(), (boolean)false).toCharArray();
                    proposal.setDeclarationSignature(result);
                    SignatureInformation info = collector.toSignatureInformation((CompletionProposal)proposal);
                    infos.add(info);
                    collector.getInfoProposals().put(info, (CompletionProposal)proposal);
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            ++n2;
        }
        infos.sort((a, b) -> a.getParameters().size() - b.getParameters().size());
        help.getSignatures().addAll(infos);
    }

    static class ConstructorProposal
    extends InternalCompletionProposal {
        public ConstructorProposal(int kind, int completionLocation) {
            super(kind, completionLocation);
            this.setIsContructor(true);
        }
    }
}

