/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.maven.DefaultMaven;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.ProblemCollector;
import org.apache.maven.building.ProblemCollectorFactory;
import org.apache.maven.building.Source;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingException;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;

public interface IMavenToolbox {
    public static final Supplier<CoreException> ERROR_NO_SESSION = () -> new CoreException(Status.error((String)Messages.MavenToolbox_sessionrequired));
    public static final Supplier<CoreException> ERROR_NO_LOOKUP = () -> new CoreException(Status.error((String)Messages.MavenToolbox_lookuprequired));

    public Optional<IComponentLookup> getComponentLookup();

    public Optional<MavenSession> getSession();

    default public MavenExecutionResult readMavenProject(File pomFile, ProjectBuildingRequest configuration) throws CoreException {
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        IComponentLookup componentLookup = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP);
        try {
            configuration.setValidationLevel(0);
            ProjectBuildingResult projectBuildingResult = componentLookup.lookup(ProjectBuilder.class).build(pomFile, configuration);
            MavenProject project = projectBuildingResult.getProject();
            IMavenToolbox.clearProjectBuildingRequest(project);
            result.setProject(project);
            result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
        }
        catch (ProjectBuildingException ex) {
            if (ex.getResults() != null && ex.getResults().size() == 1) {
                ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)ex.getResults().get(0);
                MavenProject project = projectBuildingResult.getProject();
                IMavenToolbox.clearProjectBuildingRequest(project);
                result.setProject(project);
                result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
            }
            result.addException((Throwable)ex);
        }
        catch (RuntimeException e) {
            result.addException((Throwable)e);
        }
        return result;
    }

    default public Map<File, MavenExecutionResult> readMavenProjects(Collection<File> pomFiles, ProjectBuildingRequest configuration) throws CoreException {
        LinkedHashMap<File, MavenExecutionResult> result;
        ArrayList projectBuildingResults;
        block4: {
            IComponentLookup componentLookup = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP);
            projectBuildingResults = new ArrayList();
            result = new LinkedHashMap<File, MavenExecutionResult>(pomFiles.size(), 1.0f);
            try {
                configuration.setValidationLevel(0);
                projectBuildingResults.addAll(componentLookup.lookup(ProjectBuilder.class).build(new ArrayList<File>(pomFiles), false, configuration));
            }
            catch (ProjectBuildingException ex) {
                if (ex.getResults() == null) break block4;
                projectBuildingResults.addAll(ex.getResults());
            }
        }
        for (ProjectBuildingResult projectBuildingResult : projectBuildingResults) {
            DefaultMavenExecutionResult mavenExecutionResult = new DefaultMavenExecutionResult();
            MavenProject project = projectBuildingResult.getProject();
            IMavenToolbox.clearProjectBuildingRequest(project);
            mavenExecutionResult.setProject(project);
            mavenExecutionResult.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
            if (!projectBuildingResult.getProblems().isEmpty()) {
                mavenExecutionResult.addException((Throwable)new ProjectBuildingException(Collections.singletonList(projectBuildingResult)));
            }
            result.put(projectBuildingResult.getPomFile(), (MavenExecutionResult)mavenExecutionResult);
        }
        return result;
    }

    private static void clearProjectBuildingRequest(MavenProject project) {
        IMavenToolbox.clearProjectBuildingRequest(project, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static void clearProjectBuildingRequest(MavenProject project, Set<MavenProject> seen) {
        if (project != null && seen.add(project)) {
            project.setProjectBuildingRequest(null);
            IMavenToolbox.clearProjectBuildingRequest(project.getParent(), seen);
        }
    }

    default public MavenExecutionPlan calculateExecutionPlan(Collection<String> tasks, boolean setup) throws CoreException {
        MavenSession session = this.getSession().orElseThrow(ERROR_NO_SESSION);
        IComponentLookup componentLookup = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP);
        LifecycleExecutor lifecycleExecutor = componentLookup.lookup(LifecycleExecutor.class);
        try {
            return lifecycleExecutor.calculateExecutionPlan(session, setup, (String[])tasks.toArray(String[]::new));
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_calc_build_plan, (Object)e.getMessage()), (Throwable)e));
        }
    }

    default public MavenProject getStandaloneProject() throws CoreException {
        MavenSession session = this.getSession().orElseThrow(ERROR_NO_SESSION);
        IComponentLookup componentLookup = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP);
        MavenExecutionRequest request = session.getRequest();
        ProjectBuilder projectBuilder = componentLookup.lookup(ProjectBuilder.class);
        request.getProjectBuildingRequest().setRepositorySession(session.getRepositorySession());
        try {
            MavenProject project = projectBuilder.build((ModelSource)new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml")), request.getProjectBuildingRequest()).getProject();
            project.setExecutionRoot(true);
            return project;
        }
        catch (ProjectBuildingException ex) {
            throw new CoreException(Status.error((String)"Can't build standalone project!", (Throwable)ex));
        }
    }

    default public Optional<File> locatePom(File baseDir) {
        if (baseDir == null || !baseDir.isDirectory()) {
            return Optional.empty();
        }
        File file = new File(baseDir, "pom.xml");
        if (file.isFile()) {
            return Optional.of(file);
        }
        return this.getComponentLookup().map(componentLookup -> {
            try {
                ModelProcessor modelProcessor = componentLookup.lookup(ModelProcessor.class);
                File pom = modelProcessor.locatePom(baseDir);
                if (pom != null && pom.isFile()) {
                    return pom;
                }
            }
            catch (Exception ex) {
                MavenPluginActivator.getDefault().getLog().warn("Error while locating pom for basedir " + String.valueOf(baseDir), (Throwable)ex);
            }
            return null;
        });
    }

    default public Model readModel(InputStream in) throws CoreException {
        IComponentLookup componentLookup = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP);
        try {
            return componentLookup.lookup(ModelReader.class).read(in, null);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_pom, (Throwable)e));
        }
    }

    default public List<Problem> validateToolchains(String toolchains) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (toolchains != null) {
            File toolchainsFile = new File(toolchains);
            ProblemCollector problemsFactory = ProblemCollectorFactory.newInstance(null);
            if (toolchainsFile.canRead()) {
                DefaultToolchainsBuildingRequest request = new DefaultToolchainsBuildingRequest();
                request.setUserToolchainsSource((Source)new FileSource(toolchainsFile));
                try {
                    ToolchainsBuildingResult result = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP).lookup(ToolchainsBuilder.class).build((ToolchainsBuildingRequest)request);
                    problems.addAll(result.getProblems());
                }
                catch (ToolchainsBuildingException ex) {
                    problems.addAll(ex.getProblems());
                }
                catch (CoreException ex) {
                    problemsFactory.add(Problem.Severity.FATAL, toolchains, -1, -1, (Exception)((Object)ex));
                    problems.addAll(problemsFactory.getProblems());
                }
            } else {
                problemsFactory.add(Problem.Severity.ERROR, NLS.bind((String)Messages.MavenImpl_error_read_toolchains, (Object)toolchains), -1, -1, null);
                problems.addAll(problemsFactory.getProblems());
            }
        }
        return problems;
    }

    default public void writeModel(Model model, OutputStream out) throws CoreException {
        IComponentLookup componentLookup = this.getComponentLookup().orElseThrow(ERROR_NO_LOOKUP);
        try {
            componentLookup.lookup(ModelWriter.class).write(out, null, model);
        }
        catch (IOException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_write_pom, (Throwable)ex));
        }
    }

    public static IMavenToolbox of(final IMavenExecutionContext executionContext) {
        return new IMavenToolbox(){

            @Override
            public Optional<IComponentLookup> getComponentLookup() {
                return Optional.of(executionContext.getComponentLookup());
            }

            @Override
            public Optional<MavenSession> getSession() {
                return Optional.of(executionContext.getSession());
            }
        };
    }

    public static IMavenToolbox of(IComponentLookup componentLookup) {
        return IMavenToolbox.of(componentLookup, null);
    }

    public static IMavenToolbox of(IComponentLookup componentLookup, MavenSession mavenSession) {
        final Optional<IComponentLookup> optionalLookup = Optional.ofNullable(componentLookup);
        final Optional<MavenSession> optioanlSession = Optional.ofNullable(mavenSession);
        return new IMavenToolbox(){

            @Override
            public Optional<MavenSession> getSession() {
                return optioanlSession;
            }

            @Override
            public Optional<IComponentLookup> getComponentLookup() {
                return optionalLookup;
            }
        };
    }
}

