/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;

public class DependencyUtil {
    public static final String CLASSIFIER_JAVADOC = "javadoc";
    public static final String CLASSIFIER_SOURCES = "sources";

    public static File getSources(String groupId, String artifactId, String version) throws FileNotFoundException, CoreException {
        return DependencyUtil.getArtifact(groupId, artifactId, version, CLASSIFIER_SOURCES);
    }

    public static File getJavadoc(String groupId, String artifactId, String version) throws FileNotFoundException, CoreException {
        return DependencyUtil.getArtifact(groupId, artifactId, version, CLASSIFIER_JAVADOC);
    }

    public static File getArtifact(String groupId, String artifactId, String version, String classifier) throws FileNotFoundException, CoreException {
        ArtifactKey key = new ArtifactKey(groupId, artifactId, version, classifier);
        File archive = DependencyUtil.getLocalArtifactFile(key);
        if (archive == null) {
            Artifact artifact = MavenPlugin.getMaven().resolve(key.groupId(), key.artifactId(), key.version(), "jar", key.classifier(), null, (IProgressMonitor)new NullProgressMonitor());
            if (artifact == null) {
                throw new FileNotFoundException("Unable to find " + String.valueOf(key));
            }
            archive = DependencyUtil.getLocalArtifactFile(key);
        }
        return archive;
    }

    private static File getLocalArtifactFile(ArtifactKey a) {
        IMaven maven = MavenPlugin.getMaven();
        try {
            ArtifactRepository localRepository = maven.getLocalRepository();
            String relPath = maven.getArtifactPath(localRepository, a.groupId(), a.artifactId(), a.version(), "jar", a.classifier());
            File file = new File(localRepository.getBasedir(), relPath).getCanonicalFile();
            if (file.canRead() && file.isFile()) {
                return file;
            }
        }
        catch (IOException | CoreException throwable) {
            // empty catch block
        }
        return null;
    }
}

