/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathAttributeDelta;
import org.eclipse.jdt.core.IClasspathEntry;

public class ClasspathAttributeDelta
implements IClasspathAttributeDelta {
    private static final String NO_VALUE = "";
    private final int kind;
    private final String attributeName;
    private final String attributeValue;

    private ClasspathAttributeDelta(int kind, String attributeName, String attributeValue) {
        Assert.isTrue(kind == 1 || kind == 2 || kind == 4, "Unexpected delta kind: " + kind);
        this.kind = kind;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String getAttributeValue() {
        return this.attributeValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("attribute name=");
        buffer.append(this.getAttributeName());
        int deltaKind = this.getKind();
        if (deltaKind != 2) {
            buffer.append(", value=");
            buffer.append(this.getAttributeValue());
        }
        buffer.append("[");
        switch (deltaKind) {
            case 1: {
                buffer.append('+');
                break;
            }
            case 2: {
                buffer.append('-');
                break;
            }
            case 4: {
                buffer.append('*');
                break;
            }
            default: {
                buffer.append('?');
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    static List<IClasspathAttributeDelta> getAttributeDeltas(IClasspathEntry oldClasspathEntry, IClasspathEntry newClasspathEntry) {
        ClasspathAttributeDelta attributeDelta;
        String value;
        String name;
        Map<String, String> oldAttributes = ClasspathAttributeDelta.getAttributes(oldClasspathEntry);
        Map<String, String> newAttributes = ClasspathAttributeDelta.getAttributes(newClasspathEntry);
        if (oldAttributes.isEmpty() && newAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> addedAttributes = new LinkedHashSet<String>();
        LinkedHashSet<String> removedAttributes = new LinkedHashSet<String>();
        LinkedHashSet<String> changedAttributes = new LinkedHashSet<String>();
        for (Map.Entry<String, String> newAttribute : newAttributes.entrySet()) {
            name = newAttribute.getKey();
            if (oldAttributes.containsKey(name)) continue;
            addedAttributes.add(name);
        }
        for (Map.Entry<String, String> oldAttribute : oldAttributes.entrySet()) {
            name = oldAttribute.getKey();
            String oldValue = oldAttribute.getValue();
            String newValue = newAttributes.get(name);
            if (newValue != null) {
                if (Objects.equals(oldValue, newValue)) continue;
                changedAttributes.add(name);
                continue;
            }
            removedAttributes.add(name);
        }
        ArrayList<IClasspathAttributeDelta> attributeDeltas = new ArrayList<IClasspathAttributeDelta>();
        for (String name2 : addedAttributes) {
            value = newAttributes.get(name2);
            attributeDelta = new ClasspathAttributeDelta(1, name2, value);
            attributeDeltas.add(attributeDelta);
        }
        for (String name2 : removedAttributes) {
            String noValue = NO_VALUE;
            attributeDelta = new ClasspathAttributeDelta(2, name2, noValue);
            attributeDeltas.add(attributeDelta);
        }
        for (String name2 : changedAttributes) {
            value = newAttributes.get(name2);
            attributeDelta = new ClasspathAttributeDelta(4, name2, value);
            attributeDeltas.add(attributeDelta);
        }
        return attributeDeltas;
    }

    private static Map<String, String> getAttributes(IClasspathEntry classpathEntry) {
        IClasspathAttribute[] extraAttributes = classpathEntry.getExtraAttributes();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        IClasspathAttribute[] iClasspathAttributeArray = extraAttributes;
        int n = extraAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            String name = attribute.getName();
            String value = attribute.getValue();
            if (value == null) {
                value = NO_VALUE;
            }
            attributes.put(name, value);
            ++n2;
        }
        return attributes;
    }
}

