"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_navigator_lib_electron-browser_electron-navigator-module_js"],{

/***/ "../../node_modules/@theia/core/lib/common/file-uri.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/common/file-uri.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileUri = void 0;
const vscode_uri_1 = __webpack_require__(/*! vscode-uri */ "../../node_modules/vscode-uri/lib/esm/index.js");
const uri_1 = __webpack_require__(/*! ./uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const os_1 = __webpack_require__(/*! ./os */ "../../node_modules/@theia/core/lib/common/os.js");
var FileUri;
(function (FileUri) {
    const windowsDriveRegex = /^([^:/?#]+?):$/;
    /**
     * Creates a new file URI from the filesystem path argument.
     * @param fsPath the filesystem path.
     */
    function create(fsPath_) {
        return new uri_1.default(vscode_uri_1.URI.file(fsPath_));
    }
    FileUri.create = create;
    /**
     * Returns with the platform specific FS path that is represented by the URI argument.
     *
     * @param uri the file URI that has to be resolved to a platform specific FS path.
     */
    function fsPath(uri) {
        if (typeof uri === 'string') {
            return fsPath(new uri_1.default(uri));
        }
        else {
            /*
             * A uri for the root of a Windows drive, eg file:\\\c%3A, is converted to c:
             * by the Uri class.  However file:\\\c%3A is unambiguously a uri to the root of
             * the drive and c: is interpreted as the default directory for the c drive
             * (by, for example, the readdir function in the fs-extra module).
             * A backslash must be appended to the drive, eg c:\, to ensure the correct path.
             */
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const fsPathFromVsCodeUri = uri.codeUri.fsPath;
            if (os_1.isWindows) {
                const isWindowsDriveRoot = windowsDriveRegex.exec(fsPathFromVsCodeUri);
                if (isWindowsDriveRoot) {
                    return fsPathFromVsCodeUri + '\\';
                }
            }
            return fsPathFromVsCodeUri;
        }
    }
    FileUri.fsPath = fsPath;
})(FileUri || (exports.FileUri = FileUri = {}));


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-common/electron-api.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-common/electron-api.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CHANNEL_IPC_CONNECTION = exports.CHANNEL_KEYBOARD_LAYOUT_CHANGED = exports.CHANNEL_WRITE_CLIPBOARD = exports.CHANNEL_READ_CLIPBOARD = exports.CHANNEL_APP_STATE_CHANGED = exports.CHANNEL_RESTART = exports.CHANNEL_REQUEST_RELOAD = exports.CHANNEL_REQUEST_CLOSE = exports.CHANNEL_REQUEST_SECONDARY_CLOSE = exports.CHANNEL_TOGGLE_FULL_SCREEN = exports.CHANNEL_IS_FULL_SCREEN = exports.CHANNEL_IS_FULL_SCREENABLE = exports.CHANNEL_SET_ZOOM_LEVEL = exports.CHANNEL_GET_ZOOM_LEVEL = exports.CHANNEL_TOGGLE_DEVTOOLS = exports.CHANNEL_ON_WINDOW_EVENT = exports.CHANNEL_UNMAXIMIZE = exports.CHANNEL_OPEN_URL = exports.CHANNEL_ABOUT_TO_CLOSE = exports.CHANNEL_IS_MAXIMIZED = exports.CHANNEL_MAXIMIZE = exports.CHANNEL_MINIMIZE = exports.CHANNEL_CLOSE = exports.CHANNEL_SET_THEME = exports.CHANNEL_SET_BACKGROUND_COLOR = exports.CHANNEL_SET_TITLE_STYLE = exports.CHANNEL_GET_TITLE_STYLE_AT_STARTUP = exports.CHANNEL_ATTACH_SECURITY_TOKEN = exports.CHANNEL_OPEN_WITH_SYSTEM_APP = exports.CHANNEL_SHOW_ITEM_IN_FOLDER = exports.CHANNEL_SHOW_SAVE = exports.CHANNEL_SHOW_OPEN = exports.CHANNEL_FOCUS_WINDOW = exports.CHANNEL_GET_SECURITY_TOKEN = exports.CHANNEL_CLOSE_POPUP = exports.CHANNEL_ON_CLOSE_POPUP = exports.CHANNEL_OPEN_POPUP = exports.CHANNEL_INVOKE_MENU = exports.CHANNEL_SET_MENU_BAR_VISIBLE = exports.CHANNEL_SET_MENU = exports.CHANNEL_WC_METADATA = void 0;
exports.CHANNEL_WC_METADATA = 'WebContentMetadata';
exports.CHANNEL_SET_MENU = 'SetMenu';
exports.CHANNEL_SET_MENU_BAR_VISIBLE = 'SetMenuBarVisible';
exports.CHANNEL_INVOKE_MENU = 'InvokeMenu';
exports.CHANNEL_OPEN_POPUP = 'OpenPopup';
exports.CHANNEL_ON_CLOSE_POPUP = 'OnClosePopup';
exports.CHANNEL_CLOSE_POPUP = 'ClosePopup';
exports.CHANNEL_GET_SECURITY_TOKEN = 'GetSecurityToken';
exports.CHANNEL_FOCUS_WINDOW = 'FocusWindow';
exports.CHANNEL_SHOW_OPEN = 'ShowOpenDialog';
exports.CHANNEL_SHOW_SAVE = 'ShowSaveDialog';
exports.CHANNEL_SHOW_ITEM_IN_FOLDER = 'ShowItemInFolder';
exports.CHANNEL_OPEN_WITH_SYSTEM_APP = 'OpenWithSystemApp';
exports.CHANNEL_ATTACH_SECURITY_TOKEN = 'AttachSecurityToken';
exports.CHANNEL_GET_TITLE_STYLE_AT_STARTUP = 'GetTitleStyleAtStartup';
exports.CHANNEL_SET_TITLE_STYLE = 'SetTitleStyle';
exports.CHANNEL_SET_BACKGROUND_COLOR = 'SetBackgroundColor';
exports.CHANNEL_SET_THEME = 'SetTheme';
exports.CHANNEL_CLOSE = 'Close';
exports.CHANNEL_MINIMIZE = 'Minimize';
exports.CHANNEL_MAXIMIZE = 'Maximize';
exports.CHANNEL_IS_MAXIMIZED = 'IsMaximized';
exports.CHANNEL_ABOUT_TO_CLOSE = 'AboutToClose';
exports.CHANNEL_OPEN_URL = 'OpenUrl';
exports.CHANNEL_UNMAXIMIZE = 'UnMaximize';
exports.CHANNEL_ON_WINDOW_EVENT = 'OnWindowEvent';
exports.CHANNEL_TOGGLE_DEVTOOLS = 'ToggleDevtools';
exports.CHANNEL_GET_ZOOM_LEVEL = 'GetZoomLevel';
exports.CHANNEL_SET_ZOOM_LEVEL = 'SetZoomLevel';
exports.CHANNEL_IS_FULL_SCREENABLE = 'IsFullScreenable';
exports.CHANNEL_IS_FULL_SCREEN = 'IsFullScreen';
exports.CHANNEL_TOGGLE_FULL_SCREEN = 'ToggleFullScreen';
exports.CHANNEL_REQUEST_SECONDARY_CLOSE = 'RequestSecondaryClose';
exports.CHANNEL_REQUEST_CLOSE = 'RequestClose';
exports.CHANNEL_REQUEST_RELOAD = 'RequestReload';
exports.CHANNEL_RESTART = 'Restart';
exports.CHANNEL_APP_STATE_CHANGED = 'ApplicationStateChanged';
exports.CHANNEL_READ_CLIPBOARD = 'ReadClipboard';
exports.CHANNEL_WRITE_CLIPBOARD = 'WriteClipboard';
exports.CHANNEL_KEYBOARD_LAYOUT_CHANGED = 'KeyboardLayoutChanged';
exports.CHANNEL_IPC_CONNECTION = 'IpcConnection';


/***/ }),

/***/ "../../node_modules/@theia/navigator/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/navigator/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./navigator-model */ "../../node_modules/@theia/navigator/lib/browser/navigator-model.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./navigator-widget */ "../../node_modules/@theia/navigator/lib/browser/navigator-widget.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./navigator-widget-factory */ "../../node_modules/@theia/navigator/lib/browser/navigator-widget-factory.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./navigator-decorator-service */ "../../node_modules/@theia/navigator/lib/browser/navigator-decorator-service.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/navigator/lib/browser/navigator-decorator-service.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/navigator/lib/browser/navigator-decorator-service.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NavigatorDecoratorService = exports.NavigatorTreeDecorator = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const contribution_provider_1 = __webpack_require__(/*! @theia/core/lib/common/contribution-provider */ "../../node_modules/@theia/core/lib/common/contribution-provider.js");
const tree_decorator_1 = __webpack_require__(/*! @theia/core/lib/browser/tree/tree-decorator */ "../../node_modules/@theia/core/lib/browser/tree/tree-decorator.js");
/**
 * Symbol for all decorators that would like to contribute into the navigator.
 */
exports.NavigatorTreeDecorator = Symbol('NavigatorTreeDecorator');
/**
 * Decorator service for the navigator.
 */
let NavigatorDecoratorService = class NavigatorDecoratorService extends tree_decorator_1.AbstractTreeDecoratorService {
    constructor(contributions) {
        super(contributions.getContributions());
        this.contributions = contributions;
    }
};
exports.NavigatorDecoratorService = NavigatorDecoratorService;
exports.NavigatorDecoratorService = NavigatorDecoratorService = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(contribution_provider_1.ContributionProvider)),
    tslib_1.__param(0, (0, inversify_1.named)(exports.NavigatorTreeDecorator)),
    tslib_1.__metadata("design:paramtypes", [Object])
], NavigatorDecoratorService);


/***/ }),

/***/ "../../node_modules/@theia/navigator/lib/electron-browser/electron-navigator-menu-contribution.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/navigator/lib/electron-browser/electron-navigator-menu-contribution.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronNavigatorMenuContribution = exports.OPEN_WITH_SYSTEM_APP = exports.OPEN_CONTAINING_FOLDER = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const widget_manager_1 = __webpack_require__(/*! @theia/core/lib/browser/widget-manager */ "../../node_modules/@theia/core/lib/browser/widget-manager.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const file_uri_1 = __webpack_require__(/*! @theia/core/lib/common/file-uri */ "../../node_modules/@theia/core/lib/common/file-uri.js");
const os_1 = __webpack_require__(/*! @theia/core/lib/common/os */ "../../node_modules/@theia/core/lib/common/os.js");
const uri_command_handler_1 = __webpack_require__(/*! @theia/core/lib/common/uri-command-handler */ "../../node_modules/@theia/core/lib/common/uri-command-handler.js");
__webpack_require__(/*! @theia/core/lib/electron-common/electron-api */ "../../node_modules/@theia/core/lib/electron-common/electron-api.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_2 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const browser_3 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const browser_4 = __webpack_require__(/*! ../browser */ "../../node_modules/@theia/navigator/lib/browser/index.js");
const navigator_contribution_1 = __webpack_require__(/*! ../browser/navigator-contribution */ "../../node_modules/@theia/navigator/lib/browser/navigator-contribution.js");
exports.OPEN_CONTAINING_FOLDER = core_1.Command.toDefaultLocalizedCommand({
    id: 'revealFileInOS',
    category: browser_1.CommonCommands.FILE_CATEGORY,
    label: os_1.isWindows ? 'Reveal in File Explorer' :
        os_1.isOSX ? 'Reveal in Finder' :
            /* linux */ 'Open Containing Folder'
});
exports.OPEN_WITH_SYSTEM_APP = core_1.Command.toDefaultLocalizedCommand({
    id: 'openWithSystemApp',
    category: browser_1.CommonCommands.FILE_CATEGORY,
    label: 'Open With System Editor'
});
let ElectronNavigatorMenuContribution = class ElectronNavigatorMenuContribution {
    registerCommands(commands) {
        commands.registerCommand(exports.OPEN_CONTAINING_FOLDER, uri_command_handler_1.UriAwareCommandHandler.MonoSelect(this.selectionService, {
            execute: async (uri) => {
                window.electronTheiaCore.showItemInFolder(file_uri_1.FileUri.fsPath(uri));
            },
            isEnabled: uri => !!this.workspaceService.getWorkspaceRootUri(uri),
            isVisible: uri => !!this.workspaceService.getWorkspaceRootUri(uri),
        }));
        commands.registerCommand(exports.OPEN_WITH_SYSTEM_APP, uri_command_handler_1.UriAwareCommandHandler.MonoSelect(this.selectionService, {
            execute: async (uri) => {
                this.openWithSystemApplication(uri);
            }
        }));
        this.openWithService.registerHandler({
            id: 'system-editor',
            label: common_1.nls.localize('theia/navigator/systemEditor', 'System Editor'),
            providerName: common_1.nls.localizeByDefault('Built-in'),
            // Low priority to avoid conflicts with other open handlers.
            canHandle: uri => (uri.scheme === 'file') ? 10 : 0,
            open: uri => {
                this.openWithSystemApplication(uri);
                return {};
            }
        });
    }
    openWithSystemApplication(uri) {
        window.electronTheiaCore.openWithSystemApp(file_uri_1.FileUri.fsPath(uri));
    }
    registerMenus(menus) {
        menus.registerMenuAction(navigator_contribution_1.NavigatorContextMenu.NAVIGATION, {
            commandId: exports.OPEN_CONTAINING_FOLDER.id,
            label: exports.OPEN_CONTAINING_FOLDER.label
        });
        menus.registerMenuAction(navigator_contribution_1.SHELL_TABBAR_CONTEXT_REVEAL, {
            commandId: exports.OPEN_CONTAINING_FOLDER.id,
            label: exports.OPEN_CONTAINING_FOLDER.label,
            order: '4'
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: exports.OPEN_CONTAINING_FOLDER.id,
            keybinding: 'ctrlcmd+alt+p',
            when: 'filesExplorerFocus'
        });
    }
    getSelectedFileStatNodes() {
        const navigator = this.tryGetNavigatorWidget();
        return navigator ? navigator.model.selectedNodes.filter(browser_2.FileStatNode.is) : [];
    }
    tryGetNavigatorWidget() {
        return this.widgetManager.tryGetWidget(browser_4.FILE_NAVIGATOR_ID);
    }
};
exports.ElectronNavigatorMenuContribution = ElectronNavigatorMenuContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.SelectionService),
    tslib_1.__metadata("design:type", core_1.SelectionService)
], ElectronNavigatorMenuContribution.prototype, "selectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(widget_manager_1.WidgetManager),
    tslib_1.__metadata("design:type", widget_manager_1.WidgetManager)
], ElectronNavigatorMenuContribution.prototype, "widgetManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.WorkspaceService),
    tslib_1.__metadata("design:type", browser_3.WorkspaceService)
], ElectronNavigatorMenuContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenWithService),
    tslib_1.__metadata("design:type", browser_1.OpenWithService)
], ElectronNavigatorMenuContribution.prototype, "openWithService", void 0);
exports.ElectronNavigatorMenuContribution = ElectronNavigatorMenuContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronNavigatorMenuContribution);


/***/ }),

/***/ "../../node_modules/@theia/navigator/lib/electron-browser/electron-navigator-module.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/navigator/lib/electron-browser/electron-navigator-module.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const electron_navigator_menu_contribution_1 = __webpack_require__(/*! ./electron-navigator-menu-contribution */ "../../node_modules/@theia/navigator/lib/electron-browser/electron-navigator-menu-contribution.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(core_1.MenuContribution).to(electron_navigator_menu_contribution_1.ElectronNavigatorMenuContribution).inSingletonScope();
    bind(core_1.CommandContribution).to(electron_navigator_menu_contribution_1.ElectronNavigatorMenuContribution).inSingletonScope();
    bind(browser_1.KeybindingContribution).to(electron_navigator_menu_contribution_1.ElectronNavigatorMenuContribution).inSingletonScope();
});


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_navigator_lib_electron-browser_electron-navigator-module_js.js.map