/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;

public class WorkspaceState2 {
    public static final String SYSPROP_STATEFILE_LOCATION = "m2e.workspace.state";
    protected final Map<String, String> state;
    private static WorkspaceState2 instance;

    protected WorkspaceState2(Map<String, String> state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
    }

    public Map<String, String> getState() {
        return this.state;
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.state.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public boolean resolveArtifact(Artifact artifact) {
        String extension = artifact.getArtifactHandler().getExtension();
        File file = this.findArtifact(artifact.getGroupId(), artifact.getArtifactId(), extension, artifact.getClassifier(), artifact.getBaseVersion());
        if (file == null) {
            return false;
        }
        artifact.setFile(file);
        artifact.setResolved(true);
        return true;
    }

    public File findArtifact(String groupId, String artifactId, String type, String classifier, String baseVersion) {
        String key;
        String value;
        Map<String, String> state = this.getState();
        if (state.isEmpty()) {
            return null;
        }
        if (classifier == null) {
            classifier = "";
        }
        if ((value = state.get(key = String.valueOf(groupId) + ':' + artifactId + ':' + type + ':' + classifier + ':' + baseVersion)) == null || value.length() == 0) {
            return null;
        }
        File file = new File(value);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public List<String> findVersions(String groupId, String artifactId) {
        Map<String, String> state = this.getState();
        if (state.isEmpty()) {
            return Collections.emptyList();
        }
        String prefix = String.valueOf(groupId) + ':' + artifactId + ':';
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        for (String obj : state.keySet()) {
            String key = obj;
            if (!key.startsWith(prefix)) continue;
            versions.add(key.substring(key.lastIndexOf(58) + 1));
        }
        return new ArrayList<String>(versions);
    }

    public static WorkspaceState2 load() {
        HashMap<String, String> state = new HashMap<String, String>();
        String locations = System.getProperty(SYSPROP_STATEFILE_LOCATION);
        if (locations != null) {
            String[] stringArray = locations.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                WorkspaceState2.load(state, location);
                ++n2;
            }
        }
        return new WorkspaceState2(Collections.unmodifiableMap(state));
    }

    private static void load(Map<String, String> state, String location) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream is = new FileInputStream(location);){
                Properties properties = new Properties();
                properties.load(is);
                for (String key : properties.stringPropertyNames()) {
                    state.put(key, properties.getProperty(key));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static synchronized WorkspaceState2 getInstance() {
        if (instance == null) {
            instance = WorkspaceState2.load();
        }
        return instance;
    }
}

