/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public interface UrlHandlerStrategy {
    public boolean handles(String var1);

    public static abstract class Registry<S extends UrlHandlerStrategy> {
        private final AtomicReference<S> latestMatchingUrlHandler = new AtomicReference();

        protected abstract S[] getUrlHandlers();

        public Optional<S> selectUrlHandler(String url) {
            UrlHandlerStrategy latestHandler = (UrlHandlerStrategy)this.latestMatchingUrlHandler.get();
            if (latestHandler != null && latestHandler.handles(url)) {
                return Optional.of(latestHandler);
            }
            UrlHandlerStrategy[] urlHandlerStrategyArray = this.getUrlHandlers();
            int n = urlHandlerStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                UrlHandlerStrategy handler = urlHandlerStrategyArray[n2];
                if (handler.handles(url)) {
                    this.latestMatchingUrlHandler.compareAndSet(latestHandler, handler);
                    return Optional.of(handler);
                }
                ++n2;
            }
            return Optional.empty();
        }
    }
}

