/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.lib.MutableObjectId;

public final class MidxIterators {
    public static MultiPackIndex.MidxIterator fromPackIndexIterator(String packName, PackIndex idx) {
        return new MidxIteratorOverPackIndex(packName, idx);
    }

    public static MultiPackIndex.MidxIterator join(List<MultiPackIndex.MidxIterator> iterators) {
        return new JoinMidxIterator(iterators);
    }

    public static MultiPackIndex.MidxIterator dedup(MultiPackIndex.MidxIterator source) {
        return new DedupMidxIterator(source);
    }

    private MidxIterators() {
    }

    private static class DedupMidxIterator
    implements MultiPackIndex.MidxIterator {
        private final MultiPackIndex.MidxIterator src;
        private final MutableObjectId lastOid = new MutableObjectId();
        private MultiPackIndex.MutableEntry next;
        private final MultiPackIndex.MutableEntry copy = new MultiPackIndex.MutableEntry();

        DedupMidxIterator(MultiPackIndex.MidxIterator src) {
            this.src = src;
            this.readNext();
        }

        @Override
        public MultiPackIndex.MutableEntry peek() {
            return this.next;
        }

        @Override
        public List<String> getPackNames() {
            return this.src.getPackNames();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MultiPackIndex.MutableEntry next() {
            this.copy.fill(this.next, 0);
            this.readNext();
            return this.copy;
        }

        private void readNext() {
            do {
                if (!this.src.hasNext()) {
                    this.next = null;
                    return;
                }
                this.next = (MultiPackIndex.MutableEntry)this.src.next();
            } while (this.lastOid.equals(this.next.oid));
            this.lastOid.fromObjectId(this.next.oid);
        }

        @Override
        public void reset() {
            this.lastOid.clear();
            this.src.reset();
            this.readNext();
        }
    }

    private static class JoinMidxIterator
    implements MultiPackIndex.MidxIterator {
        private final List<String> packNames;
        private final List<MultiPackIndex.MidxIterator> indexIterators;
        private final int[] packCountAgg;
        private final MultiPackIndex.MutableEntry local = new MultiPackIndex.MutableEntry();

        public JoinMidxIterator(List<MultiPackIndex.MidxIterator> indexIterators) {
            this.indexIterators = indexIterators;
            this.packCountAgg = new int[indexIterators.size()];
            int i = 1;
            while (i < indexIterators.size()) {
                this.packCountAgg[i] = indexIterators.get(i - 1).getPackNames().size() + this.packCountAgg[i - 1];
                ++i;
            }
            this.packNames = indexIterators.stream().map(MultiPackIndex.MidxIterator::getPackNames).flatMap(Collection::stream).toList();
        }

        @Override
        public MultiPackIndex.MutableEntry peek() {
            int p = this.best();
            MultiPackIndex.MidxIterator it = this.indexIterators.get(p);
            return this.shiftPackId(it.peek(), this.packCountAgg[p]);
        }

        @Override
        public List<String> getPackNames() {
            return this.packNames;
        }

        @Override
        public boolean hasNext() {
            return this.indexIterators.stream().anyMatch(Iterator::hasNext);
        }

        @Override
        public MultiPackIndex.MutableEntry next() {
            int p = this.best();
            MultiPackIndex.MidxIterator it = this.indexIterators.get(p);
            return this.shiftPackId((MultiPackIndex.MutableEntry)it.next(), this.packCountAgg[p]);
        }

        private MultiPackIndex.MutableEntry shiftPackId(MultiPackIndex.MutableEntry entry, int shift) {
            this.local.fill(entry, shift);
            return this.local;
        }

        private int best() {
            int winnerPos = -1;
            MultiPackIndex.MidxIterator winner = null;
            int index = 0;
            while (index < this.indexIterators.size()) {
                MultiPackIndex.MidxIterator current = this.indexIterators.get(index);
                if (current.hasNext() && (winner == null || current.peek().compareTo(winner.peek()) < 0)) {
                    winner = current;
                    winnerPos = index;
                }
                ++index;
            }
            if (winner == null) {
                throw new NoSuchElementException();
            }
            return winnerPos;
        }

        @Override
        public void reset() {
            this.indexIterators.stream().forEach(MultiPackIndex.MidxIterator::reset);
            this.local.clear();
        }
    }

    private static class MidxIteratorOverPackIndex
    implements MultiPackIndex.MidxIterator {
        private final List<String> packNames;
        private final PackIndex idx;
        private Iterator<PackIndex.MutableEntry> idxIt;
        private boolean peeked;
        private final MultiPackIndex.MutableEntry entry = new MultiPackIndex.MutableEntry();

        MidxIteratorOverPackIndex(String packName, PackIndex idx) {
            this.packNames = List.of(packName);
            this.idx = idx;
            this.idxIt = idx.iterator();
        }

        @Override
        public MultiPackIndex.MutableEntry peek() {
            if (this.peeked) {
                return this.entry;
            }
            this.peeked = true;
            this.readNext();
            return this.entry;
        }

        @Override
        public List<String> getPackNames() {
            return this.packNames;
        }

        @Override
        public boolean hasNext() {
            if (this.peeked) {
                return true;
            }
            return this.idxIt.hasNext();
        }

        @Override
        public MultiPackIndex.MutableEntry next() {
            if (this.peeked) {
                this.peeked = false;
                return this.entry;
            }
            this.readNext();
            return this.entry;
        }

        private void readNext() {
            PackIndex.MutableEntry idx = this.idxIt.next();
            idx.copyOidTo(this.entry.oid);
            this.entry.packOffset.setValues(0, idx.getOffset());
        }

        @Override
        public void reset() {
            this.idxIt = this.idx.iterator();
            this.entry.clear();
            this.peeked = false;
        }
    }
}

