/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.parts.composer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.Dependencies;
import org.eclipse.php.composer.ui.parts.composer.DependencySearchPart;
import org.eclipse.php.composer.ui.parts.composer.DependencySelectionFinishedListener;
import org.eclipse.php.composer.ui.parts.composer.PackageSearch;
import org.eclipse.php.composer.ui.parts.composer.PackageSearchPart;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Twistie;

public class DependencySearch
extends PackageSearch {
    protected List<DependencySelectionFinishedListener> dependencyListeners = new ArrayList<DependencySelectionFinishedListener>();
    private boolean collapsing = false;

    public DependencySearch(Composite parent, ComposerPackage composerPackage, FormToolkit toolkit, String buttonText) {
        super(parent, composerPackage, toolkit, buttonText);
    }

    public DependencySearch(Composite parent, ComposerPackage composerPackage, FormToolkit toolkit) {
        super(parent, composerPackage, toolkit);
    }

    public DependencySearch(Composite parent, ComposerPackage composerPackage, String buttonText) {
        super(parent, composerPackage, buttonText);
    }

    public DependencySearch(Composite parent, ComposerPackage composerPackage) {
        super(parent, composerPackage);
    }

    public void addDependencySelectionFinishedListener(DependencySelectionFinishedListener listener) {
        if (!this.dependencyListeners.contains(listener)) {
            this.dependencyListeners.add(listener);
        }
    }

    public void removeDependencySelectionFinishedListener(DependencySelectionFinishedListener listener) {
        this.dependencyListeners.remove(listener);
    }

    @Override
    protected void create(Composite parent, FormToolkit toolkit, String buttonText) {
        super.create(parent, toolkit, buttonText);
        if (this.addButton != null) {
            this.addButton.removeSelectionListener((SelectionListener)this.addButtonListener);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DependencySearch.this.notifyDependencySelectionFinishedListener();
                }
            });
        }
    }

    protected void notifyDependencySelectionFinishedListener() {
        Dependencies deps = this.getDependencies();
        for (DependencySelectionFinishedListener listener : this.dependencyListeners) {
            listener.dependenciesSelected(deps);
        }
        this.clear();
    }

    public Dependencies getDependencies() {
        Dependencies deps = new Dependencies();
        for (PackageSearchPart psp : this.packageControls.values()) {
            VersionedPackage pkg = ((DependencySearchPart)psp).getPackage();
            if (pkg.getVersion().isEmpty()) continue;
            deps.add(pkg);
        }
        return deps;
    }

    @Override
    protected DependencySearchPart createPackagePart(Composite parent, String name) {
        DependencySearchPart dsp = new DependencySearchPart(parent, this.composerPackage, this.toolkit, name);
        dsp.addToggleListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (!DependencySearch.this.collapsing) {
                    Twistie toggle = (Twistie)e.getSource();
                    DependencySearchPart dsp = (DependencySearchPart)toggle.getData();
                    DependencySearch.this.setExpanded(dsp, toggle.isExpanded());
                }
            }
        });
        dsp.getVersionControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Text version = (Text)e.getSource();
                DependencySearchPart dsp = (DependencySearchPart)version.getData();
                DependencySearch.this.setExpanded(dsp, true);
            }
        });
        dsp.getVersionControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean canFinish = true;
                for (PackageSearchPart psp : DependencySearch.this.packageControls.values()) {
                    boolean bl = canFinish = canFinish && !((DependencySearchPart)psp).getVersionControl().getText().isEmpty();
                }
                DependencySearch.this.addButton.setEnabled(canFinish && DependencySearch.this.enabled);
            }
        });
        return dsp;
    }

    private void setExpanded(DependencySearchPart dsp, boolean expanded) {
        if (expanded) {
            this.collapsing = true;
            for (PackageSearchPart psp : this.packageControls.values()) {
                ((DependencySearchPart)psp).setExpanded(false);
            }
            this.collapsing = false;
        }
        dsp.setExpanded(expanded);
        this.getBody().layout(true, true);
    }
}

