/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.IFileContentGenerator;
import org.eclipse.lemminx.extensions.generators.xml2dtd.DTDGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.xml2dtd.XML2DTDGenerator;
import org.eclipse.lemminx.extensions.generators.xml2relaxng.RelaxNGGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.xml2relaxng.XML2RelaxNGGenerator;
import org.eclipse.lemminx.extensions.generators.xml2xsd.XML2XMLSchemaGenerator;
import org.eclipse.lemminx.extensions.generators.xml2xsd.XMLSchemaGeneratorSettings;
import org.eclipse.lemminx.services.IXMLFullFormatter;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class FileContentGeneratorManager {
    private final Map<Class<? extends FileContentGeneratorSettings>, IFileContentGenerator<?, ?>> generators = new HashMap();
    private final IXMLFullFormatter formatter;

    public FileContentGeneratorManager(IXMLFullFormatter formatter) {
        this.formatter = formatter;
        this.registerDefaultGenerators();
    }

    private void registerDefaultGenerators() {
        this.registerGenerator(new XML2DTDGenerator(), DTDGeneratorSettings.class);
        this.registerGenerator(new XML2XMLSchemaGenerator(), XMLSchemaGeneratorSettings.class);
        this.registerGenerator(new XML2RelaxNGGenerator(), RelaxNGGeneratorSettings.class);
    }

    public void registerGenerator(IFileContentGenerator<?, ?> generator, Class<? extends FileContentGeneratorSettings> generatorKey) {
        this.generators.put(generatorKey, generator);
    }

    public <Source, Settings extends FileContentGeneratorSettings> String generate(Source document, SharedSettings sharedSettings, Settings generatorSettings, CancelChecker cancelChecker) {
        IFileContentGenerator<?, ?> generator = this.generators.get(generatorSettings.getClass());
        return generator.generate(document, sharedSettings, generatorSettings, this.formatter, cancelChecker);
    }
}

