/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.text.edits.TextEditGroup;

public class UnwrapNewArrayOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private final ArrayCreation node;
    private final Expression call;

    public UnwrapNewArrayOperation(ArrayCreation node, Expression call) {
        this.node = node;
        this.call = call;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        List expressionsInArray = this.node != null && this.node.getInitializer() != null && this.node.getInitializer().expressions() != null ? this.node.getInitializer().expressions() : Collections.EMPTY_LIST;
        ArrayType arrayType = this.node != null ? this.node.getType() : null;
        ICompilationUnit cu = cuRewrite.getCu();
        CompilationUnit root = cuRewrite.getRoot();
        ImportRemover remover = cuRewrite.getImportRemover();
        boolean commented = false;
        List comments = root.getCommentList();
        int callExtendedEnd = root.getExtendedStartPosition((ASTNode)this.call) + root.getExtendedLength((ASTNode)this.call);
        for (Comment comment : comments) {
            if (comment.getStartPosition() <= this.call.getStartPosition() || comment.getStartPosition() >= callExtendedEnd) continue;
            commented = true;
            break;
        }
        TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveUnnecessaryArrayCreation_description, cuRewrite);
        if (!commented) {
            ListRewrite listRewrite;
            if (this.call instanceof ClassInstanceCreation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            } else if (this.call instanceof MethodInvocation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, MethodInvocation.ARGUMENTS_PROPERTY);
            } else if (this.call instanceof SuperMethodInvocation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, SuperMethodInvocation.ARGUMENTS_PROPERTY);
            } else {
                return;
            }
            if (this.node.getInitializer() != null && this.node.getInitializer().expressions() != null) {
                int i = 1;
                while (i < expressionsInArray.size()) {
                    listRewrite.insertLast((ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(i)), group);
                    ++i;
                }
                if (expressionsInArray.isEmpty()) {
                    listRewrite.remove((ASTNode)this.node, group);
                } else {
                    listRewrite.replace((ASTNode)this.node, (ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(0)), group);
                }
            } else {
                listRewrite.remove((ASTNode)this.node, group);
            }
        } else {
            StringBuilder buf = new StringBuilder();
            CompilationUnit comp = (CompilationUnit)this.call.getRoot();
            int nodeStart = comp.getExtendedStartPosition((ASTNode)this.call);
            int nodeEnd = comp.getExtendedStartPosition((ASTNode)this.call) + comp.getExtendedLength((ASTNode)this.call);
            int arrayStart = this.node.getStartPosition();
            List expressionList = this.node.getInitializer().expressions();
            int arrayExpressionStart = comp.getExtendedStartPosition((ASTNode)expressionList.get(0));
            IBuffer cuBuffer = cu.getBuffer();
            String arrayStartString = cuBuffer.getText(arrayStart, arrayExpressionStart - arrayStart);
            int index = arrayStartString.indexOf(123) + 1;
            while (index < arrayStartString.length() && (arrayStartString.charAt(index) == ' ' || arrayStartString.charAt(index) == '\t')) {
                ++index;
            }
            arrayExpressionStart = arrayStart + index;
            int arrayInitializerEnd = this.node.getInitializer().getStartPosition() + this.node.getInitializer().getLength();
            buf.append(cuBuffer.getText(nodeStart, arrayStart - nodeStart));
            int currentLine = root.getLineNumber(arrayExpressionStart);
            int currentPos = arrayExpressionStart;
            int nextLinePos = root.getPosition(++currentLine, 0);
            String tab = this.getTab(cu);
            String prepend = "";
            while (nextLinePos < arrayInitializerEnd) {
                buf.append(prepend);
                buf.append(cuBuffer.getText(currentPos, nextLinePos - currentPos));
                currentPos = nextLinePos;
                while (cuBuffer.getChar(currentPos) == '\t' || cuBuffer.getChar(currentPos) == ' ') {
                    ++currentPos;
                }
                nextLinePos = root.getPosition(++currentLine, 0);
                prepend = tab;
            }
            if (currentPos < arrayInitializerEnd) {
                Expression lastExpression = (Expression)expressionList.get(expressionList.size() - 1);
                int lastExpressionEnd = root.getExtendedStartPosition((ASTNode)lastExpression) + root.getExtendedLength((ASTNode)lastExpression);
                if (root.getLineNumber(arrayInitializerEnd) == root.getLineNumber(lastExpressionEnd)) {
                    buf.append(prepend);
                }
                buf.append(cuBuffer.getText(currentPos, arrayInitializerEnd - currentPos - 1));
            }
            buf.append(cuBuffer.getText(arrayInitializerEnd, nodeEnd - arrayInitializerEnd));
            ASTNode replacementNode = null;
            if (this.call instanceof ClassInstanceCreation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 14);
            } else if (this.call instanceof MethodInvocation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 32);
            } else if (this.call instanceof SuperMethodInvocation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 48);
            } else {
                return;
            }
            rewrite.replace((ASTNode)this.call, replacementNode, group);
        }
        if (arrayType != null) {
            remover.registerRemovedNode((ASTNode)arrayType);
        }
    }

    private String getTab(ICompilationUnit cu) {
        String tabChar = (String)cu.getOptions(true).get("org.eclipse.jdt.core.formatter.tabulation.char");
        if ("tab".equals(tabChar) || "mixed".equals(tabChar)) {
            return "\t\t";
        }
        int tabSize = Integer.parseInt((String)cu.getOptions(true).get("org.eclipse.jdt.core.formatter.tabulation.size"));
        return " ".repeat(tabSize * 2);
    }
}

