/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.AccessorAdapter;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.ITypedElement;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategy;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategyProvider;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.SingleValuedAttributeModelUpdateStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public abstract class CompareInputAdapter
extends AdapterImpl
implements ICompareInput,
IDisposable,
IAdaptable {
    private static final org.eclipse.compare.ITypedElement NULL_ELEMENT = AccessorAdapter.adapt(null);
    private final ListenerList fListener;
    private final AdapterFactory fAdapterFactory;
    private final ExtendedAdapterFactoryItemDelegator itemDelegator;
    private IDeferredWorkbenchAdapter deferredWorkbenchAdapter;
    private IModelUpdateStrategyProvider modelUpdateStrategyProvider;
    private org.eclipse.compare.ITypedElement ancestor = NULL_ELEMENT;
    private org.eclipse.compare.ITypedElement left = NULL_ELEMENT;
    private org.eclipse.compare.ITypedElement right = NULL_ELEMENT;

    public CompareInputAdapter(AdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
        this.itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());
        this.fListener = new ListenerList();
    }

    public boolean isAdapterForType(Object type) {
        return type == this.fAdapterFactory;
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    protected final AdapterFactory getRootAdapterFactory() {
        if (this.fAdapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)this.fAdapterFactory).getRootAdapterFactory();
        }
        return this.fAdapterFactory;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireChange() {
        if (this.fListener != null) {
            Object[] listeners = this.fListener.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)listeners[i];
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)CompareInputAdapter.this);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++i;
            }
        }
    }

    public EObject getComparisonObject() {
        if (this.getTarget() != null) {
            return ((TreeNode)this.getTarget()).getData();
        }
        return null;
    }

    public void copy(boolean leftToRight) {
    }

    protected IAccessorFactory getAccessorFactoryForTarget() {
        IAccessorFactory.Registry factoryRegistry = EMFCompareRCPUIPlugin.getDefault().getAccessorFactoryRegistry();
        return factoryRegistry.getHighestRankingFactory((Object)this.getComparisonObject());
    }

    public Image getImage() {
        Object imageObject = this.itemDelegator.getImage((Object)this.getComparisonObject());
        return ExtendedImageRegistry.getInstance().getImage(imageObject);
    }

    public int getKind() {
        EObject notifier = this.getComparisonObject();
        boolean isThreeWay = this.isThreeWay((Notifier)notifier);
        if (isThreeWay) {
            return 12;
        }
        return 0;
    }

    public String getName() {
        return this.itemDelegator.getText((Object)this.getComparisonObject());
    }

    public org.eclipse.compare.ITypedElement getAncestor() {
        if (this.ancestor == NULL_ELEMENT) {
            ITypedElement typedElement;
            IAccessorFactory accessorFactory;
            EObject notifier = this.getComparisonObject();
            boolean isThreeWay = this.isThreeWay((Notifier)notifier);
            this.ancestor = isThreeWay ? ((accessorFactory = this.getAccessorFactoryForTarget()) != null ? ((typedElement = accessorFactory.createAncestor(this.getAdapterFactory(), (Object)this.getComparisonObject())) != null ? AccessorAdapter.adapt(typedElement) : null) : null) : null;
        }
        return this.ancestor;
    }

    protected boolean isThreeWay(Notifier notifier) {
        boolean isThreeWay = notifier instanceof Diff ? (((Diff)notifier).eContainer() instanceof MatchResource ? ((MatchResource)((Diff)notifier).eContainer()).getComparison().isThreeWay() : ComparisonUtil.getComparison((Diff)((Diff)notifier)).isThreeWay()) : (notifier instanceof Match ? ((Match)notifier).getComparison().isThreeWay() : (notifier instanceof Conflict ? true : (notifier instanceof MatchResource ? ((MatchResource)notifier).getComparison().isThreeWay() : (notifier instanceof Comparison ? ((Comparison)notifier).isThreeWay() : false))));
        return isThreeWay;
    }

    public org.eclipse.compare.ITypedElement getLeft() {
        if (this.left == NULL_ELEMENT) {
            ITypedElement typedElement;
            IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
            this.left = accessorFactory != null ? ((typedElement = accessorFactory.createLeft(this.getAdapterFactory(), (Object)this.getComparisonObject())) != null ? AccessorAdapter.adapt(typedElement) : null) : null;
        }
        return this.left;
    }

    public org.eclipse.compare.ITypedElement getRight() {
        if (this.right == NULL_ELEMENT) {
            ITypedElement typedElement;
            IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
            this.right = accessorFactory != null ? ((typedElement = accessorFactory.createRight(this.getAdapterFactory(), (Object)this.getComparisonObject())) != null ? AccessorAdapter.adapt(typedElement) : null) : null;
        }
        return this.right;
    }

    public void dispose() {
        Notifier oldTarget = this.target;
        this.target = null;
        if (oldTarget != null) {
            oldTarget.eAdapters().remove((Object)this);
        }
        this.deferredWorkbenchAdapter = null;
        this.modelUpdateStrategyProvider = null;
    }

    public void setDeferredAdapter(IDeferredWorkbenchAdapter deferredWorkbenchAdapter) {
        this.deferredWorkbenchAdapter = deferredWorkbenchAdapter;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDeferredWorkbenchAdapter.class) {
            return this.deferredWorkbenchAdapter;
        }
        return null;
    }

    public IModelUpdateStrategy getModelUpdateStrategy() {
        if (this.modelUpdateStrategyProvider == null) {
            this.modelUpdateStrategyProvider = this.createModelUpdateStrategyProvider();
        }
        return this.modelUpdateStrategyProvider.getModelUpdateStrategy();
    }

    private IModelUpdateStrategyProvider createModelUpdateStrategyProvider() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        IModelUpdateStrategyProvider ret = accessorFactory instanceof IModelUpdateStrategyProvider ? (IModelUpdateStrategyProvider)accessorFactory : new IModelUpdateStrategyProvider(){

            public IModelUpdateStrategy getModelUpdateStrategy() {
                return new SingleValuedAttributeModelUpdateStrategy();
            }
        };
        return ret;
    }
}

