/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractOverviewSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OverviewNavigationSection
extends AbstractOverviewSection {
    private static final int COLUMN_WITH = 70;
    private OverviewNavigationSectionAdapter overviewNavigationSectionAdapter;

    public OverviewNavigationSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, "org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor", EditorMessages.OverviewPage_NavigationSection_name, EditorMessages.OverviewPage_NavigationSection_description, null, null);
    }

    @Override
    protected void configTableViewer(TableViewer tableViewer1) {
        tableViewer1.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List navigationCaseList = (List)inputElement;
                return navigationCaseList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer1.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                NavigationCaseType navigationCase = (NavigationCaseType)element;
                switch (columnIndex) {
                    case 0: {
                        return ((NavigationRuleType)navigationCase.eContainer()).getFromViewId() == null ? "" : ((NavigationRuleType)navigationCase.eContainer()).getFromViewId().getTextContent();
                    }
                    case 1: {
                        return navigationCase.getFromOutcome() == null ? "" : navigationCase.getFromOutcome().getTextContent();
                    }
                    case 2: {
                        return navigationCase.getToViewId() == null ? "" : navigationCase.getToViewId().getTextContent();
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    @Override
    protected Table createTable(Composite container) {
        Table table = new Table(container, 68352);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tablelayout = new TableLayout();
        table.setLayout((Layout)tablelayout);
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(EditorMessages.OverviewPage_NavigationSection_table_col1);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 70, true));
        column1.setResizable(true);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(EditorMessages.OverviewPage_NavigationSection_table_col2);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 70, true));
        column2.setResizable(true);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(EditorMessages.OverviewPage_NavigationSection_table_col3);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 70, true));
        column3.setResizable(true);
        return table;
    }

    @Override
    public void refreshAll() {
        ArrayList navigationCaseList = new ArrayList();
        if (this.getInput() instanceof FacesConfigType) {
            EList navigationRules = ((FacesConfigType)this.getInput()).getNavigationRule();
            int i = 0;
            int n = navigationRules.size();
            while (i < n) {
                NavigationRuleType navigationRule = (NavigationRuleType)navigationRules.get(i);
                navigationCaseList.addAll(navigationRule.getNavigationCase());
                ++i;
            }
        }
        this.tableViewer.setInput(navigationCaseList);
    }

    @Override
    protected void addAdaptersOntoInput(Object newInput) {
        FacesConfigType facesConfig = (FacesConfigType)newInput;
        this.addOverviewNavigationSectionAdapter((EObject)facesConfig);
        for (NavigationRuleType navigationRule : facesConfig.getNavigationRule()) {
            this.addOverviewNavigationSectionAdapter((EObject)navigationRule);
            if (navigationRule.getFromViewId() != null) {
                this.addOverviewNavigationSectionAdapter((EObject)navigationRule.getFromViewId());
            }
            for (NavigationCaseType navigationCase : navigationRule.getNavigationCase()) {
                this.addOverviewNavigationSectionAdapter((EObject)navigationCase);
                if (navigationCase.getFromOutcome() != null) {
                    this.addOverviewNavigationSectionAdapter((EObject)navigationCase.getFromOutcome());
                }
                if (navigationCase.getToViewId() == null) continue;
                this.addOverviewNavigationSectionAdapter((EObject)navigationCase.getToViewId());
            }
        }
    }

    @Override
    protected void removeAdaptersFromInput(Object oldInput) {
        super.removeAdaptersFromInput(oldInput);
        FacesConfigType facesConfig = (FacesConfigType)oldInput;
        this.removeOverviewNavigationSectionAdapter((EObject)facesConfig);
        for (NavigationRuleType navigationRule : facesConfig.getNavigationRule()) {
            this.removeOverviewNavigationSectionAdapter((EObject)navigationRule);
            if (navigationRule.getFromViewId() != null) {
                this.removeOverviewNavigationSectionAdapter((EObject)navigationRule.getFromViewId());
            }
            for (NavigationCaseType navigationCase : navigationRule.getNavigationCase()) {
                this.removeOverviewNavigationSectionAdapter((EObject)navigationCase);
                if (navigationCase.getFromOutcome() != null) {
                    this.removeOverviewNavigationSectionAdapter((EObject)navigationCase.getFromOutcome());
                }
                if (navigationCase.getToViewId() == null) continue;
                this.removeOverviewNavigationSectionAdapter((EObject)navigationCase.getToViewId());
            }
        }
    }

    private void addOverviewNavigationSectionAdapter(EObject object) {
        if (EcoreUtil.getExistingAdapter((Notifier)object, OverviewNavigationSection.class) == null) {
            object.eAdapters().add((Object)this.getOverviewNavigationSectionAdapter());
        }
    }

    private void removeOverviewNavigationSectionAdapter(EObject object) {
        if (object != null && EcoreUtil.getExistingAdapter((Notifier)object, OverviewNavigationSection.class) != null) {
            object.eAdapters().remove((Object)this.getOverviewNavigationSectionAdapter());
        }
    }

    private OverviewNavigationSectionAdapter getOverviewNavigationSectionAdapter() {
        if (this.overviewNavigationSectionAdapter == null) {
            this.overviewNavigationSectionAdapter = new OverviewNavigationSectionAdapter();
        }
        return this.overviewNavigationSectionAdapter;
    }

    class OverviewNavigationSectionAdapter
    extends AdapterImpl {
        OverviewNavigationSectionAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == OverviewNavigationSection.class;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getFacesConfigType_NavigationRule() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getNavigationRuleType_NavigationCase() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getNavigationRuleType_FromViewId() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getFromViewIdType_TextContent()) {
                if ((msg.getEventType() == 3 || msg.getEventType() == 1) && msg.getNewValue() instanceof EObject) {
                    EObject newObject = (EObject)msg.getNewValue();
                    OverviewNavigationSection.this.addOverviewNavigationSectionAdapter(newObject);
                }
                if (msg.getEventType() == 3 || msg.getEventType() == 4 || msg.getEventType() == 1) {
                    if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                        OverviewNavigationSection.this.refreshAll();
                    } else {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                OverviewNavigationSection.this.refreshAll();
                            }
                        });
                    }
                }
                return;
            }
            if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getNavigationCaseType_FromOutcome() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getNavigationCaseType_ToViewId()) {
                if ((msg.getEventType() == 3 || msg.getEventType() == 1) && msg.getNewValue() instanceof EObject) {
                    EObject newObject = (EObject)msg.getNewValue();
                    OverviewNavigationSection.this.addOverviewNavigationSectionAdapter(newObject);
                }
                if (msg.getEventType() == 3 || msg.getEventType() == 4 || msg.getEventType() == 1) {
                    NavigationCaseType navigationCase = (NavigationCaseType)msg.getNotifier();
                    this.refreshViewerOnUIThread(navigationCase);
                }
                return;
            }
            if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getFromOutcomeType_TextContent() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getToViewIdType_TextContent()) {
                if (msg.getEventType() == 3 || msg.getEventType() == 4 || msg.getEventType() == 1) {
                    NavigationCaseType navigationCase = (NavigationCaseType)((EObject)msg.getNotifier()).eContainer();
                    this.refreshViewerOnUIThread(navigationCase);
                }
                return;
            }
        }

        private void refreshViewerOnUIThread(final NavigationCaseType navigationCase) {
            if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                OverviewNavigationSection.this.tableViewer.refresh((Object)navigationCase);
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((OverviewNavigationSectionAdapter)OverviewNavigationSectionAdapter.this).OverviewNavigationSection.this.tableViewer.refresh((Object)navigationCase);
                    }
                });
            }
        }
    }
}

