/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.tm4e.ui.internal.themes.AbstractThemeManager;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.osgi.service.prefs.BackingStoreException;

final class WorkingCopyThemeManager
extends AbstractThemeManager
implements IThemeManager.EditSession {
    private final ThemeManager manager;
    private final Set<ITheme> themesAdded = new HashSet<ITheme>();
    private final Set<ITheme> themesRemoved = new HashSet<ITheme>();
    private final Set<IThemeAssociation> associationsAdded = new HashSet<IThemeAssociation>();
    private final Set<IThemeAssociation> associationsRemoved = new HashSet<IThemeAssociation>();
    private boolean isDefaultDarkThemeModified = false;
    private boolean isDefaultLightThemeModified = false;
    private boolean isDirty = false;

    WorkingCopyThemeManager(ThemeManager manager) {
        this.manager = manager;
        this.reset();
    }

    @Override
    public void reset() {
        this.themes.clear();
        this.themes.putAll(this.manager.themes);
        this.darkThemeAssociations.clear();
        this.darkThemeAssociations.putAll(this.manager.darkThemeAssociations);
        this.lightThemeAssociations.clear();
        this.lightThemeAssociations.putAll(this.manager.lightThemeAssociations);
        this.themesAdded.clear();
        this.themesRemoved.clear();
        this.associationsAdded.clear();
        this.associationsRemoved.clear();
        this.defaultDarkThemeId = this.manager.defaultDarkThemeId;
        this.defaultLightThemeId = this.manager.defaultLightThemeId;
        this.isDirty = false;
    }

    @Override
    public void registerTheme(ITheme theme) {
        super.registerTheme(theme);
        this.themesRemoved.remove(theme);
        this.themesAdded.add(theme);
        this.isDirty = true;
    }

    @Override
    public void unregisterTheme(ITheme theme) {
        super.unregisterTheme(theme);
        this.themesAdded.remove(theme);
        this.themesRemoved.add(theme);
        this.isDirty = true;
    }

    @Override
    public void registerThemeAssociation(IThemeAssociation association) {
        super.registerThemeAssociation(association);
        this.associationsRemoved.remove(association);
        this.associationsAdded.add(association);
        this.isDirty = true;
    }

    @Override
    public void unregisterThemeAssociation(IThemeAssociation association) {
        super.unregisterThemeAssociation(association);
        this.associationsAdded.remove(association);
        this.associationsRemoved.add(association);
        this.isDirty = true;
    }

    @Override
    public void setDefaultTheme(String themeId, boolean dark) {
        super.setDefaultTheme(themeId, dark);
        if (dark) {
            this.isDefaultDarkThemeModified = true;
        } else {
            this.isDefaultLightThemeModified = true;
        }
        this.isDirty = true;
    }

    @Override
    public void save() throws BackingStoreException {
        if (!this.isDirty) {
            return;
        }
        this.themesRemoved.forEach(this.manager::unregisterTheme);
        this.themesAdded.forEach(this.manager::registerTheme);
        this.associationsRemoved.forEach(this.manager::unregisterThemeAssociation);
        this.associationsAdded.forEach(this.manager::registerThemeAssociation);
        if (this.isDefaultDarkThemeModified) {
            this.manager.defaultDarkThemeId = this.defaultDarkThemeId;
        }
        if (this.isDefaultLightThemeModified) {
            this.manager.defaultLightThemeId = this.defaultLightThemeId;
        }
        this.manager.save();
        this.reset();
    }
}

