/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public final class UriSelector
implements DiscoverySelector {
    private final URI uri;

    UriSelector(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriSelector that = (UriSelector)o;
        return Objects.equals(this.uri, that.uri);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uri", (Object)this.uri).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return Optional.of(DiscoverySelectorIdentifier.create("uri", this.uri.toString()));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "uri";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<UriSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectUri(identifier.getValue()));
        }
    }
}

