/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.http.CommonHttpMethod3;

public class CommonHeadMethod3
extends HeadMethod
implements CommonHttpMethod3 {
    private boolean gzipAccepted;
    private final Object releaseLock = new Object();

    public CommonHeadMethod3() {
        this.init();
    }

    public CommonHeadMethod3(String requestPath) {
        super(requestPath);
        this.init();
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
        if (this.gzipAccepted) {
            this.setRequestHeader("Accept-encoding", "gzip");
        }
        return super.execute(state, conn);
    }

    @Override
    public InputStream getResponseBodyAsStream(IProgressMonitor monitor) throws IOException {
        return null;
    }

    private void init() {
        this.gzipAccepted = true;
    }

    public final boolean isGzipAccepted() {
        return this.gzipAccepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection() {
        Object object = this.releaseLock;
        synchronized (object) {
            super.releaseConnection();
        }
    }

    @Override
    public void releaseConnection(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            this.abort();
        }
        try {
            this.releaseConnection();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final void setGzipAccepted(boolean gzipAccepted) {
        this.gzipAccepted = gzipAccepted;
    }
}

