/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.snippets;

import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.snippets.IXMLSnippetContext;
import org.eclipse.lemminx.utils.DOMUtils;

public abstract class NewFileSnippetContext
implements IXMLSnippetContext {
    public static final IXMLSnippetContext XML_CONTEXT = new NewFileSnippetContext(){

        @Override
        protected boolean isMatchType(DOMDocument document) {
            return !document.isDTD() && !DOMUtils.isXSD(document) && !DOMUtils.isRelaxNG(document) && !DOMUtils.isXSL(document);
        }
    };
    public static final IXMLSnippetContext XSD_CONTEXT = new NewFileSnippetContext(){

        @Override
        protected boolean isMatchType(DOMDocument document) {
            return DOMUtils.isXSD(document);
        }
    };
    public static final IXMLSnippetContext DTD_CONTEXT = new NewFileSnippetContext(){

        @Override
        protected boolean isMatchType(DOMDocument document) {
            return document.isDTD();
        }
    };
    public static final IXMLSnippetContext RNG_CONTEXT = new NewFileSnippetContext(){

        @Override
        protected boolean isMatchType(DOMDocument document) {
            return DOMUtils.isRelaxNG(document);
        }
    };
    public static final IXMLSnippetContext XSL_CONTEXT = new NewFileSnippetContext(){

        @Override
        protected boolean isMatchType(DOMDocument document) {
            return DOMUtils.isXSL(document);
        }
    };

    @Override
    public boolean isMatch(ICompletionRequest request, Map<String, String> model) {
        DOMDocument document = request.getXMLDocument();
        if (!this.isMatchType(document)) {
            return false;
        }
        if (!document.hasChildNodes()) {
            return true;
        }
        DOMNode node = request.getNode();
        int offset = request.getOffset();
        if ((node.isComment() || node.isProcessingInstruction() || node.isProlog()) && offset < node.getEnd()) {
            return false;
        }
        if (document.isBeforeProlog(offset)) {
            return false;
        }
        for (DOMNode child : document.getChildren()) {
            DOMElement first;
            if (!(child.isElement() ? !(first = (DOMElement)child).isElement() || first.getTagName() != null || first.hasChildNodes() : !child.isText() && !child.isProlog() && !child.isProcessingInstruction() && !child.isComment())) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isMatchType(DOMDocument var1);
}

